package axeldjaha.sms.service;

import android.app.IntentService;
import android.app.PendingIntent;
import android.content.Intent;
import android.telephony.SmsManager;

import java.util.ArrayList;

import axeldjaha.sms.model.Sim;
import axeldjaha.sms.model.Sms;

/**
 * Created by AXEL DJAHA on 06/03/2017.
 */
public class SendSmsService extends IntentService
{
    public static final String TAG = "SendSmsService";

    /**
     * nous servira à lancer un message de broadcast que seule l'application de
     * package 'applicationPackageName' peut recevoir
     */
    private String applicationPackageName;
    /**
     * Permettront d'envoyer un message de broadcast lorsque
     * l'envoi du message est réussi ou a échoué
     */
    private PendingIntent sentPendingIntent;


    //contructeur sans argument: obligatoire
    public SendSmsService()
    {
        super("send-sms-service");
    }

    /**
     * Le service démarre juste pour envoyer le message de tracking
     * au numéro clientesPhones
     */
    @Override
    protected void onHandleIntent(Intent intent)
    {
        sendSMS(intent);
    }

    private void sendSMS(Intent intent)
    {
        //sms à envoyer
        Sms sms = intent.getParcelableExtra("sms");

        //carte sim sélectionnée
        Sim sim = intent.getParcelableExtra("sim");

        this.applicationPackageName = intent.getStringExtra("packageName");

        SmsManager smsManager = SmsManager.getDefault();

        //le smsContent peut dépasser 160 caractères. Et donc on le divise en partie
        ArrayList<String>  smsBodyParts = smsManager.divideMessage(sms.getMessage());

        this.sentPendingIntent =
                PendingIntent.getBroadcast(this, 0, new Intent(this.applicationPackageName), 0);

        ArrayList<PendingIntent> sentPendingIntents = new ArrayList<>();
        sentPendingIntents.add(this.sentPendingIntent);

        /**
         * Le 4è paramètre de sendTextMessage permettra d'envoyer un message de
         * broadcast lorsque l'envoi du message est réussi ou a échoué.
         */
        smsManager.getSmsManagerForSubscriptionId(sim.getId())
                .sendMultipartTextMessage(sms.getPhoneNumber(), null, smsBodyParts, sentPendingIntents, null);
    }
}