package axeldjaha.sms.fragment;

import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;

import java.util.ArrayList;

import axeldjaha.sms.adapter.SimCardAdapter;
import axeldjaha.sms.model.Sim;
import axeldjaha.sms.Interface.OnSimCardListener;
import axeldjaha.sms.R;

/**
 * Created by AXEL DJAHA on 22/04/2017.
 */

public class SimDialogFragment extends DialogFragment
{
    public static final String TAG = "SimDialogFragment";

    private OnSimCardListener listener;

    private ArrayList<Sim> simCardArrayList;

    public static SimDialogFragment newIntance(ArrayList<Sim> sims, OnSimCardListener listener)
    {
        SimDialogFragment simDialogFragment = new SimDialogFragment();
        simDialogFragment.simCardArrayList = sims;
        simDialogFragment.listener = listener;

        return simDialogFragment;
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState)
    {
        AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(getActivity());

        alertDialogBuilder.setTitle("Envoyer avec");

        //vue personnalisée
        final View view = LayoutInflater.from(getContext()).inflate(R.layout.simcard_dialog, null, false);
        alertDialogBuilder.setView(view);

        //liste de cartes SIM
        final ListView listView = (ListView) view.findViewById(R.id.listview);

        /**
         * adapter
         */
        final SimCardAdapter adapter = new SimCardAdapter(getContext(), simCardArrayList);
        listView.setAdapter(adapter);

        /**
         * Event
         */
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener()
        {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id)
            {
                //envoi des sms par le fragment écouteur
                listener.onSimCardSelected(adapter.getItem(position));
                dismiss();
            }
        });

        /**
         * Event
         */
        alertDialogBuilder.setNegativeButton("ANNULER", new DialogInterface.OnClickListener()
        {
            @Override
            public void onClick(DialogInterface dialog, int which)
            {
                dismiss();
            }
        });


        return alertDialogBuilder.create();
    }
}
