package axeldjaha.sms.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.ArrayList;

import axeldjaha.sms.model.Sim;
import axeldjaha.sms.R;

/**
 * Created by AXEL DJAHA on 13/04/2017.
 */

public class SimCardAdapter extends BaseAdapter
{
    private final String TAG = "SimCardAdapter";

    private Context context;
    private ArrayList<Sim> simArrayList;

    public SimCardAdapter(Context context, ArrayList<Sim> sims)
    {
        this.context = context;
        simArrayList = sims;
    }

    @Override
    public int getCount()
    {
        return simArrayList.size();
    }

    @Override
    public Sim getItem(int position)
    {
        return simArrayList.get(position);
    }

    @Override
    public long getItemId(int position)
    {
        return position;
    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent)
    {
        ViewHolder holder;

        if(convertView == null)
        {
            convertView = LayoutInflater.from(this.context).inflate(R.layout.simcard_dialog_item, null);
            holder = new ViewHolder();
            holder.imageViewSim = (ImageView) convertView.findViewById(R.id.img_sim);
            holder.textViewSim = (TextView) convertView.findViewById(R.id.txt_sim);

            convertView.setTag(holder);
        }
        else
        {
            holder = (ViewHolder) convertView.getTag();
        }

        holder.bindData(getItem(position));
        holder.setItemFocusable(false);

        return convertView;
    }

    public class ViewHolder
    {
        private ImageView imageViewSim;
        private TextView textViewSim;

        public void bindData(Sim sim)
        {
            textViewSim.setText(sim.getName());
        }

        public void setItemFocusable(boolean state)
        {
            textViewSim.setFocusable(state);
            textViewSim.setClickable(state);
            imageViewSim.setFocusable(state);
            imageViewSim.setClickable(state);
        }
    }
}
