package axeldjaha.sms;

import android.Manifest;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.util.Log;

import java.util.ArrayList;
import java.util.List;

import axeldjaha.sms.Interface.OnSmsListener;
import axeldjaha.sms.fragment.SimDialogFragment;
import axeldjaha.sms.model.Sim;
import axeldjaha.sms.service.SendSmsService;
import axeldjaha.sms.Interface.OnSimCardListener;
import axeldjaha.sms.model.Sms;
import djahalibraries.utilitylibrary.Utility;

/**
 * Created by AXEL DJAHA on 07/05/2017.
 */

public final class SMSManager implements ActivityCompat.OnRequestPermissionsResultCallback
{
    private static String TAG = "SMSManager";

    private final int PERMISSION_REQUEST = 402;

    //activité parente
    private AppCompatActivity activity;

    //pemettra d'addresser les messages de broadcast uniquement à activity
    private String packageName;

    //Callback
    private OnSmsListener listener;

    //sim sélectionnée
    private Sim selectedSim;

    //le smsToSend à envoyer
    private  Sms smsToSend;

    //permissions pour les Android versions >= 6
    private  String[] permissions;

    //progressdialog
    private  ProgressDialog progressDialog;

    //permission pos
    private  int position = -1;

    //Informe le listener du résultat de l'envoi du sms
    private BroadcastReceiver smsSentReceiver = new BroadcastReceiver()
    {
        @Override
        public void onReceive(Context context, Intent intent)
        {
            progressDialog.dismiss();

            switch (getResultCode())
            {
                case Activity.RESULT_OK:
                {
                    listener.onSmsSucces();
                    break;
                }
                default:
                {
                    listener.onSmsFailed();
                    break;
                }
            }
        }
    };

    public static SMSManager newInstance(AppCompatActivity activity, Sms sms, OnSmsListener listener)
    {
        return new SMSManager(activity, sms, listener);
    }

    private SMSManager(AppCompatActivity activity, Sms sms, OnSmsListener listener)
    {
        this.activity = activity;
        this.smsToSend = sms;
        this.packageName = activity.getPackageName();
        this.listener = listener;
        this.registerReceiver();

        progressDialog = new ProgressDialog(activity);
        progressDialog.setMessage("Envoi en cours...");
        progressDialog.setCancelable(false);

        permissions = new String[]{
                Manifest.permission.SEND_SMS,
                Manifest.permission.READ_PHONE_STATE
        };
    }

    /**
     * Identique à Activity.unregisterReceiver
     */
    public void unregisterReceiver()
    {
        activity.unregisterReceiver(smsSentReceiver);
    }

    /**
     * Identique à Activity.registerReceiver
     */
    public void registerReceiver()
    {
        IntentFilter intentFilter = new IntentFilter(packageName);
        activity.registerReceiver(smsSentReceiver, intentFilter);
    }

    /**
     * Méthode d'envoi du SMS.
     */
    public void sendSMS()
    {
        checkForPermissions();
    }

    /**
     * On demande la permission pour envoyer le smsToSend
     */
    private void checkForPermissions()
    {
        position++;

        if(position < permissions.length)
        {
            if(ContextCompat.checkSelfPermission(activity, permissions[position])
                    != PackageManager.PERMISSION_GRANTED)
            {
                activity.requestPermissions(new String[]{permissions[position]}, PERMISSION_REQUEST);
            }
            else
            {
                checkForPermissions();
            }
        }
        else
        {
            openSimCardDialog();
        }
    }


    /**
     * Choisir la SIM d'envoi du SMS
     */
    private void openSimCardDialog()
    {
        /**
         * Récupération des cartes SIM
         */
        ArrayList<Sim> simCardArrayList = new ArrayList<>();
        SubscriptionManager subscriptionManager;
        subscriptionManager = SubscriptionManager.from(activity);
        final List<SubscriptionInfo> subscriptionInfoList = subscriptionManager
                .getActiveSubscriptionInfoList();
        for (SubscriptionInfo subscriptionInfo : subscriptionInfoList)
        {
            Sim sim = new Sim();
            sim.setId(subscriptionInfo.getSubscriptionId());
            sim.setName(subscriptionInfo.getDisplayName().toString());
            simCardArrayList.add(sim);
        }

        SimDialogFragment.newIntance(simCardArrayList, new OnSimCardListener()
        {
            @Override
            public void onSimCardSelected(Sim sim)
            {
                selectedSim = sim;
                startService();
            }
        }).show(activity.getSupportFragmentManager(), "SimDialogFragment");
    }

    /**
     *
     * Démarrage du service d'envoi du SMS
     */
    private void startService()
    {
        progressDialog.show();

        Intent intent = new Intent(activity, SendSmsService.class);
        intent.putExtra("sms", smsToSend);
        intent.putExtra("sim", selectedSim);
        intent.putExtra("packageName", packageName);

        //utilisation de service pour l'envoi du SMS
        activity.startService(intent);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode,
                                           @NonNull String[] permissions,
                                           @NonNull int[] grantResults)
    {
        switch (requestCode)
        {
            case PERMISSION_REQUEST:
            {
                //si permission acceptée
                if (grantResults.length == 1 &&
                        grantResults[0] == PackageManager.PERMISSION_GRANTED)
                {
                    checkForPermissions();
                }
                else
                {
                    Utility.showInfoDialog(activity.getSupportFragmentManager(),
                            "Autorisation requise", "L'action ne peut être effectuée");
                }
                break;
            }
        }
    }
}
