package axeldjaha.permission;

import android.app.Activity;
import android.content.pm.PackageManager;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;

import axeldjaha.permission.Interface.ADPermissionListener;

/**
 * Created by AXEL DJAHA on 29/11/2017
 *
 */

public class ADPermission implements ActivityCompat.OnRequestPermissionsResultCallback
{
    private static final int PERMISSION_REQUEST = 34;
    private static int position;
    private static String[] perms;
    private static Activity activity;
    private static ADPermissionListener listener;

    /**
     * Demander des permissions utiles pour exécuter une action.
     * Toutes les permissions doivent être déclarées dans le manifest avant d'appeler cette méthode.
     * Les demandes de permissions sont obligatoires à partir d'Android 6
     *
     * @param act instance d'une activité
     * @param permissions tableau contenant les permissions à demander, chaque permission étant de la forme: Manifest.permission.NOM_DE_LA_PERMISSION
     * @param permissionListener écouteur d'évènement (callback) permettant de savoir si les permissions ont
     *                           été acceptées ou pas par l'utilisateur. Instance de ADPermissionListener
     */
    public static void check(Activity act, String[] permissions, ADPermissionListener permissionListener)
    {
        activity = act;
        perms = permissions;
        listener = permissionListener;

        checkForPermissions();
    }

    /**
     * Demande des permissions
     */
    private static void checkForPermissions()
    {
        position++;

        if (position < perms.length)
        {
            if (ContextCompat.checkSelfPermission(activity, perms[position])
                    != PackageManager.PERMISSION_GRANTED) {
                activity.requestPermissions(new String[]{perms[position]}, PERMISSION_REQUEST);
            }
            else
            {
                checkForPermissions();
            }
        }
        else
        {
            listener.onPermissionGranted();
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode,
                                           String[] permissions,
                                           int[] grantResults)
    {
        switch (requestCode)
        {
            case PERMISSION_REQUEST:
            {
                //si permission acceptée
                if (grantResults.length == 1 && grantResults[0] == PackageManager.PERMISSION_GRANTED)
                {
                    checkForPermissions();
                }
                else
                {
                    listener.onPermissionDenied();
                }
                break;
            }
        }
    }
}
