package axeldjaha.dialog.fragment;

import android.app.Dialog;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import axeldjaha.dialog.Interface.ADDialogListener;
import axeldjaha.dialog.R;

/**
 * Created by AXEL DJAHA on 01/12/2017
 */

public class ADDialogFragment extends DialogFragment
{
    public static final String TAG = "ADDialogFragment";

    //titre
    private String headerText;
    private Drawable headerIcon;
    private boolean hasHeaderIcon;

    //bodyText
    private String bodyText;

    //texte bouton positif
    private String positiveButtonText;

    //texte bouton négatif
    private String negativeButtonText;

    //texte du bouton neutre
    private String neutralButtonText;

    //auto dismiss
    private boolean dialogCancelable;

    //écouteur d'évènement
    private ADDialogListener listener;

    //context d'utilisation
    private String action;

    //couleur de texte de l'entête
    private int headerTextColor;
    boolean hasHeaderTextColor;
    //couleur de fond de l'entête
    private int headerBackgroundColor;
    private boolean hasHeaderBackgroundColor;

    //couleur de texte du corps
    private int bodyTextColor;
    private boolean hasBodyTextColor;
    //couleur de fond du corps
    private int bodyBackgroundColor;
    private boolean hasBodyBackgroundColor;

    //couleur du texte du pied
    private int footerTextColor;
    private boolean hasFooterTextColor;
    //couleur de fond du pied
    private int footerBackgroundColor;
    private boolean hasFooterBackgroundColor;

    //couleur de fond de la boîte de dialogue
    private int dialogBackgroundColor;
    private boolean hasDialogBackgroundColor;

    private View viewDialog;
    private LinearLayout linearLayoutDialog;

    private LinearLayout linearLayoutHeader;
    private ImageView imageViewHeaderIcon;
    private TextView textViewHeaderText;

    private LinearLayout linearLayoutBody;
    private TextView textViewBodyText;

    private LinearLayout linearLayoutFooter;
    private Button buttonPositive;
    private Button buttonNegative;
    private Button buttonNeutre;

    private int[] headerPadding;
    private int[] bodyPadding;
    private int[] footerPadding;

    public void setHasHeaderTextColor(boolean hasHeaderTextColor) {
        this.hasHeaderTextColor = hasHeaderTextColor;
    }

    public void setHasHeaderBackgroundColor(boolean hasHeaderBackgroundColor) {
        this.hasHeaderBackgroundColor = hasHeaderBackgroundColor;
    }

    public void setHasBodyTextColor(boolean hasBodyTextColor) {
        this.hasBodyTextColor = hasBodyTextColor;
    }

    public void setHasBodyBackgroundColor(boolean hasBodyBackgroundColor) {
        this.hasBodyBackgroundColor = hasBodyBackgroundColor;
    }

    public void setHasFooterTextColor(boolean hasFooterTextColor) {
        this.hasFooterTextColor = hasFooterTextColor;
    }

    public void setHasFooterBackgroundColor(boolean hasFooterBackgroundColor) {
        this.hasFooterBackgroundColor = hasFooterBackgroundColor;
    }

    public void setHasDialogBackgroundColor(boolean hasDialogBackgroundColor) {
        this.hasDialogBackgroundColor = hasDialogBackgroundColor;
    }

    public void setHeaderText(String headerText) {
        this.headerText = headerText;
    }

    public void setBodyText(String bodyText) {
        this.bodyText = bodyText;
    }

    public void setPositiveButtonText(String positiveButtonText) {
        this.positiveButtonText = positiveButtonText;
    }

    public void setNegativeButtonText(String negativeButtonText) {
        this.negativeButtonText = negativeButtonText;
    }

    public void setNeutralButtonText(String neutralButtonText) {
        this.neutralButtonText = neutralButtonText;
    }

    public void setDialogCancelable(boolean dialogCancelable) {
        this.dialogCancelable = dialogCancelable;
    }

    public void setHeaderIcon(Drawable headerIcon) {
        this.headerIcon = headerIcon;
    }

    public void setHasHeaderIcon(boolean hasHeaderIcon) {
        this.hasHeaderIcon = hasHeaderIcon;
    }

    public void setListener(ADDialogListener listener) {
        this.listener = listener;
    }

    public void setAction(String action) {
        this.action = action;
    }

    /**
     * Couleur de texte de l'entête. Utiliser R.color.VOTRE_COULEUR
     * @param headerTextColor
     */
    public void setHeaderTextColor(int headerTextColor) {
        this.headerTextColor = headerTextColor;
    }

    /**
     * Couleur du fond de l'entête. Utiliser R.color.VOTRE_COULEUR
     * @param headerBackgroundColor
     */
    public void setHeaderBackgroundColor(int headerBackgroundColor) {
        this.headerBackgroundColor = headerBackgroundColor;
    }

    /**
     * Couleur de texte du corps. Utiliser R.color.VOTRE_COULEUR
     * @param bodyTextColor
     */
    public void setBodyTextColor(int bodyTextColor) {
        this.bodyTextColor = bodyTextColor;
    }

    /**
     * Couleur de de fond du corps. Utiliser R.color.VOTRE_COULEUR
     * @param bodyBackgroundColor
     */
    public void setBodyBackgroundColor(int bodyBackgroundColor) {
        this.bodyBackgroundColor = bodyBackgroundColor;
    }

    /**
     * Couleur de texte du pied. Utiliser R.color.VOTRE_COULEUR
     * @param footerTextColor
     */
    public void setFooterTextColor(int footerTextColor) {
        this.footerTextColor = footerTextColor;
    }

    /**
     * Couleur de fond du pied. Utiliser R.color.VOTRE_COULEUR
     * @param footerBackgroundColor
     */
    public void setFooterBackgroundColor(int footerBackgroundColor) {
        this.footerBackgroundColor = footerBackgroundColor;
    }

    /**
     * Définir la couleur de fond de la boîte de dialogue.
     * @param dialogBackgroundColor
     */
    public void setDialogBackgroundColor(int dialogBackgroundColor) {
        this.dialogBackgroundColor = dialogBackgroundColor;
    }

    public ADDialogFragment() {}

    @Override
    public void onStart()
    {
        super.onStart();

        setRetainInstance(true);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState)
    {
        AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(getActivity());

        viewDialog = LayoutInflater.from(getContext()).inflate(R.layout.dialog_content, null, false);
        linearLayoutDialog = (LinearLayout) viewDialog.findViewById(R.id.linearlayout_dialog);

        linearLayoutHeader = (LinearLayout) viewDialog.findViewById(R.id.linearlayout_header);
        imageViewHeaderIcon = (ImageView) viewDialog.findViewById(R.id.img_header_icon);
        textViewHeaderText = (TextView) viewDialog.findViewById(R.id.txt_dialog_title);

        linearLayoutBody = (LinearLayout) viewDialog.findViewById(R.id.linearlayout_body);
        textViewBodyText = (TextView) viewDialog.findViewById(R.id.txt_dialog_message);

        linearLayoutFooter = (LinearLayout) viewDialog.findViewById(R.id.linearlayout_footer);
        buttonPositive = (Button) viewDialog.findViewById(R.id.btn_dialog_positive_action);
        buttonNegative = (Button) viewDialog.findViewById(R.id.btn_dialog_negative_action);
        buttonNeutre = (Button) viewDialog.findViewById(R.id.btn_dialog_neutral_action);

        alertDialogBuilder.setView(viewDialog);
        viewDialog.setBackgroundColor(Color.TRANSPARENT);

        //contenu des élément
        textViewHeaderText.setText(headerText);
        textViewBodyText.setText(bodyText);
        buttonPositive.setText(positiveButtonText);
        buttonNegative.setText(negativeButtonText);
        buttonNeutre.setText(neutralButtonText);

        //visibilité
        setItemsVisibility();

        //icon entête
        setHeaderIcon();

        //couleur des éléments
        setItemsColor();

        //padding des éléments
        setItemsPadding();

        /**
         * Evènement
         */
        buttonPositive.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dismiss();
                if(listener != null)
                {
                    listener.onADPositiveButtonClick(action);
                }
            }
        });
        buttonNegative.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dismiss();
                if(listener != null)
                {
                    listener.onADNegativeButtonClick(action);
                }
            }
        });
        buttonNeutre.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dismiss();
                if(listener != null)
                {
                    listener.onADNeutralButtonClick(action);
                }
            }
        });

        setCancelable(dialogCancelable);

        return alertDialogBuilder.create();
    }

    private void setHeaderIcon()
    {
        if(hasHeaderIcon)
        {
            imageViewHeaderIcon.setBackground(headerIcon);
        }
    }

    /**
     * Définir la couleur des éléments
     */
    private void setItemsColor()
    {
        if(hasHeaderTextColor)
        {
            textViewHeaderText.setTextColor(headerTextColor);
        }
        if(hasHeaderBackgroundColor)
        {
            linearLayoutHeader.setBackgroundColor(headerBackgroundColor);
        }
        if(hasBodyTextColor)
        {
            textViewBodyText.setTextColor(bodyTextColor);
        }
        if(hasBodyBackgroundColor)
        {
            linearLayoutBody.setBackgroundColor(bodyTextColor);
        }
        if(hasFooterTextColor)
        {
            buttonPositive.setTextColor(footerTextColor);
            buttonNegative.setTextColor(footerTextColor);
            buttonNeutre.setTextColor(footerTextColor);
        }
        if(hasFooterBackgroundColor)
        {
            linearLayoutFooter.setBackgroundColor(footerBackgroundColor);
        }
        if(hasDialogBackgroundColor)
        {
            linearLayoutDialog.setBackgroundColor(dialogBackgroundColor);
        }
    }

    /**
     * Visibilité des éléments de la boîte de dialogue
     */
    private void setItemsVisibility()
    {
        if(!hasHeaderIcon)
        {
            imageViewHeaderIcon.setVisibility(View.GONE);
        }
        if(TextUtils.isEmpty(headerText))
        {
            textViewHeaderText.setVisibility(View.GONE);
        }
        if(TextUtils.isEmpty(bodyText))
        {
            textViewBodyText.setVisibility(View.GONE);
        }
        if(TextUtils.isEmpty(positiveButtonText))
        {
            buttonPositive.setVisibility(View.INVISIBLE);
        }
        if(TextUtils.isEmpty(negativeButtonText))
        {
            buttonNegative.setVisibility(View.GONE);
        }
        if(TextUtils.isEmpty(neutralButtonText))
        {
            buttonNeutre.setVisibility(View.GONE);
        }
    }

    /**
     * Padding des éléments
     */
    private void setItemsPadding()
    {
        if(headerPadding == null)
        {
            headerPadding = new int[4];
        }
        linearLayoutHeader.setPadding(
                headerPadding[0] <= linearLayoutHeader.getPaddingLeft() ? linearLayoutHeader.getPaddingLeft() : headerPadding[0],
                headerPadding[1] <= linearLayoutHeader.getPaddingTop() ? linearLayoutHeader.getPaddingTop() : headerPadding[1],
                headerPadding[2] <= linearLayoutHeader.getPaddingRight() ? linearLayoutHeader.getPaddingRight() : headerPadding[2],
                headerPadding[3] <= linearLayoutHeader.getPaddingBottom() ? linearLayoutHeader.getPaddingBottom() : headerPadding[3]
        );
        if(bodyPadding == null)
        {
            bodyPadding = new int[4];
        }
        linearLayoutBody.setPadding(
                bodyPadding[0] <= linearLayoutBody.getPaddingLeft() ? linearLayoutBody.getPaddingLeft() : bodyPadding[0],
                bodyPadding[1] <= linearLayoutBody.getPaddingTop() ? linearLayoutBody.getPaddingTop() : bodyPadding[1],
                bodyPadding[2] <= linearLayoutBody.getPaddingRight() ? linearLayoutBody.getPaddingRight() : bodyPadding[2],
                bodyPadding[3] <= linearLayoutBody.getPaddingBottom() ? linearLayoutBody.getPaddingBottom() : bodyPadding[3]
        );
        if(footerPadding == null)
        {
            footerPadding = new int[4];
        }
        linearLayoutFooter.setPadding(
                footerPadding[0] <= linearLayoutFooter.getPaddingLeft() ? linearLayoutFooter.getPaddingLeft() : footerPadding[0],
                footerPadding[1] <= linearLayoutFooter.getPaddingTop() ? linearLayoutFooter.getPaddingTop() : footerPadding[1],
                footerPadding[2] <= linearLayoutFooter.getPaddingRight() ? linearLayoutFooter.getPaddingRight() : footerPadding[2],
                footerPadding[3] <= linearLayoutFooter.getPaddingBottom() ? linearLayoutFooter.getPaddingBottom() : footerPadding[3]
        );
    }

    /**
     * Définir le padding de l'entête
     * @param left
     * @param top
     * @param right
     * @param bottom
     */
    public void setHeaderPadding(int left, int top, int right, int bottom)
    {
        headerPadding = new int[4];
        headerPadding[0] = left;
        headerPadding[1] = top;
        headerPadding[2] = right;
        headerPadding[3] = bottom;
    }

    /**
     * Définir le padding du corps
     * @param left
     * @param top
     * @param right
     * @param bottom
     */
    public void setBodyPadding(int left, int top, int right, int bottom)
    {
        bodyPadding = new int[4];
        bodyPadding[0] = left;
        bodyPadding[1] = top;
        bodyPadding[2] = right;
        bodyPadding[3] = bottom;
    }

    /**
     * Définir le padding du pied
     * @param left
     * @param top
     * @param right
     * @param bottom
     */
    public void setFooterPadding(int left, int top, int right, int bottom)
    {
        footerPadding = new int[4];
        footerPadding[0] = left;
        footerPadding[1] = top;
        footerPadding[2] = right;
        footerPadding[3] = bottom;
    }
}