package axeldjaha.dialog.Interface;

/**
 * Created by AXEL DJAHA on 17/04/2017.
 */

public interface ADDialogListener
{
    /**
     * Appelé lorsque l'utilisateur clique sur le bouton positif
     * @param action correspond à un texte permettant de reconnaître un ensemble d'instructions à exécuter.
     *               Dans le cas où différents éléments peuvent ouvrir la boîte de dialogue,
     *               on pourra savoir les instructions à exécuter en examinant la valeur du paramètre 'action'.
     *               Un élément peut être un Button, un TextView, un EditText ou tout autre widget.
     */
    void onADPositiveButtonClick(String action);

    /**
     * Appelé lorsque l'utilisateur clique sur le bouton négatif
     * @param action correspond à un texte permettant de savoir les instructions à exécuter.
     *               Dans le cas où différents éléments peuvent ouvrir la boîte de dialogue,
     *               on pourra savoir les instructions à exécuter en examinant la valeur du paramètre 'action'.
     *               Un élément peut être un Button, un TextView, un EditText ou tout autre widget.
     */
    void onADNegativeButtonClick(String action);

    /**
     * Appelé lorsque l'utilisateur clique sur le bouton neutre
     * @param action correspond à un texte permettant de reconnaître un ensemble d'instructions à exécuter.
     *               Dans le cas où différents éléments peuvent ouvrir la boîte de dialogue,
     *               on pourra savoir les instructions à exécuter en examinant la valeur du paramètre 'action'.
     *               Un élément peut être un Button, un TextView, un EditText ou tout autre widget.
     */
    void onADNeutralButtonClick(String action);

}
