package axeldjaha.dialog.fragment;

import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v7.app.AlertDialog;

/**
 * Created by AXEL DJAHA on 21/04/2017.
 */

public final class InfoDialogFragment extends DialogFragment
{
    /**
     * Affiche un message dans une boîte de dialogue
     *
     * @param titre titre de la boite de dialogue
     * @param message message à afficher à l'utilisateur
     */
    public static InfoDialogFragment newInstance(String titre, String message)
    {
        InfoDialogFragment frag = new InfoDialogFragment();
        Bundle args = new Bundle();

        //le titre
        args.putString("titre", titre);

        //le message
        args.putString("message", message);

        frag.setArguments(args);
        return frag;
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState)
    {
        String title = getArguments().getString("title");
        String message = getArguments().getString("message");

        AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(getActivity());
        if(title.length() > 0){ alertDialogBuilder.setTitle(title);}
        if(message.length() > 0){ alertDialogBuilder.setMessage(message);}

        alertDialogBuilder.setPositiveButton("Ok",  new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which)
            {
                dismiss();
            }
        });

        return alertDialogBuilder.create();
    }

}
