package axeldjaha.dialog.fragment;

import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v7.app.AlertDialog;

import axeldjaha.dialog.Interface.ADDialogListener;

/**
 * Created by AXEL DJAHA on 15/04/2017.
 */

public final class ConfirmDialogFragment extends DialogFragment
{
    public static final String TAG = "ConfirmDialogFragment";

    private static String title;
    private static String messgae;
    private static boolean isCancelable;
    private static String positiveText;
    private static String negativeTxt;

    private ADDialogListener listener;

    //context d'utilisation
    private String action;

    /**
     * Demander la permission à l'utilisateur pour effectuer une action
     *
     * @param listener écouteur d'évènement (callback), notifiant que l'utilisateur a accepté l'exécution de l'action
     * @param action chaine identifiant l'action à exécuter (élément déclencheur)
     * @param title titre de la boite de dialogue
     * @param message message à afficher à l'utilisateur
     * @param positiveButtonText texte pour le bouton d'action positive. Exemple: Oui
     * @param negativeButtonText texte pour le bouton d'action négative. Exemple: Non
     * @param isCancable définit le comportement de la boite
     * @return
     */
    public static ConfirmDialogFragment newIntance(
            ADDialogListener listener,
            String action,
            String title,
            String message,
            String positiveButtonText,
            String negativeButtonText,
            boolean isCancable)
    {
        ConfirmDialogFragment confirmDialogFragment = new ConfirmDialogFragment();
        confirmDialogFragment.listener = listener;
        confirmDialogFragment.action = action;
        confirmDialogFragment.action = action;
        confirmDialogFragment.title = title;
        confirmDialogFragment.messgae = message;
        confirmDialogFragment.positiveText = positiveButtonText;
        confirmDialogFragment.negativeTxt = negativeButtonText;
        confirmDialogFragment.isCancelable = isCancable;

        return confirmDialogFragment;
    }

    /**
     * Demander la permission à l'utilisateur pour effectuer une action
     *
     * @param listener écouteur d'évènement (callback), notifiant que l'utilisateur a accepté l'exécution de l'action
     * @param action chaine identifiant l'action à exécuter (élément déclencheur)
     * @param title titre de la boite de dialogue
     * @param message message à afficher à l'utilisateur
     * @return
     */
    public static ConfirmDialogFragment newIntance(
            ADDialogListener listener,
            String action,
            String title,
            String message)
    {
        ConfirmDialogFragment confirmDialogFragment = new ConfirmDialogFragment();
        confirmDialogFragment.listener = listener;
        confirmDialogFragment.action = action;
        confirmDialogFragment.title = title;
        confirmDialogFragment.messgae = message;
        confirmDialogFragment.isCancelable = true;
        confirmDialogFragment.positiveText = "Oui";
        confirmDialogFragment.negativeTxt = "Non";

        return confirmDialogFragment;
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState)
    {
        AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(getActivity());
        alertDialogBuilder.setTitle(title);
        alertDialogBuilder.setMessage(messgae);

        /**
         * Evènement
         */
        alertDialogBuilder.setPositiveButton(positiveText, new DialogInterface.OnClickListener()
        {
            @Override
            public void onClick(DialogInterface dialog, int which)
            {
                listener.onADActionConfirmed(action);
                dismiss();
            }
        });
        alertDialogBuilder.setNegativeButton(negativeTxt, new DialogInterface.OnClickListener()
        {
            @Override
            public void onClick(DialogInterface dialog, int which)
            {
                dismiss();
            }
        });

        setCancelable(isCancelable);

        return alertDialogBuilder.create();
    }
}
