package axeldjaha.dialog;

import android.support.v4.app.FragmentManager;

import axeldjaha.dialog.Interface.ADDialogListener;
import axeldjaha.dialog.fragment.ConfirmDialogFragment;
import axeldjaha.dialog.fragment.InfoDialogFragment;

/**
 * Created by AXEL DJAHA on 30/11/2017
 */

public class ADDialog
{
    /**
     * Demander la permission à l'utilisateur pour effectuer une action
     *
     * @param fragmentManager android.support.v4.app.FragmentManager
     * @param listener écouteur d'évènement (callback), notifiant que l'utilisateur a accepté l'exécution de l'action
     * @param action chaine identifiant l'action à exécuter (élément déclencheur)
     * @param title titre de la boite de dialogue
     * @param message message à afficher à l'utilisateur
     * @param positiveButtonText texte pour le bouton d'action positive. Exemple: Oui
     * @param negativeButtonText texte pour le bouton d'action négative. Exemple: Non
     * @param isCancable définit le comportement de la boite
     */
    public static void showConfirmDialog(FragmentManager fragmentManager,
                                         ADDialogListener listener,
                                         String action,
                                         String title,
                                         String message,
                                         String positiveButtonText,
                                         String negativeButtonText,
                                         boolean isCancable)
    {
        ConfirmDialogFragment.newIntance(
                listener,
                action,
                title,
                message,
                positiveButtonText,
                negativeButtonText,
                isCancable).show(fragmentManager, "ConfirmDialogFragment");
    }

    /**
     * Demander la permission à l'utilisateur pour effectuer une action
     *
     * @param fragmentManager android.support.v4.app.FragmentManager
     * @param listener écouteur d'évènement (callback), notifiant que l'utilisateur a accepté l'exécution de l'action
     * @param action chaine identifiant l'action à exécuter (élément déclencheur)
     * @param titre titre de la boite de dialogue
     * @param message message à afficher à l'utilisateur
     */
    public static void showConfirmDialog(FragmentManager fragmentManager,
                                         ADDialogListener listener,
                                         String action,
                                         String titre,
                                         String message)
    {
        ConfirmDialogFragment.newIntance(
                listener,
                action,
                titre,
                message).show(fragmentManager, "ConfirmDialogFragment");
    }

    /**
     * Affiche un message dans une boîte de dialogue
     *
     * @param fragmentManager android.support.v4.app.FragmentManager
     * @param titre titre de la boite de dialogue
     * @param message message à afficher à l'utilisateur
     */
    public static void showInfoDialog(FragmentManager fragmentManager, String titre, String message)
    {
        InfoDialogFragment.newInstance(titre, message)
                .show(fragmentManager, "showInfoDailog");
    }
}
