/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.tools.verifier;

import java.util.ArrayList;
import java.util.Stack;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.metadata.BlockListenerMetaData;
import org.apache.avalon.phoenix.metadata.BlockMetaData;
import org.apache.avalon.phoenix.metadata.DependencyMetaData;
import org.apache.avalon.phoenix.metadata.SarMetaData;
import org.apache.avalon.phoenix.metainfo.BlockInfo;
import org.apache.avalon.phoenix.metainfo.DependencyDescriptor;
import org.apache.avalon.phoenix.metainfo.ServiceDescriptor;
import org.apache.avalon.phoenix.tools.verifier.VerifyException;

public class SarVerifier
extends AbstractLogEnabled {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$tools$verifier$SarVerifier == null ? (class$org$apache$avalon$phoenix$tools$verifier$SarVerifier = SarVerifier.class$("org.apache.avalon.phoenix.tools.verifier.SarVerifier")) : class$org$apache$avalon$phoenix$tools$verifier$SarVerifier));
    private static final Class[] FRAMEWORK_CLASSES = new Class[]{class$org$apache$avalon$framework$logger$LogEnabled == null ? (class$org$apache$avalon$framework$logger$LogEnabled = SarVerifier.class$("org.apache.avalon.framework.logger.LogEnabled")) : class$org$apache$avalon$framework$logger$LogEnabled, class$org$apache$avalon$framework$context$Contextualizable == null ? (class$org$apache$avalon$framework$context$Contextualizable = SarVerifier.class$("org.apache.avalon.framework.context.Contextualizable")) : class$org$apache$avalon$framework$context$Contextualizable, class$org$apache$avalon$framework$component$Composable == null ? (class$org$apache$avalon$framework$component$Composable = SarVerifier.class$("org.apache.avalon.framework.component.Composable")) : class$org$apache$avalon$framework$component$Composable, class$org$apache$avalon$framework$service$Serviceable == null ? (class$org$apache$avalon$framework$service$Serviceable = SarVerifier.class$("org.apache.avalon.framework.service.Serviceable")) : class$org$apache$avalon$framework$service$Serviceable, class$org$apache$avalon$framework$configuration$Configurable == null ? (class$org$apache$avalon$framework$configuration$Configurable = SarVerifier.class$("org.apache.avalon.framework.configuration.Configurable")) : class$org$apache$avalon$framework$configuration$Configurable, class$org$apache$avalon$framework$parameters$Parameterizable == null ? (class$org$apache$avalon$framework$parameters$Parameterizable = SarVerifier.class$("org.apache.avalon.framework.parameters.Parameterizable")) : class$org$apache$avalon$framework$parameters$Parameterizable, class$org$apache$avalon$framework$activity$Initializable == null ? (class$org$apache$avalon$framework$activity$Initializable = SarVerifier.class$("org.apache.avalon.framework.activity.Initializable")) : class$org$apache$avalon$framework$activity$Initializable, class$org$apache$avalon$framework$activity$Startable == null ? (class$org$apache$avalon$framework$activity$Startable = SarVerifier.class$("org.apache.avalon.framework.activity.Startable")) : class$org$apache$avalon$framework$activity$Startable, class$org$apache$avalon$framework$activity$Disposable == null ? (class$org$apache$avalon$framework$activity$Disposable = SarVerifier.class$("org.apache.avalon.framework.activity.Disposable")) : class$org$apache$avalon$framework$activity$Disposable};
    static /* synthetic */ Class class$org$apache$avalon$phoenix$tools$verifier$SarVerifier;
    static /* synthetic */ Class class$org$apache$avalon$framework$logger$LogEnabled;
    static /* synthetic */ Class class$org$apache$avalon$framework$context$Contextualizable;
    static /* synthetic */ Class class$org$apache$avalon$framework$component$Composable;
    static /* synthetic */ Class class$org$apache$avalon$framework$service$Serviceable;
    static /* synthetic */ Class class$org$apache$avalon$framework$configuration$Configurable;
    static /* synthetic */ Class class$org$apache$avalon$framework$parameters$Parameterizable;
    static /* synthetic */ Class class$org$apache$avalon$framework$activity$Initializable;
    static /* synthetic */ Class class$org$apache$avalon$framework$activity$Startable;
    static /* synthetic */ Class class$org$apache$avalon$framework$activity$Disposable;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$Block;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$BlockListener;

    public void verifySar(SarMetaData sar, ClassLoader classLoader) throws VerifyException {
        BlockMetaData[] blocks = sar.getBlocks();
        BlockListenerMetaData[] listeners = sar.getListeners();
        String message = null;
        message = REZ.getString("verify-valid-names");
        this.getLogger().info(message);
        this.verifySarName(sar.getName());
        this.verifyValidNames(blocks);
        this.verifyValidNames(listeners);
        message = REZ.getString("verify-unique-names");
        this.getLogger().info(message);
        this.checkNamesUnique(blocks, listeners);
        message = REZ.getString("verify-dependencies-mapping");
        this.getLogger().info(message);
        this.verifyValidDependencies(blocks);
        message = REZ.getString("verify-dependency-references");
        this.getLogger().info(message);
        this.verifyDependencyReferences(blocks);
        message = REZ.getString("verify-nocircular-dependencies");
        this.getLogger().info(message);
        this.verifyNoCircularDependencies(blocks);
        message = REZ.getString("verify-block-type");
        this.getLogger().info(message);
        this.verifyBlocksType(blocks, classLoader);
        message = REZ.getString("verify-listener-type");
        this.getLogger().info(message);
        this.verifyListenersType(listeners, classLoader);
    }

    private void verifyValidDependencies(BlockMetaData[] blocks) throws VerifyException {
        int i = 0;
        while (i < blocks.length) {
            this.verifyDependenciesMap(blocks[i]);
            ++i;
        }
    }

    private void verifyNoCircularDependencies(BlockMetaData[] blocks) throws VerifyException {
        int i = 0;
        while (i < blocks.length) {
            BlockMetaData block = blocks[i];
            Stack<BlockMetaData> stack = new Stack<BlockMetaData>();
            stack.push(block);
            this.verifyNoCircularDependencies(block, blocks, stack);
            stack.pop();
            ++i;
        }
    }

    private void verifyNoCircularDependencies(BlockMetaData block, BlockMetaData[] blocks, Stack stack) throws VerifyException {
        BlockMetaData[] dependencies = this.getDependencies(block, blocks);
        int i = 0;
        while (i < dependencies.length) {
            BlockMetaData dependency = dependencies[i];
            if (stack.contains(dependency)) {
                String trace = this.getDependencyTrace(dependency, stack);
                String message = REZ.getString("dependency-circular", (Object)block.getName(), (Object)trace);
                throw new VerifyException(message);
            }
            stack.push(dependency);
            this.verifyNoCircularDependencies(dependency, blocks, stack);
            stack.pop();
            ++i;
        }
    }

    private String getDependencyTrace(BlockMetaData block, Stack stack) {
        int top;
        StringBuffer sb = new StringBuffer();
        sb.append("[ ");
        String name = block.getName();
        int size = stack.size();
        int i = top = size - 1;
        while (i >= 0) {
            BlockMetaData other = (BlockMetaData)stack.get(i);
            if (top != i) {
                sb.append(", ");
            }
            sb.append(other.getName());
            if (other.getName().equals(name)) break;
            --i;
        }
        sb.append(", ");
        sb.append(name);
        sb.append(" ]");
        return sb.toString();
    }

    private BlockMetaData[] getDependencies(BlockMetaData block, BlockMetaData[] blocks) {
        ArrayList<BlockMetaData> dependencies = new ArrayList<BlockMetaData>();
        DependencyMetaData[] deps = block.getDependencies();
        int i = 0;
        while (i < deps.length) {
            String name = deps[i].getName();
            BlockMetaData other = this.getBlock(name, blocks);
            dependencies.add(other);
            ++i;
        }
        return dependencies.toArray(new BlockMetaData[0]);
    }

    private void verifyDependencyReferences(BlockMetaData[] blocks) throws VerifyException {
        int i = 0;
        while (i < blocks.length) {
            this.verifyDependencyReferences(blocks[i], blocks);
            ++i;
        }
    }

    private void verifyDependencyReferences(BlockMetaData block, BlockMetaData[] others) throws VerifyException {
        BlockInfo info = block.getBlockInfo();
        DependencyMetaData[] roles = block.getDependencies();
        int i = 0;
        while (i < roles.length) {
            String blockName = roles[i].getName();
            String roleName = roles[i].getRole();
            ServiceDescriptor service = info.getDependency(roleName).getService();
            BlockMetaData other = this.getBlock(blockName, others);
            if (null == other) {
                String message = REZ.getString("dependency-noblock", (Object)blockName, (Object)block.getName());
                throw new VerifyException(message);
            }
            ServiceDescriptor[] services = other.getBlockInfo().getServices();
            if (!this.hasMatchingService(service, services)) {
                String message = REZ.getString("dependency-noservice", (Object)blockName, (Object)service, (Object)block.getName());
                throw new VerifyException(message);
            }
            ++i;
        }
    }

    private BlockMetaData getBlock(String name, BlockMetaData[] blocks) {
        int i = 0;
        while (i < blocks.length) {
            if (blocks[i].getName().equals(name)) {
                return blocks[i];
            }
            ++i;
        }
        return null;
    }

    private void verifyBlocksType(BlockMetaData[] blocks, ClassLoader classLoader) throws VerifyException {
        int i = 0;
        while (i < blocks.length) {
            this.verifyBlockType(blocks[i], classLoader);
            ++i;
        }
    }

    private void verifyBlockType(BlockMetaData block, ClassLoader classLoader) throws VerifyException {
        String name = block.getName();
        String classname = block.getImplementationKey();
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(classname);
        }
        catch (Exception e) {
            String message = REZ.getString("bad-block-class", (Object)name, (Object)classname, (Object)e.getMessage());
            throw new VerifyException(message);
        }
        Class[] interfaces = this.getServiceClasses(name, block.getBlockInfo().getServices(), classLoader);
        int i = 0;
        while (i < interfaces.length) {
            if (!interfaces[i].isAssignableFrom(clazz)) {
                String message = REZ.getString("block-noimpl-service", (Object)name, (Object)classname, (Object)interfaces[i].getName());
                throw new VerifyException(message);
            }
            ++i;
        }
        if ((class$org$apache$avalon$phoenix$Block == null ? (class$org$apache$avalon$phoenix$Block = SarVerifier.class$("org.apache.avalon.phoenix.Block")) : class$org$apache$avalon$phoenix$Block).isAssignableFrom(clazz)) {
            String message = REZ.getString("verifier.implements-block.error", (Object)name, (Object)classname);
            this.getLogger().error(message);
            System.err.println(message);
        }
    }

    private void verifyListenersType(BlockListenerMetaData[] listeners, ClassLoader classLoader) throws VerifyException {
        int i = 0;
        while (i < listeners.length) {
            this.verifyListenerType(listeners[i], classLoader);
            ++i;
        }
    }

    private void verifyListenerType(BlockListenerMetaData listener, ClassLoader classLoader) throws VerifyException {
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(listener.getClassname());
        }
        catch (Exception e) {
            String message = REZ.getString("bad-listener-class", (Object)listener.getName(), (Object)listener.getClassname(), (Object)e.getMessage());
            throw new VerifyException(message, e);
        }
        if (!(class$org$apache$avalon$phoenix$BlockListener == null ? (class$org$apache$avalon$phoenix$BlockListener = SarVerifier.class$("org.apache.avalon.phoenix.BlockListener")) : class$org$apache$avalon$phoenix$BlockListener).isAssignableFrom(clazz)) {
            String message = REZ.getString("listener-noimpl-listener", (Object)listener.getName(), (Object)listener.getClassname());
            throw new VerifyException(message);
        }
    }

    private void verifySarName(String name) throws VerifyException {
        if (!this.isValidName(name)) {
            String message = REZ.getString("invalid-sar-name", (Object)name);
            throw new VerifyException(message);
        }
    }

    private void verifyValidNames(BlockMetaData[] blocks) throws VerifyException {
        int i = 0;
        while (i < blocks.length) {
            String name = blocks[i].getName();
            if (!this.isValidName(name)) {
                String message = REZ.getString("invalid-block-name", (Object)name);
                throw new VerifyException(message);
            }
            ++i;
        }
    }

    private void verifyValidNames(BlockListenerMetaData[] listeners) throws VerifyException {
        int i = 0;
        while (i < listeners.length) {
            String name = listeners[i].getName();
            if (!this.isValidName(name)) {
                String message = REZ.getString("invalid-listener-name", (Object)name);
                throw new VerifyException(message);
            }
            ++i;
        }
    }

    private boolean isValidName(String name) {
        int size = name.length();
        int i = 0;
        while (i < size) {
            char ch = name.charAt(i);
            if (!Character.isLetterOrDigit(ch) && '-' != ch && '.' != ch) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void checkNamesUnique(BlockMetaData[] blocks, BlockListenerMetaData[] listeners) throws VerifyException {
        int i = 0;
        while (i < blocks.length) {
            String name = blocks[i].getName();
            this.checkNameUnique(name, blocks, listeners, i, -1);
            ++i;
        }
        int i2 = 0;
        while (i2 < listeners.length) {
            String name = listeners[i2].getName();
            this.checkNameUnique(name, blocks, listeners, -1, i2);
            ++i2;
        }
    }

    private void checkNameUnique(String name, BlockMetaData[] blocks, BlockListenerMetaData[] listeners, int blockIndex, int listenerIndex) throws VerifyException {
        int i = 0;
        while (i < blocks.length) {
            String other = blocks[i].getName();
            if (blockIndex != i && name.equals(other)) {
                String message = REZ.getString("duplicate-name", (Object)name);
                throw new VerifyException(message);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < listeners.length) {
            String other = listeners[i2].getName();
            if (listenerIndex != i2 && name.equals(other)) {
                String message = REZ.getString("duplicate-name", (Object)name);
                throw new VerifyException(message);
            }
            ++i2;
        }
    }

    private void verifyDependenciesMap(BlockMetaData block) throws VerifyException {
        DependencyMetaData[] roles = block.getDependencies();
        int i = 0;
        while (i < roles.length) {
            String roleName = roles[i].getRole();
            DependencyDescriptor descriptor = block.getBlockInfo().getDependency(roleName);
            if (null == descriptor) {
                String message = REZ.getString("unknown-dependency", (Object)roles[i].getName(), (Object)roleName, (Object)block.getName());
                throw new VerifyException(message);
            }
            ++i;
        }
        DependencyDescriptor[] dependencies = block.getBlockInfo().getDependencies();
        int i2 = 0;
        while (i2 < dependencies.length) {
            DependencyMetaData role = block.getDependency(dependencies[i2].getRole());
            if (null == role) {
                String message = REZ.getString("unspecified-dependency", (Object)dependencies[i2].getRole(), (Object)block.getName());
                throw new VerifyException(message);
            }
            ++i2;
        }
    }

    private Class[] getServiceClasses(String name, ServiceDescriptor[] services, ClassLoader classLoader) throws VerifyException {
        Class[] classes = new Class[services.length];
        int i = 0;
        while (i < services.length) {
            String classname = services[i].getName();
            try {
                classes[i] = classLoader.loadClass(classname);
            }
            catch (Throwable t) {
                String message = REZ.getString("bad-service-class", (Object)name, (Object)classname, (Object)t.getMessage());
                throw new VerifyException(message, t);
            }
            if (!classes[i].isInterface()) {
                String message = REZ.getString("service-not-interface", (Object)name, (Object)classname);
                throw new VerifyException(message);
            }
            this.checkNotFrameworkInterface(name, classname, classes[i]);
            ++i;
        }
        return classes;
    }

    private void checkNotFrameworkInterface(String name, String classname, Class clazz) {
        int i = 0;
        while (i < FRAMEWORK_CLASSES.length) {
            Class lifecycle = FRAMEWORK_CLASSES[i];
            if (lifecycle.isAssignableFrom(clazz)) {
                String message = REZ.getString("verifier.service-isa-lifecycle.error", (Object)name, (Object)classname, (Object)clazz.getName(), (Object)lifecycle.getName());
                this.getLogger().warn(message);
                System.err.println(message);
            }
            ++i;
        }
    }

    private boolean hasMatchingService(ServiceDescriptor service, ServiceDescriptor[] candidates) {
        int i = 0;
        while (i < candidates.length) {
            if (service.matches(candidates[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

