/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.extension.manager;

import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.extension.Extension;
import org.apache.avalon.extension.manager.ExtensionManager;
import org.apache.avalon.extension.manager.OptionalPackage;
import org.apache.avalon.extension.manager.UnsatisfiedExtensionException;

public class PackageManager {
    private ExtensionManager m_repository;

    public PackageManager(ExtensionManager repository) {
        if (null == repository) {
            throw new NullPointerException("repository");
        }
        this.m_repository = repository;
    }

    public OptionalPackage getOptionalPackage(Extension extension) {
        OptionalPackage[] packages = this.m_repository.getOptionalPackages(extension);
        if (null == packages || 0 == packages.length) {
            return null;
        }
        return packages[0];
    }

    public OptionalPackage[] scanDependencies(Extension required, Extension[] available) throws UnsatisfiedExtensionException {
        return this.scanDependencies(new Extension[]{required}, available);
    }

    public OptionalPackage[] scanDependencies(Extension[] required, Extension[] available) throws UnsatisfiedExtensionException {
        ArrayList dependencies = new ArrayList();
        ArrayList unsatisfied = new ArrayList();
        this.scanDependencies(required, available, dependencies, unsatisfied);
        if (0 != unsatisfied.size()) {
            Extension extension = (Extension)unsatisfied.get(0);
            throw new UnsatisfiedExtensionException(extension);
        }
        return dependencies.toArray(new OptionalPackage[0]);
    }

    public void scanDependencies(Extension[] required, Extension[] available, List dependencies, List unsatisfied) {
        for (int i = 0; i < required.length; ++i) {
            this.scanDependencies(required[i], available, dependencies, unsatisfied);
        }
    }

    public void scanDependencies(Extension required, Extension[] available, List dependencies, List unsatisfied) {
        for (int i = 0; i < available.length; ++i) {
            Extension other = available[i];
            if (!other.isCompatibleWith(required)) continue;
            return;
        }
        int size = dependencies.size();
        for (int i = 0; i < size; ++i) {
            OptionalPackage optionalPackage = (OptionalPackage)dependencies.get(i);
            if (!optionalPackage.isCompatible(required)) continue;
            return;
        }
        OptionalPackage optionalPackage = this.getOptionalPackage(required);
        if (null == optionalPackage) {
            if (!unsatisfied.contains(required)) {
                unsatisfied.add(required);
            }
        } else {
            if (!dependencies.contains(optionalPackage)) {
                dependencies.add(optionalPackage);
            }
            this.scanDependencies(optionalPackage.getRequiredExtensions(), available, dependencies, unsatisfied);
        }
    }
}

