/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Manifest;
import org.apache.avalon.composition.data.ClassLoaderDirective;
import org.apache.avalon.composition.data.ContainmentProfile;
import org.apache.avalon.composition.data.FilesetDirective;
import org.apache.avalon.composition.data.IncludeDirective;
import org.apache.avalon.composition.data.RepositoryDirective;
import org.apache.avalon.composition.data.ResourceDirective;
import org.apache.avalon.composition.model.ClassLoaderContext;
import org.apache.avalon.composition.model.ClassLoaderModel;
import org.apache.avalon.composition.model.ModelException;
import org.apache.avalon.composition.model.ServiceRepository;
import org.apache.avalon.composition.model.TypeRepository;
import org.apache.avalon.composition.model.impl.DefaultClassLoaderContext;
import org.apache.avalon.composition.model.impl.DefaultServiceRepository;
import org.apache.avalon.composition.model.impl.DefaultTypeRepository;
import org.apache.avalon.composition.model.impl.Scanner;
import org.apache.avalon.composition.util.StringHelper;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.extension.Extension;
import org.apache.avalon.extension.manager.ExtensionManager;
import org.apache.avalon.extension.manager.OptionalPackage;
import org.apache.avalon.extension.manager.PackageManager;
import org.apache.avalon.extension.manager.impl.DefaultExtensionManager;
import org.apache.avalon.extension.manager.impl.DelegatingExtensionManager;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.repository.Repository;

public class DefaultClassLoaderModel
extends AbstractLogEnabled
implements ClassLoaderModel {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultClassLoaderModel == null ? (class$org$apache$avalon$composition$model$impl$DefaultClassLoaderModel = DefaultClassLoaderModel.class$("org.apache.avalon.composition.model.impl.DefaultClassLoaderModel")) : class$org$apache$avalon$composition$model$impl$DefaultClassLoaderModel));
    private final ClassLoaderContext m_context;
    private final ExtensionManager m_extension;
    private final PackageManager m_manager;
    private final String[] m_classpath;
    private final OptionalPackage[] m_packages;
    private final URL[] m_urls;
    private final URLClassLoader m_classLoader;
    private final DefaultTypeRepository m_types;
    private final DefaultServiceRepository m_services;
    private final Logger m_local;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultClassLoaderModel;

    public static ClassLoaderModel createClassLoaderModel(ClassLoaderContext context) throws ModelException {
        return new DefaultClassLoaderModel(context);
    }

    public DefaultClassLoaderModel(ClassLoaderContext context) throws ModelException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.m_context = context;
        this.enableLogging(context.getLogger());
        this.m_local = this.getLogger().getChildLogger("classloader");
        if (this.getLogger().isDebugEnabled()) {
            this.getLocalLogger().debug("base: " + StringHelper.toString(context.getBaseDirectory()));
        }
        File base = context.getBaseDirectory();
        Repository repository = context.getRepository();
        ClassLoaderDirective directive = context.getClassLoaderDirective();
        ExtensionManager manager = context.getExtensionManager();
        URL[] implicit = context.getImplicitURLs();
        try {
            if (manager != null) {
                DefaultExtensionManager local = new DefaultExtensionManager(directive.getLibrary().getOptionalExtensionDirectories(base));
                this.m_extension = new DelegatingExtensionManager(new ExtensionManager[]{manager, local});
            } else {
                this.m_extension = new DefaultExtensionManager(directive.getLibrary().getOptionalExtensionDirectories(base));
            }
            this.m_manager = new PackageManager(this.m_extension);
            this.m_classpath = this.createClassPath(base, repository, directive, implicit);
            if (this.getLocalLogger().isDebugEnabled()) {
                String str = "classpath: " + StringHelper.toString(this.m_classpath);
                this.getLocalLogger().debug(str);
            }
            this.m_packages = this.buildOptionalPackages(this.m_classpath, context.getOptionalPackages());
            this.m_urls = this.buildQualifiedClassPath();
            this.m_classLoader = new URLClassLoader(this.m_urls, context.getClassLoader());
            ArrayList types = new ArrayList();
            ArrayList services = new ArrayList();
            Logger scannerLogger = this.getLocalLogger().getChildLogger("scanner");
            Scanner scanner = new Scanner(scannerLogger, this.m_classLoader);
            scanner.scan(this.m_urls, types, services);
            Logger typeLogger = this.getLocalLogger().getChildLogger("types");
            this.m_types = new DefaultTypeRepository(typeLogger, this.m_classLoader, context.getTypeRepository(), types);
            Logger serviceLogger = this.getLocalLogger().getChildLogger("services");
            this.m_services = new DefaultServiceRepository(serviceLogger, context.getServiceRepository(), services);
        }
        catch (Throwable e) {
            String error = "Could not create classloader.";
            throw new ModelException("Could not create classloader.", e);
        }
    }

    public ClassLoaderContext createChildContext(Logger logger, ContainmentProfile profile, URL[] implied) {
        Repository repository = this.m_context.getRepository();
        File base = this.m_context.getBaseDirectory();
        OptionalPackage[] packages = this.getOptionalPackages();
        ClassLoaderDirective directive = profile.getClassLoaderDirective();
        return new DefaultClassLoaderContext(logger, repository, base, this.m_classLoader, packages, this.m_extension, this.m_types, this.m_services, directive, implied);
    }

    public TypeRepository getTypeRepository() {
        return this.m_types;
    }

    public ServiceRepository getServiceRepository() {
        return this.m_services;
    }

    public ExtensionManager getExtensionManager() {
        return this.m_extension;
    }

    public OptionalPackage[] getOptionalPackages() {
        return this.getOptionalPackages(false);
    }

    public OptionalPackage[] getOptionalPackages(boolean policy) {
        int i;
        if (!policy) {
            return this.m_packages;
        }
        ArrayList<OptionalPackage> list = new ArrayList<OptionalPackage>();
        OptionalPackage[] available = this.m_context.getOptionalPackages();
        for (i = 0; i < available.length; ++i) {
            list.add(available[i]);
        }
        for (i = 0; i < this.m_packages.length; ++i) {
            list.add(this.m_packages[i]);
        }
        return list.toArray(new OptionalPackage[0]);
    }

    public URL[] getQualifiedClassPath() {
        return this.m_urls;
    }

    public ClassLoader getClassLoader() {
        return this.m_classLoader;
    }

    private String[] getClassPath() {
        return this.m_classpath;
    }

    private URL[] buildQualifiedClassPath() throws Exception {
        ArrayList<URL> list = new ArrayList<URL>();
        String[] classpath = this.getClassPath();
        for (int i = 0; i < classpath.length; ++i) {
            list.add(new URL(classpath[i]));
        }
        File[] extensions = OptionalPackage.toFiles((OptionalPackage[])this.getOptionalPackages());
        for (int i = 0; i < extensions.length; ++i) {
            list.add(extensions[i].toURL());
        }
        return list.toArray(new URL[0]);
    }

    private String[] createClassPath(File base, Repository repository, ClassLoaderDirective directive, URL[] implicit) throws Exception {
        RepositoryDirective[] repositories;
        ArrayList<String> classpath = new ArrayList<String>();
        if (implicit.length > 0) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("implicit entries: " + implicit.length);
            }
            for (int i = 0; i < implicit.length; ++i) {
                classpath.add(implicit[i].toString());
            }
        }
        File[] files = this.expandFileSetDirectives(base, directive.getClasspathDirective().getFilesets());
        this.addToClassPath(classpath, files);
        if (files.length > 0 && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("included entries: " + files.length);
        }
        if ((repositories = directive.getClasspathDirective().getRepositoryDirectives()).length > 0 && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("repository declarations: " + repositories.length);
        }
        for (int i = 0; i < repositories.length; ++i) {
            ResourceDirective[] resources = repositories[i].getResources();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("repository " + i + " contains " + resources.length + " entries.");
            }
            for (int j = 0; j < resources.length; ++j) {
                ResourceDirective resource = resources[j];
                String id = resource.getId();
                String version = resource.getVersion();
                if (!resource.getType().equals("jar")) continue;
                URL url = repository.getArtifact(id, version, "jar");
                classpath.add(url.toString());
            }
        }
        return classpath.toArray(new String[0]);
    }

    private OptionalPackage[] buildOptionalPackages(String[] classPath) throws Exception {
        return this.buildOptionalPackages(classPath, new OptionalPackage[0]);
    }

    private OptionalPackage[] buildOptionalPackages(String[] classPath, OptionalPackage[] established) throws Exception {
        ArrayList unsatisfied = new ArrayList();
        ArrayList<OptionalPackage> dependencies = new ArrayList<OptionalPackage>();
        for (int i = 0; i < established.length; ++i) {
            dependencies.add(established[i]);
        }
        Manifest[] manifests = this.getManifests(classPath);
        Extension[] available = Extension.getAvailable((Manifest[])manifests);
        Extension[] required = Extension.getRequired((Manifest[])manifests);
        this.m_manager.scanDependencies(required, available, dependencies, unsatisfied);
        if (0 != unsatisfied.size()) {
            int size = unsatisfied.size();
            String message = REZ.getString("classloader.unsatisfied-extensions.error", (Object)new Integer(size));
            StringBuffer buffer = new StringBuffer(message);
            for (int i = 0; i < size; ++i) {
                Extension extension = (Extension)unsatisfied.get(i);
                Object[] params = new Object[]{extension.getExtensionName(), extension.getSpecificationVendor(), extension.getSpecificationVersion(), extension.getImplementationVendor(), extension.getImplementationVendorID(), extension.getImplementationVersion(), extension.getImplementationURL()};
                String entry = REZ.format("classloader.missing.extension.error", params);
                buffer.append("\n" + entry);
            }
            throw new ModelException(buffer.toString());
        }
        OptionalPackage[] packages = dependencies.toArray(new OptionalPackage[0]);
        return this.consolidate(packages, established);
    }

    private OptionalPackage[] consolidate(OptionalPackage[] includes, OptionalPackage[] excludes) {
        ArrayList<OptionalPackage> list = new ArrayList<OptionalPackage>();
        for (int i = 0; i < includes.length; ++i) {
            boolean skip = false;
            OptionalPackage inc = includes[i];
            File file = inc.getFile();
            int j = 0;
            if (j < excludes.length) {
                if (file.equals(excludes[j].getFile())) {
                    // empty if block
                }
                skip = true;
            }
            if (skip) continue;
            list.add(inc);
        }
        return list.toArray(new OptionalPackage[0]);
    }

    private void addToClassPath(List list, File[] files) throws IOException {
        for (int i = 0; i < files.length; ++i) {
            this.addToClassPath(list, files[i]);
        }
    }

    private void addToClassPath(List list, File file) throws IOException {
        File canonical = file.getCanonicalFile();
        String uri = canonical.toURL().toString();
        list.add(uri);
    }

    private Manifest[] getManifests(String[] classPath) throws ModelException {
        ArrayList<Manifest> manifests = new ArrayList<Manifest>();
        for (int i = 0; i < classPath.length; ++i) {
            String element = classPath[i];
            if (!element.endsWith(".jar") && !element.startsWith("jar:")) continue;
            try {
                URL url = null;
                url = element.startsWith("jar:") ? new URL(element) : new URL("jar:" + element + "!/");
                JarURLConnection connection = (JarURLConnection)url.openConnection();
                Manifest manifest = connection.getManifest();
                manifests.add(manifest);
                continue;
            }
            catch (IOException ioe) {
                String message = REZ.getString("classloader.bad-classpath-entry.error", (Object)element);
                throw new ModelException(message, (Throwable)ioe);
            }
        }
        return manifests.toArray(new Manifest[0]);
    }

    public File[] expandFileSetDirectives(File base, FilesetDirective[] filesets) throws IOException {
        ArrayList<File> list = new ArrayList<File>();
        for (int i = 0; i < filesets.length; ++i) {
            FilesetDirective fileset = filesets[i];
            File anchor = this.getDirectory(base, fileset.getBaseDirectory());
            IncludeDirective[] includes = fileset.getIncludes();
            if (includes.length > 0) {
                for (int j = 0; j < includes.length; ++j) {
                    File file = new File(anchor, includes[j].getPath());
                    list.add(file);
                }
                continue;
            }
            list.add(anchor);
        }
        return list.toArray(new File[0]);
    }

    private File getDirectory(File base, String path) throws IOException {
        File file = new File(path);
        if (file.isAbsolute()) {
            return this.verifyDirectory(file);
        }
        return this.verifyDirectory(new File(base, path));
    }

    private File verifyDirectory(File dir) throws IOException {
        if (dir.isDirectory()) {
            return dir.getCanonicalFile();
        }
        String error = "Path does not correspond to a directory: " + dir;
        throw new IOException(error);
    }

    private Logger getLocalLogger() {
        return this.m_local;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

