/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.data.builder;

import java.util.ArrayList;
import org.apache.avalon.composition.data.CategoriesDirective;
import org.apache.avalon.composition.data.CategoryDirective;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.excalibur.configuration.ConfigurationUtil;

public abstract class XMLProfileCreator {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$data$builder$XMLProfileCreator == null ? (class$org$apache$avalon$composition$data$builder$XMLProfileCreator = XMLProfileCreator.class$("org.apache.avalon.composition.data.builder.XMLProfileCreator")) : class$org$apache$avalon$composition$data$builder$XMLProfileCreator));
    static /* synthetic */ Class class$org$apache$avalon$composition$data$builder$XMLProfileCreator;

    protected String getName(String base, Configuration config, String defaultName) {
        String name = config.getAttribute("name", defaultName);
        if (base == null) {
            return name;
        }
        return base + "-" + name;
    }

    protected boolean getActivationPolicy(Configuration config) {
        return this.getActivationPolicy(config, false);
    }

    protected boolean getActivationPolicy(Configuration config, boolean fallback) {
        String value = config.getAttribute("activation", null);
        if (value == null) {
            return fallback;
        }
        String string = value.toLowerCase().trim();
        if (string.equals("startup") || string.equals("true")) {
            return true;
        }
        return fallback;
    }

    public CategoriesDirective getCategoriesDirective(Configuration config, String name) throws ConfigurationException {
        if (config != null) {
            String priority = config.getAttribute("priority", null);
            String target = config.getAttribute("target", null);
            CategoryDirective[] categories = this.getCategoryDirectives(config.getChildren("category"));
            return new CategoriesDirective(name, priority, target, categories);
        }
        return null;
    }

    private CategoryDirective[] getCategoryDirectives(Configuration[] children) throws ConfigurationException {
        ArrayList<CategoryDirective> list = new ArrayList<CategoryDirective>();
        for (int i = 0; i < children.length; ++i) {
            CategoryDirective category = this.getCategoryDirective(children[i]);
            list.add(category);
        }
        return list.toArray(new CategoryDirective[0]);
    }

    public CategoryDirective getCategoryDirective(Configuration config) throws ConfigurationException {
        try {
            String name = config.getAttribute("name");
            String priority = config.getAttribute("priority", null);
            String target = config.getAttribute("target", null);
            return new CategoryDirective(name, priority, target);
        }
        catch (ConfigurationException e) {
            String error = "Invalid category descriptor." + ConfigurationUtil.list((Configuration)config);
            throw new ConfigurationException(error, (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

