/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.logging.impl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.avalon.composition.data.CategoriesDirective;
import org.apache.avalon.composition.data.CategoryDirective;
import org.apache.avalon.composition.logging.LoggerException;
import org.apache.avalon.composition.logging.LoggingDescriptor;
import org.apache.avalon.composition.logging.LoggingManager;
import org.apache.avalon.composition.logging.TargetDescriptor;
import org.apache.avalon.composition.logging.TargetProvider;
import org.apache.avalon.composition.logging.impl.FileTargetProvider;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.logger.AvalonFormatter;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.FileTarget;
import org.apache.log.output.io.StreamTarget;

public class DefaultLoggingManager
implements LoggingManager {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$logging$impl$DefaultLoggingManager == null ? (class$org$apache$avalon$composition$logging$impl$DefaultLoggingManager = DefaultLoggingManager.class$("org.apache.avalon.composition.logging.impl.DefaultLoggingManager")) : class$org$apache$avalon$composition$logging$impl$DefaultLoggingManager));
    private static final StreamTarget DEFAULT_STREAM = new StreamTarget((OutputStream)System.out, (Formatter)new AvalonFormatter("[%7.7{priority}] (%{category}): %{message}\\n%{throwable}"));
    private File m_baseDirectory;
    private final HashMap m_targets = new HashMap();
    private Hierarchy m_hierarchy = new Hierarchy();
    private org.apache.avalon.framework.logger.Logger m_logger;
    private final boolean m_debug;
    static /* synthetic */ Class class$org$apache$avalon$composition$logging$impl$DefaultLoggingManager;

    public DefaultLoggingManager(File base, LoggingDescriptor descriptor) throws Exception {
        this(base, descriptor, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DefaultLoggingManager(File base, LoggingDescriptor descriptor, boolean debug) throws Exception {
        TargetDescriptor target;
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        if (base == null) {
            throw new NullPointerException("base");
        }
        this.m_baseDirectory = base;
        this.m_debug = debug;
        String defaultPriority = "INFO";
        this.getHierarchy().setDefaultLogTarget((LogTarget)DEFAULT_STREAM);
        this.m_targets.put("default", DEFAULT_STREAM);
        if (!debug) {
            if (descriptor.getPriority() != null) {
                defaultPriority = descriptor.getPriority();
                this.getHierarchy().setDefaultPriority(Priority.getPriorityForName((String)defaultPriority));
            } else {
                this.getHierarchy().setDefaultPriority(Priority.getPriorityForName((String)defaultPriority));
            }
        } else {
            defaultPriority = "DEBUG";
            this.getHierarchy().setDefaultPriority(Priority.getPriorityForName((String)"DEBUG"));
        }
        TargetDescriptor[] targets = descriptor.getTargetDescriptors();
        for (int i = 0; i < targets.length; ++i) {
            target = targets[i];
            this.addTarget(targets[i]);
        }
        String name = descriptor.getTarget();
        if (name != null) {
            target = (LogTarget)this.m_targets.get(name);
            if (target == null) throw new LoggerException("Supplied default logging target: '" + name + "' does not exist.");
            this.getHierarchy().setDefaultLogTarget((LogTarget)target);
        } else {
            this.getHierarchy().setDefaultLogTarget((LogTarget)DEFAULT_STREAM);
        }
        this.addCategories(descriptor.getName(), (CategoriesDirective)descriptor);
        String channel = descriptor.getName() + ".logging";
        this.m_logger = this.getLoggerForCategory(channel);
        if (!this.m_debug) return;
        this.log("default priority: " + defaultPriority);
    }

    public void addCategories(CategoriesDirective descriptor) {
        this.addCategories("", descriptor);
    }

    public void addCategories(String root, CategoriesDirective directive) {
        String path = this.filter(root);
        this.addCategory(path, directive.getPriority(), directive.getTarget());
        CategoryDirective[] categories = directive.getCategories();
        for (int i = 0; i < categories.length; ++i) {
            CategoryDirective category = categories[i];
            String priority = category.getPriority();
            String target = category.getTarget();
            String name = this.filter(category.getName());
            if (path.equals("")) {
                this.addCategory(name, priority, target);
                continue;
            }
            String base = this.filter(path + "." + name);
            this.addCategory(base, priority, target);
        }
    }

    public org.apache.avalon.framework.logger.Logger getLoggerForCategory(String name, String target, String priority) throws Exception {
        return new LogKitLogger(this.addCategory(name, target, priority));
    }

    public org.apache.avalon.framework.logger.Logger getLoggerForCategory(CategoryDirective category) throws Exception {
        return new LogKitLogger(this.addCategory(category.getName(), category.getPriority(), category.getTarget()));
    }

    public org.apache.avalon.framework.logger.Logger getLoggerForCategory(String category) {
        Logger log = this.addCategory(category, null, null);
        return new LogKitLogger(log);
    }

    private Logger addCategory(String path, String priority, String target) {
        return this.addCategory(path, priority, target, true);
    }

    private Logger addCategory(String path, String priority, String target, boolean notify) {
        LogTarget logTarget;
        Logger logger;
        String name = this.filter(path);
        if (this.m_debug) {
            this.log("adding category: " + name + ", " + priority);
        }
        try {
            logger = this.getHierarchy().getLoggerFor(name);
        }
        catch (Throwable e) {
            throw new RuntimeException("Bad category: " + name);
        }
        if (!this.m_debug && priority != null) {
            Priority priorityValue = Priority.getPriorityForName((String)priority);
            if (!priorityValue.getName().equals(priority)) {
                String message = REZ.getString("unknown-priority", (Object)priority, (Object)name);
                throw new IllegalArgumentException(message);
            }
            logger.setPriority(priorityValue);
        }
        if (target != null && !target.equals("default") && (logTarget = (LogTarget)this.m_targets.get(target)) != null) {
            logger.setLogTargets(new LogTarget[]{logTarget});
        }
        return logger;
    }

    private String filter(String name) {
        if (name == null) {
            return "";
        }
        String path = name.replace('/', '.');
        if (path.startsWith(".")) {
            path = path.substring(1);
            return this.filter(path);
        }
        if (path.endsWith(".")) {
            path = path.substring(0, path.length() - 1);
            return this.filter(path);
        }
        return path;
    }

    private void addTarget(TargetDescriptor target) throws Exception {
        String name = target.getName();
        TargetProvider provider = target.getProvider();
        if (provider instanceof FileTargetProvider) {
            FileTargetProvider fileProvider = (FileTargetProvider)provider;
            String filename = fileProvider.getLocation();
            AvalonFormatter formatter = new AvalonFormatter("[%7.7{priority}] (%{category}): %{message}\\n%{throwable}");
            File file = new File(this.m_baseDirectory, filename);
            try {
                FileTarget logTarget = new FileTarget(file.getAbsoluteFile(), false, (Formatter)formatter);
                this.m_targets.put(name, logTarget);
            }
            catch (IOException ioe) {
                String message = REZ.getString("target.nocreate", (Object)name, (Object)file, (Object)ioe.getMessage());
                throw new LoggerException(message, (Throwable)ioe);
            }
        } else {
            String error = "Unrecognized logging provider: " + provider.getClass().getName();
            throw new IllegalArgumentException(error);
        }
    }

    private org.apache.avalon.framework.logger.Logger getLogger() {
        return this.m_logger;
    }

    private Hierarchy getHierarchy() {
        return this.m_hierarchy;
    }

    private void log(String message) {
        if (this.getLogger() != null) {
            this.getLogger().debug(message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

