/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.data.writer;

import java.io.IOException;
import java.io.Writer;
import org.apache.avalon.composition.data.CategoriesDirective;
import org.apache.avalon.composition.data.CategoryDirective;
import org.apache.avalon.composition.data.ConstructorDirective;
import org.apache.avalon.composition.data.ContextDirective;
import org.apache.avalon.composition.data.DependencyDirective;
import org.apache.avalon.composition.data.DeploymentProfile;
import org.apache.avalon.composition.data.EntryDirective;
import org.apache.avalon.composition.data.ImportDirective;
import org.apache.avalon.composition.data.Parameter;
import org.apache.avalon.composition.data.SelectionDirective;
import org.apache.avalon.composition.data.StageDirective;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.excalibur.configuration.ConfigurationUtil;

public class XMLDeploymentProfileWriter {
    public static final String INDENT = "  ";

    protected void writeDeploymentProfile(Writer writer, DeploymentProfile profile, String pad) throws Exception {
        writer.write(pad + "<component name=\"" + profile.getName() + "\"");
        writer.write("\n" + pad + "  class=\"" + profile.getClassname() + "\"");
        if (!profile.getActivationPolicy()) {
            writer.write("\n" + pad + "  activation=\"false\"");
        }
        if (profile.getCategories() == null && profile.getContext() == null && this.isEmptyConfiguration(profile.getConfiguration()) && profile.getParameters() == null) {
            writer.write("/>");
        } else {
            writer.write(">");
            String padding = pad + INDENT;
            this.writeDeploymentBody(writer, profile, padding);
            writer.write("\n" + pad + "</component>");
        }
    }

    private boolean isEmptyConfiguration(Configuration config) {
        if (config == null) {
            return true;
        }
        if (config.getChildren().length > 0) {
            return false;
        }
        return config.getAttributeNames().length == 0;
    }

    protected void writeDeploymentBody(Writer writer, DeploymentProfile profile, String pad) throws Exception {
        this.writeCategories(writer, profile.getCategories(), pad);
        this.writeContext(writer, profile.getContext(), pad);
        this.writeDependencies(writer, profile.getDependencyDirectives(), pad);
        this.writeStages(writer, profile.getStageDirectives(), pad);
        this.writeConfiguration(writer, profile.getConfiguration(), pad);
        this.writeParameters(writer, profile.getParameters(), pad);
    }

    private void writeDependencies(Writer writer, DependencyDirective[] dependencies, String pad) throws IOException {
        if (dependencies.length == 0) {
            return;
        }
        writer.write("\n" + pad + "<dependencies>");
        String padding = pad + INDENT;
        for (int i = 0; i < dependencies.length; ++i) {
            this.writeDependency(writer, dependencies[i], padding);
        }
        writer.write("\n" + pad + "</dependencies>");
    }

    private void writeDependency(Writer writer, DependencyDirective dependency, String pad) throws IOException {
        writer.write("\n" + pad + "<dependency key=\"" + dependency.getKey() + "\"");
        if (dependency.getSource() != null) {
            writer.write(" source=\"" + dependency.getSource() + "\"/>");
        } else {
            writer.write(">");
            SelectionDirective[] features = dependency.getSelectionDirectives();
            String padding = pad + INDENT;
            for (int i = 0; i < features.length; ++i) {
                this.writeSelectionDirective(writer, features[i], padding);
            }
            writer.write("\n" + pad + "</dependency>");
        }
    }

    private void writeStages(Writer writer, StageDirective[] stages, String pad) throws IOException {
        if (stages.length == 0) {
            return;
        }
        writer.write("\n" + pad + "<stages>");
        String padding = pad + INDENT;
        for (int i = 0; i < stages.length; ++i) {
            this.writeStage(writer, stages[i], padding);
        }
        writer.write("\n" + pad + "</stages>");
    }

    private void writeStage(Writer writer, StageDirective stage, String pad) throws IOException {
        writer.write("\n" + pad + "<stage key=\"" + stage.getKey() + "\"");
        if (stage.getSource() != null) {
            writer.write(" source=\"" + stage.getSource() + "\"/>");
        } else {
            writer.write(">");
            SelectionDirective[] features = stage.getSelectionDirectives();
            String padding = pad + INDENT;
            for (int i = 0; i < features.length; ++i) {
                this.writeSelectionDirective(writer, features[i], padding);
            }
            writer.write("\n" + pad + "</stage>");
        }
    }

    private void writeSelectionDirective(Writer writer, SelectionDirective feature, String pad) throws IOException {
        writer.write("\n" + pad + "<select feature=\"" + feature.getFeature() + "\" value=\"" + feature.getValue() + "\" match=\"" + feature.getCriteria() + "\"");
        if (feature.isOptional()) {
            writer.write(" optional=\"true\"/>");
        } else {
            writer.write("/>");
        }
    }

    protected void writeCategories(Writer writer, CategoriesDirective categories, String pad) throws IOException {
        if (categories == null) {
            return;
        }
        if (categories.getPriority() == null && categories.getTarget() == null && categories.getCategories().length == 0) {
            return;
        }
        writer.write("\n" + pad + "<categories");
        if (categories.getPriority() != null) {
            writer.write(" priority=\"" + categories.getPriority() + "\"");
        }
        if (categories.getTarget() != null) {
            writer.write(" target=\"" + categories.getTarget() + "\"");
        }
        if (categories.getCategories().length > 0) {
            writer.write(">");
            CategoryDirective[] cats = categories.getCategories();
            String padding = pad + INDENT;
            for (int i = 0; i < cats.length; ++i) {
                this.writeCategoryDirective(writer, cats[i], padding);
            }
            writer.write("\n" + pad + "</categories>");
        } else {
            writer.write("/>");
        }
    }

    private void writeCategoryDirective(Writer writer, CategoryDirective category, String pad) throws IOException {
        writer.write("\n" + pad + "<category name=\"" + category.getName() + "\"");
        if (category.getPriority() != null) {
            writer.write(" priority=\"" + category.getPriority() + "\"");
        }
        if (category.getTarget() != null) {
            writer.write(" target=\"" + category.getTarget() + "\"");
        }
        writer.write("/>");
    }

    private void writeConfiguration(Writer writer, Configuration config, String pad) throws IOException {
        if (!this.isEmptyConfiguration(config)) {
            StringBuffer buffer = new StringBuffer();
            ConfigurationUtil.list((StringBuffer)buffer, (String)pad, (Configuration)config);
            writer.write("\n" + buffer.toString());
        }
    }

    private void writeContext(Writer writer, ContextDirective context, String pad) throws IOException {
        EntryDirective[] entries;
        if (context == null) {
            return;
        }
        writer.write("\n" + pad + "<context");
        if (context.getClassname() != null) {
            writer.write(" class=\"" + context.getClassname() + "\"");
        }
        if (context.getSource() != null) {
            writer.write(" source=\"" + context.getSource() + "\"");
        }
        if ((entries = context.getEntryDirectives()).length == 0) {
            writer.write("/>");
            return;
        }
        writer.write(">");
        String padding = pad + INDENT;
        for (int i = 0; i < entries.length; ++i) {
            EntryDirective entry = entries[i];
            this.writeEntryDirective(writer, entry, padding);
        }
        writer.write("\n" + pad + "</context>");
    }

    private void writeEntryDirective(Writer writer, EntryDirective entry, String pad) throws IOException {
        String padding = pad + INDENT;
        writer.write("\n" + pad + "<entry");
        writer.write(" key=\"" + entry.getKey() + "\">");
        if (entry instanceof ImportDirective) {
            ImportDirective imp = (ImportDirective)entry;
            writer.write("\n" + padding + "<import");
            writer.write(" key=\"" + imp.getImportKey() + "\"");
            writer.write("/>");
        } else if (entry instanceof ConstructorDirective) {
            String fill = padding + INDENT;
            ConstructorDirective cd = (ConstructorDirective)entry;
            writer.write("\n" + padding + "<constructor");
            if (!cd.getClassname().equals("java.lang.String")) {
                writer.write(" class=\"" + cd.getClassname() + "\"");
            }
            writer.write(">");
            if (cd.getParameters().length > 0) {
                this.writeParams(writer, cd.getParameters(), fill);
                writer.write("\n" + padding + "</constructor>");
            } else {
                writer.write(cd.getArgument());
                writer.write("</constructor>");
            }
        }
        writer.write("\n" + pad + "</entry>");
    }

    private void writeParams(Writer writer, Parameter[] params, String pad) throws IOException {
        for (int i = 0; i < params.length; ++i) {
            this.writeParam(writer, params[i], pad);
        }
    }

    private void writeParam(Writer writer, Parameter param, String pad) throws IOException {
        writer.write("\n" + pad + "<param");
        if (param.getClassname() != null && !param.getClassname().equals("java.lang.String")) {
            writer.write(" class=\"" + param.getClassname() + "\"");
        }
        writer.write(">");
        Parameter[] parameters = param.getParameters();
        if (parameters.length > 0) {
            String padding = pad + INDENT;
            this.writeParams(writer, parameters, padding);
            writer.write("\n" + pad + "</param>");
        } else {
            writer.write(param.getArgument() + "</param>");
        }
    }

    private void writeParameters(Writer writer, Parameters params, String pad) throws IOException, ParameterException {
        if (params == null) {
            return;
        }
        String[] names = params.getNames();
        String padding = pad + INDENT;
        writer.write("\n" + pad + "<parameters>");
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String value = params.getParameter(name);
            writer.write("\n" + padding + "<parameter");
            writer.write(" name=\"" + name + "\"");
            writer.write(" value=\"" + value + "\"/>");
        }
        writer.write("\n" + pad + "</parameters>");
    }
}

