/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.data;

import java.io.Serializable;
import org.apache.avalon.composition.data.EntryDirective;

public class ContextDirective
implements Serializable {
    private final EntryDirective[] m_entries;
    private final String m_classname;
    private final String m_source;

    public ContextDirective(EntryDirective[] entries) {
        this(null, entries);
    }

    public ContextDirective(String classname, EntryDirective[] entries) {
        this(classname, entries, null);
    }

    public ContextDirective(String classname, EntryDirective[] entries, String source) {
        this.m_source = source;
        this.m_classname = classname;
        this.m_entries = entries != null ? entries : new EntryDirective[0];
    }

    public String getSource() {
        return this.m_source;
    }

    public String getClassname() {
        return this.m_classname;
    }

    public EntryDirective[] getEntryDirectives() {
        return this.m_entries;
    }

    public EntryDirective getEntryDirective(String key) {
        for (int i = 0; i < this.m_entries.length; ++i) {
            EntryDirective entry = this.m_entries[i];
            if (!entry.getKey().equals(key)) continue;
            return entry;
        }
        return null;
    }
}

