/*
 * Consumer Data Standards
 * Sample client library to Demonstrate the Consumer Data Right APIs
 *
 * NOTE: This class is auto generated by the codegen artefact
 * https://github.com/ConsumerDataStandardsAustralia/java-artefacts/codegen
 */
package au.org.consumerdatastandards.client.model;

import java.util.List;
import java.util.Objects;

public class BankingAccountDetail extends BankingAccount {

    public enum SpecificAccountUType {
        termDeposit,
        creditCard,
        loan
    }

    private String bsb;

    private String accountNumber;

    private String bundleName;

    private SpecificAccountUType specificAccountUType;

    private List<BankingTermDepositAccount> termDeposit;

    private BankingCreditCardAccount creditCard;

    private BankingLoanAccount loan;

    private String depositRate;

    private String lendingRate;

    private List<BankingProductDepositRate> depositRates;

    private List<BankingProductLendingRate> lendingRates;

    private List<Object> features;

    private List<BankingProductFee> fees;

    private List<CommonPhysicalAddress> addresses;

    /**
     * The unmasked BSB for the account. Is expected to be formatted as digits only with leading zeros included and no punctuation or spaces
     * @return bsb
     */
    public String getBsb() {
        return bsb;
    }

    public void setBsb(String bsb) {
        this.bsb = bsb;
    }

    /**
     * The unmasked account number for the account. Should not be supplied if the account number is a PAN requiring PCI compliance. Is expected to be formatted as digits only with leading zeros included and no punctuation or spaces
     * @return accountNumber
     */
    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    /**
     * Optional field to indicate if this account is part of a bundle that is providing additional benefit for to the customer
     * @return bundleName
     */
    public String getBundleName() {
        return bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    /**
     * The type of structure to present account specific fields.
     * @return specificAccountUType
     */
    public SpecificAccountUType getSpecificAccountUType() {
        return specificAccountUType;
    }

    public void setSpecificAccountUType(SpecificAccountUType specificAccountUType) {
        this.specificAccountUType = specificAccountUType;
    }

    /**
     * Get termDeposit
     * @return termDeposit
     */
    public List<BankingTermDepositAccount> getTermDeposit() {
        return termDeposit;
    }

    public void setTermDeposit(List<BankingTermDepositAccount> termDeposit) {
        this.termDeposit = termDeposit;
    }

    /**
     * Get creditCard
     * @return creditCard
     */
    public BankingCreditCardAccount getCreditCard() {
        return creditCard;
    }

    public void setCreditCard(BankingCreditCardAccount creditCard) {
        this.creditCard = creditCard;
    }

    /**
     * Get loan
     * @return loan
     */
    public BankingLoanAccount getLoan() {
        return loan;
    }

    public void setLoan(BankingLoanAccount loan) {
        this.loan = loan;
    }

    /**
     * current rate to calculate interest earned being applied to deposit balances as it stands at the time of the API call
     * @return depositRate
     */
    public String getDepositRate() {
        return depositRate;
    }

    public void setDepositRate(String depositRate) {
        this.depositRate = depositRate;
    }

    /**
     * The current rate to calculate interest payable being applied to lending balances as it stands at the time of the API call
     * @return lendingRate
     */
    public String getLendingRate() {
        return lendingRate;
    }

    public void setLendingRate(String lendingRate) {
        this.lendingRate = lendingRate;
    }

    /**
     * Fully described deposit rates for this account based on the equivalent structure in Product Reference
     * @return depositRates
     */
    public List<BankingProductDepositRate> getDepositRates() {
        return depositRates;
    }

    public void setDepositRates(List<BankingProductDepositRate> depositRates) {
        this.depositRates = depositRates;
    }

    /**
     * Fully described deposit rates for this account based on the equivalent structure in Product Reference
     * @return lendingRates
     */
    public List<BankingProductLendingRate> getLendingRates() {
        return lendingRates;
    }

    public void setLendingRates(List<BankingProductLendingRate> lendingRates) {
        this.lendingRates = lendingRates;
    }

    /**
     * Array of features of the account based on the equivalent structure in Product Reference with the following additional field
     * @return features
     */
    public List<Object> getFeatures() {
        return features;
    }

    public void setFeatures(List<Object> features) {
        this.features = features;
    }

    /**
     * Fees and charges applicable to the account based on the equivalent structure in Product Reference
     * @return fees
     */
    public List<BankingProductFee> getFees() {
        return fees;
    }

    public void setFees(List<BankingProductFee> fees) {
        this.fees = fees;
    }

    /**
     * The addresses for the account to be used for correspondence
     * @return addresses
     */
    public List<CommonPhysicalAddress> getAddresses() {
        return addresses;
    }

    public void setAddresses(List<CommonPhysicalAddress> addresses) {
        this.addresses = addresses;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BankingAccountDetail bankingAccountDetail = (BankingAccountDetail) o;
        return Objects.equals(this.bsb, bankingAccountDetail.bsb) &&
            Objects.equals(this.accountNumber, bankingAccountDetail.accountNumber) &&
            Objects.equals(this.bundleName, bankingAccountDetail.bundleName) &&
            Objects.equals(this.specificAccountUType, bankingAccountDetail.specificAccountUType) &&
            Objects.equals(this.termDeposit, bankingAccountDetail.termDeposit) &&
            Objects.equals(this.creditCard, bankingAccountDetail.creditCard) &&
            Objects.equals(this.loan, bankingAccountDetail.loan) &&
            Objects.equals(this.depositRate, bankingAccountDetail.depositRate) &&
            Objects.equals(this.lendingRate, bankingAccountDetail.lendingRate) &&
            Objects.equals(this.depositRates, bankingAccountDetail.depositRates) &&
            Objects.equals(this.lendingRates, bankingAccountDetail.lendingRates) &&
            Objects.equals(this.features, bankingAccountDetail.features) &&
            Objects.equals(this.fees, bankingAccountDetail.fees) &&
            Objects.equals(this.addresses, bankingAccountDetail.addresses) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            bsb,
            accountNumber,
            bundleName,
            specificAccountUType,
            termDeposit,
            creditCard,
            loan,
            depositRate,
            lendingRate,
            depositRates,
            lendingRates,
            features,
            fees,
            addresses,
            super.hashCode());
    }

    @Override
    public String toString() {
        return "class BankingAccountDetail {\n" +
            "   accountId: " + toIndentedString(getAccountId()) + "\n" +
            "   creationDate: " + toIndentedString(getCreationDate()) + "\n" +
            "   displayName: " + toIndentedString(getDisplayName()) + "\n" +
            "   nickname: " + toIndentedString(getNickname()) + "\n" +
            "   openStatus: " + toIndentedString(getOpenStatus()) + "\n" +
            "   isOwned: " + toIndentedString(getIsOwned()) + "\n" +
            "   maskedNumber: " + toIndentedString(getMaskedNumber()) + "\n" +
            "   productCategory: " + toIndentedString(getProductCategory()) + "\n" +
            "   productName: " + toIndentedString(getProductName()) + "\n" +
            "   bsb: " + toIndentedString(bsb) + "\n" +
            "   accountNumber: " + toIndentedString(accountNumber) + "\n" +
            "   bundleName: " + toIndentedString(bundleName) + "\n" +
            "   specificAccountUType: " + toIndentedString(specificAccountUType) + "\n" +
            "   termDeposit: " + toIndentedString(termDeposit) + "\n" +
            "   creditCard: " + toIndentedString(creditCard) + "\n" +
            "   loan: " + toIndentedString(loan) + "\n" +
            "   depositRate: " + toIndentedString(depositRate) + "\n" +
            "   lendingRate: " + toIndentedString(lendingRate) + "\n" +
            "   depositRates: " + toIndentedString(depositRates) + "\n" +
            "   lendingRates: " + toIndentedString(lendingRates) + "\n" +
            "   features: " + toIndentedString(features) + "\n" +
            "   fees: " + toIndentedString(fees) + "\n" +
            "   addresses: " + toIndentedString(addresses) + "\n" +
            "}";
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
