/*
 * Consumer Data Standards
 * Sample client library to Demonstrate the Consumer Data Right APIs
 *
 * NOTE: This class is auto generated by the codegen artefact
 * https://github.com/ConsumerDataStandardsAustralia/java-artefacts/codegen
 * Do not edit the class manually.
 */
package au.org.consumerdatastandards.client.model;

import com.google.gson.annotations.SerializedName;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

public class BankingProductLendingRate {

  /**
   * The type of rate (fixed, variable, etc). See the next
   * section for an overview of valid values and their meaning
   */
  @SerializedName("lendingRateType")
  private LendingRateType lendingRateType;

  /**
   * The rate to be applied
   */
  @SerializedName("rate")
  private BigDecimal rate;

  /**
   * A comparison rate equivalent for this rate
   */
  @SerializedName("comparisonRate")
  private BigDecimal comparisonRate;

  /**
   * The period after which the rate is applied to the balance to
   * calculate the amount due for the period. Calculation of the
   * amount is often daily (as balances may change) but
   * accumulated until the total amount is 'applied' to the
   * account (see applicationFrequency). Formatted according to
   * [ISO 8601
   * Durations](https:*en.wikipedia.org/wiki/ISO_8601#Durations)
   */
  @SerializedName("calculationFrequency")
  private String calculationFrequency;

  /**
   * The period after which the calculated amount(s) (see
   * calculationFrequency) are 'applied' (i.e. debited or
   * credited) to the account. Formatted according to [ISO 8601
   * Durations](https:*en.wikipedia.org/wiki/ISO_8601#Durations)
   */
  @SerializedName("applicationFrequency")
  private String applicationFrequency;

  /**
   * When loan payments are due to be paid within each period.
   * The investment benefit of earlier payments affect the rate
   * that can be offered
   */
  @SerializedName("interestPaymentDue")
  private InterestPaymentDue interestPaymentDue;

  /**
   * Rate tiers applicable for this rate
   */
  @SerializedName("tiers")
  private List<BankingProductRateTier> tiers;

  /**
   * Generic field containing additional information relevant to
   * the lendingRateType specified. Whether mandatory or not is
   * dependent on the value of lendingRateType
   */
  @SerializedName("additionalValue")
  private String additionalValue;

  /**
   * Display text providing more information on the rate.
   */
  @SerializedName("additionalInfo")
  private String additionalInfo;

  /**
   * Link to a web page with more information on this rate
   */
  @SerializedName("additionalInfoUri")
  private String additionalInfoUri;

  public LendingRateType getLendingRateType() {
    return lendingRateType;
  }

  public void setLendingRateType(LendingRateType lendingRateType) {
    this.lendingRateType = lendingRateType;
  }

  public BankingProductLendingRate lendingRateType(LendingRateType lendingRateType) {
    this.lendingRateType = lendingRateType;
    return this;
  }

  public BigDecimal getRate() {
    return rate;
  }

  public void setRate(BigDecimal rate) {
    this.rate = rate;
  }

  public BankingProductLendingRate rate(BigDecimal rate) {
    this.rate = rate;
    return this;
  }

  public BigDecimal getComparisonRate() {
    return comparisonRate;
  }

  public void setComparisonRate(BigDecimal comparisonRate) {
    this.comparisonRate = comparisonRate;
  }

  public BankingProductLendingRate comparisonRate(BigDecimal comparisonRate) {
    this.comparisonRate = comparisonRate;
    return this;
  }

  public String getCalculationFrequency() {
    return calculationFrequency;
  }

  public void setCalculationFrequency(String calculationFrequency) {
    this.calculationFrequency = calculationFrequency;
  }

  public BankingProductLendingRate calculationFrequency(String calculationFrequency) {
    this.calculationFrequency = calculationFrequency;
    return this;
  }

  public String getApplicationFrequency() {
    return applicationFrequency;
  }

  public void setApplicationFrequency(String applicationFrequency) {
    this.applicationFrequency = applicationFrequency;
  }

  public BankingProductLendingRate applicationFrequency(String applicationFrequency) {
    this.applicationFrequency = applicationFrequency;
    return this;
  }

  public InterestPaymentDue getInterestPaymentDue() {
    return interestPaymentDue;
  }

  public void setInterestPaymentDue(InterestPaymentDue interestPaymentDue) {
    this.interestPaymentDue = interestPaymentDue;
  }

  public BankingProductLendingRate interestPaymentDue(InterestPaymentDue interestPaymentDue) {
    this.interestPaymentDue = interestPaymentDue;
    return this;
  }

  public List<BankingProductRateTier> getTiers() {
    return tiers;
  }

  public void setTiers(List<BankingProductRateTier> tiers) {
    this.tiers = tiers;
  }

  public BankingProductLendingRate tiers(List<BankingProductRateTier> tiers) {
    this.tiers = tiers;
    return this;
  }

  public String getAdditionalValue() {
    return additionalValue;
  }

  public void setAdditionalValue(String additionalValue) {
    this.additionalValue = additionalValue;
  }

  public BankingProductLendingRate additionalValue(String additionalValue) {
    this.additionalValue = additionalValue;
    return this;
  }

  public String getAdditionalInfo() {
    return additionalInfo;
  }

  public void setAdditionalInfo(String additionalInfo) {
    this.additionalInfo = additionalInfo;
  }

  public BankingProductLendingRate additionalInfo(String additionalInfo) {
    this.additionalInfo = additionalInfo;
    return this;
  }

  public String getAdditionalInfoUri() {
    return additionalInfoUri;
  }

  public void setAdditionalInfoUri(String additionalInfoUri) {
    this.additionalInfoUri = additionalInfoUri;
  }

  public BankingProductLendingRate additionalInfoUri(String additionalInfoUri) {
    this.additionalInfoUri = additionalInfoUri;
    return this;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    BankingProductLendingRate inputModel = (BankingProductLendingRate) o;
    if (!(lendingRateType.equals(inputModel.getLendingRateType()))) {
      return false;
    }
    if (!(rate.equals(inputModel.getRate()))) {
      return false;
    }
    if (!(comparisonRate.equals(inputModel.getComparisonRate()))) {
      return false;
    }
    if (!(calculationFrequency.equals(inputModel.getCalculationFrequency()))) {
      return false;
    }
    if (!(applicationFrequency.equals(inputModel.getApplicationFrequency()))) {
      return false;
    }
    if (!(interestPaymentDue.equals(inputModel.getInterestPaymentDue()))) {
      return false;
    }
    if (!(tiers.equals(inputModel.getTiers()))) {
      return false;
    }
    if (!(additionalValue.equals(inputModel.getAdditionalValue()))) {
      return false;
    }
    if (!(additionalInfo.equals(inputModel.getAdditionalInfo()))) {
      return false;
    }
    return additionalInfoUri.equals(inputModel.getAdditionalInfoUri());
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        lendingRateType,
        rate,
        comparisonRate,
        calculationFrequency,
        applicationFrequency,
        interestPaymentDue,
        tiers,
        additionalValue,
        additionalInfo,
        additionalInfoUri);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append(String.format("class %s {\n", getClass()));
    sb.append("    lendingRateType: ").append(toIndentedString(lendingRateType)).append("\n");
    sb.append("    rate: ").append(toIndentedString(rate)).append("\n");
    sb.append("    comparisonRate: ").append(toIndentedString(comparisonRate)).append("\n");
    sb.append("    calculationFrequency: ")
        .append(toIndentedString(calculationFrequency))
        .append("\n");
    sb.append("    applicationFrequency: ")
        .append(toIndentedString(applicationFrequency))
        .append("\n");
    sb.append("    interestPaymentDue: ").append(toIndentedString(interestPaymentDue)).append("\n");
    sb.append("    tiers: ").append(toIndentedString(tiers)).append("\n");
    sb.append("    additionalValue: ").append(toIndentedString(additionalValue)).append("\n");
    sb.append("    additionalInfo: ").append(toIndentedString(additionalInfo)).append("\n");
    sb.append("    additionalInfoUri: ").append(toIndentedString(additionalInfoUri)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  public enum InterestPaymentDue {
    IN_ARREARS,
    IN_ADVANCE
  }

  public enum LendingRateType {
    FIXED,
    VARIABLE,
    INTRODUCTORY,
    DISCOUNT,
    PENALTY,
    FLOATING,
    MARKET_LINKED,
    CASH_ADVANCE,
    PURCHASE,
    BUNDLE_DISCOUNT_FIXED,
    BUNDLE_DISCOUNT_VARIABLE
  }
}
