/*
 * Consumer Data Standards
 * Sample client library to Demonstrate the Consumer Data Right APIs
 *
 * NOTE: This class is auto generated by the codegen artefact
 * https://github.com/ConsumerDataStandardsAustralia/java-artefacts/codegen
 * Do not edit the class manually.
 */
package au.org.consumerdatastandards.client.model;

import com.google.gson.annotations.SerializedName;

import java.util.Objects;

public class BankingProductDiscountEligibility {

  /**
   * The type of the specific eligibility constraint for a
   * discount
   */
  @SerializedName("discountEligibilityType")
  private DiscountEligibilityType discountEligibilityType;

  /**
   * Generic field containing additional information relevant to
   * the discountEligibilityType specified. Whether mandatory or
   * not is dependent on the value of discountEligibilityType
   */
  @SerializedName("additionalValue")
  private String additionalValue;

  /**
   * Display text providing more information on this eligibility
   * constraint
   */
  @SerializedName("additionalInfo")
  private String additionalInfo;

  /**
   * Link to a web page with more information on this eligibility
   * constraint
   */
  @SerializedName("additionalInfoUri")
  private String additionalInfoUri;

  public DiscountEligibilityType getDiscountEligibilityType() {
    return discountEligibilityType;
  }

  public void setDiscountEligibilityType(DiscountEligibilityType discountEligibilityType) {
    this.discountEligibilityType = discountEligibilityType;
  }

  public BankingProductDiscountEligibility discountEligibilityType(
      DiscountEligibilityType discountEligibilityType) {
    this.discountEligibilityType = discountEligibilityType;
    return this;
  }

  public String getAdditionalValue() {
    return additionalValue;
  }

  public void setAdditionalValue(String additionalValue) {
    this.additionalValue = additionalValue;
  }

  public BankingProductDiscountEligibility additionalValue(String additionalValue) {
    this.additionalValue = additionalValue;
    return this;
  }

  public String getAdditionalInfo() {
    return additionalInfo;
  }

  public void setAdditionalInfo(String additionalInfo) {
    this.additionalInfo = additionalInfo;
  }

  public BankingProductDiscountEligibility additionalInfo(String additionalInfo) {
    this.additionalInfo = additionalInfo;
    return this;
  }

  public String getAdditionalInfoUri() {
    return additionalInfoUri;
  }

  public void setAdditionalInfoUri(String additionalInfoUri) {
    this.additionalInfoUri = additionalInfoUri;
  }

  public BankingProductDiscountEligibility additionalInfoUri(String additionalInfoUri) {
    this.additionalInfoUri = additionalInfoUri;
    return this;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    BankingProductDiscountEligibility inputModel = (BankingProductDiscountEligibility) o;
    if (!(discountEligibilityType.equals(inputModel.getDiscountEligibilityType()))) {
      return false;
    }
    if (!(additionalValue.equals(inputModel.getAdditionalValue()))) {
      return false;
    }
    if (!(additionalInfo.equals(inputModel.getAdditionalInfo()))) {
      return false;
    }
    return additionalInfoUri.equals(inputModel.getAdditionalInfoUri());
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        discountEligibilityType,
        additionalValue,
        additionalInfo,
        additionalInfoUri);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append(String.format("class %s {\n", getClass()));
    sb.append("    discountEligibilityType: ")
        .append(toIndentedString(discountEligibilityType))
        .append("\n");
    sb.append("    additionalValue: ").append(toIndentedString(additionalValue)).append("\n");
    sb.append("    additionalInfo: ").append(toIndentedString(additionalInfo)).append("\n");
    sb.append("    additionalInfoUri: ").append(toIndentedString(additionalInfoUri)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  public enum DiscountEligibilityType {
    BUSINESS,
    PENSION_RECIPIENT,
    MIN_AGE,
    MAX_AGE,
    MIN_INCOME,
    MIN_TURNOVER,
    STAFF,
    STUDENT,
    EMPLOYMENT_STATUS,
    RESIDENCY_STATUS,
    NATURAL_PERSON,
    INTRODUCTORY,
    OTHER
  }
}
