/*
 * Consumer Data Standards
 * Sample client library to Demonstrate the Consumer Data Right APIs
 *
 * NOTE: This class is auto generated by the codegen artefact
 * https://github.com/ConsumerDataStandardsAustralia/java-artefacts/codegen
 * Do not edit the class manually.
 */
package au.org.consumerdatastandards.client.model;

import com.google.gson.annotations.SerializedName;

import java.util.Objects;
import java.util.List;
import java.time.OffsetDateTime;

public class BankingProductDetail {

  /**
   * A provider specific unique identifier for this product. This
   * identifier must be unique to a product but does not
   * otherwise need to adhere to ID permanence guidelines.
   */
  @SerializedName("productId")
  private String productId;

  /**
   * The date and time from which this product is effective (ie.
   * is available for origination).  Used to enable the
   * articulation of products to the regime before they are
   * available for customers to originate
   */
  @SerializedName("effectiveFrom")
  private OffsetDateTime effectiveFrom;

  /**
   * The date and time at which this product will be retired and
   * will no longer be offered.  Used to enable the managed
   * deprecation of products
   */
  @SerializedName("effectiveTo")
  private OffsetDateTime effectiveTo;

  /**
   * The last date and time that the information for this product
   * was changed (or the creation date for the product if it has
   * never been altered)
   */
  @SerializedName("lastUpdated")
  private OffsetDateTime lastUpdated;

  @SerializedName("productCategory")
  private BankingEnumProductCategory productCategory;

  /**
   * The display name of the product
   */
  @SerializedName("name")
  private String name;

  /**
   * A description of the product
   */
  @SerializedName("description")
  private String description;

  /**
   * A label of the brand for the product. Able to be used for
   * filtering. For data providers with single brands this value
   * is still required
   */
  @SerializedName("brand")
  private String brand;

  /**
   * An optional display name of the brand
   */
  @SerializedName("brandName")
  private String brandName;

  /**
   * A link to an application web page where this product can be
   * applied for.
   */
  @SerializedName("applicationUri")
  private String applicationUri;

  /**
   * Indicates whether the product is specifically tailored to a
   * circumstance.  In this case fees and prices are
   * significantly negotiated depending on context. While all
   * products are open to a degree of tailoring this flag
   * indicates that tailoring is expected and thus that the
   * provision of specific fees and rates is not applicable
   */
  @SerializedName("isTailored")
  private Boolean isTailored;

  @SerializedName("additionalInformation")
  private BankingProductAdditionalInformation additionalInformation;

  /**
   * An array of bundles that this product participates in.  Each
   * bundle is described by free form information but also by a
   * list of product IDs of the other products that are included
   * in the bundle.  It is assumed that the current product is
   * included in the bundle also
   */
  @SerializedName("bundles")
  private List<BankingProductBundle> bundles;

  /**
   * Array of features available for the product
   */
  @SerializedName("features")
  private List<BankingProductFeature> features;

  /**
   * Constraints on the application for or operation of the
   * product such as minimum balances or limit thresholds
   */
  @SerializedName("constraints")
  private List<BankingProductConstraint> constraints;

  /**
   * Eligibility criteria for the product
   */
  @SerializedName("eligibility")
  private List<BankingProductEligibility> eligibility;

  /**
   * Fees applicable for the product
   */
  @SerializedName("fees")
  private List<BankingProductFee> fees;

  /**
   * Interest rates available for deposits
   */
  @SerializedName("depositRates")
  private List<BankingProductDepositRate> depositRates;

  /**
   * Interest rates charged against lending balances
   */
  @SerializedName("lendingRates")
  private List<BankingProductLendingRate> lendingRates;

  public String getProductId() {
    return productId;
  }

  public void setProductId(String productId) {
    this.productId = productId;
  }

  public BankingProductDetail productId(String productId) {
    this.productId = productId;
    return this;
  }

  public OffsetDateTime getEffectiveFrom() {
    return effectiveFrom;
  }

  public void setEffectiveFrom(OffsetDateTime effectiveFrom) {
    this.effectiveFrom = effectiveFrom;
  }

  public BankingProductDetail effectiveFrom(OffsetDateTime effectiveFrom) {
    this.effectiveFrom = effectiveFrom;
    return this;
  }

  public OffsetDateTime getEffectiveTo() {
    return effectiveTo;
  }

  public void setEffectiveTo(OffsetDateTime effectiveTo) {
    this.effectiveTo = effectiveTo;
  }

  public BankingProductDetail effectiveTo(OffsetDateTime effectiveTo) {
    this.effectiveTo = effectiveTo;
    return this;
  }

  public OffsetDateTime getLastUpdated() {
    return lastUpdated;
  }

  public void setLastUpdated(OffsetDateTime lastUpdated) {
    this.lastUpdated = lastUpdated;
  }

  public BankingProductDetail lastUpdated(OffsetDateTime lastUpdated) {
    this.lastUpdated = lastUpdated;
    return this;
  }

  public BankingEnumProductCategory getProductCategory() {
    return productCategory;
  }

  public void setProductCategory(BankingEnumProductCategory productCategory) {
    this.productCategory = productCategory;
  }

  public BankingProductDetail productCategory(BankingEnumProductCategory productCategory) {
    this.productCategory = productCategory;
    return this;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public BankingProductDetail name(String name) {
    this.name = name;
    return this;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public BankingProductDetail description(String description) {
    this.description = description;
    return this;
  }

  public String getBrand() {
    return brand;
  }

  public void setBrand(String brand) {
    this.brand = brand;
  }

  public BankingProductDetail brand(String brand) {
    this.brand = brand;
    return this;
  }

  public String getBrandName() {
    return brandName;
  }

  public void setBrandName(String brandName) {
    this.brandName = brandName;
  }

  public BankingProductDetail brandName(String brandName) {
    this.brandName = brandName;
    return this;
  }

  public String getApplicationUri() {
    return applicationUri;
  }

  public void setApplicationUri(String applicationUri) {
    this.applicationUri = applicationUri;
  }

  public BankingProductDetail applicationUri(String applicationUri) {
    this.applicationUri = applicationUri;
    return this;
  }

  public Boolean getIsTailored() {
    return isTailored;
  }

  public void setIsTailored(Boolean isTailored) {
    this.isTailored = isTailored;
  }

  public BankingProductDetail isTailored(Boolean isTailored) {
    this.isTailored = isTailored;
    return this;
  }

  public BankingProductAdditionalInformation getAdditionalInformation() {
    return additionalInformation;
  }

  public void setAdditionalInformation(BankingProductAdditionalInformation additionalInformation) {
    this.additionalInformation = additionalInformation;
  }

  public BankingProductDetail additionalInformation(
      BankingProductAdditionalInformation additionalInformation) {
    this.additionalInformation = additionalInformation;
    return this;
  }

  public List<BankingProductBundle> getBundles() {
    return bundles;
  }

  public void setBundles(List<BankingProductBundle> bundles) {
    this.bundles = bundles;
  }

  public BankingProductDetail bundles(List<BankingProductBundle> bundles) {
    this.bundles = bundles;
    return this;
  }

  public List<BankingProductFeature> getFeatures() {
    return features;
  }

  public void setFeatures(List<BankingProductFeature> features) {
    this.features = features;
  }

  public BankingProductDetail features(List<BankingProductFeature> features) {
    this.features = features;
    return this;
  }

  public List<BankingProductConstraint> getConstraints() {
    return constraints;
  }

  public void setConstraints(List<BankingProductConstraint> constraints) {
    this.constraints = constraints;
  }

  public BankingProductDetail constraints(List<BankingProductConstraint> constraints) {
    this.constraints = constraints;
    return this;
  }

  public List<BankingProductEligibility> getEligibility() {
    return eligibility;
  }

  public void setEligibility(List<BankingProductEligibility> eligibility) {
    this.eligibility = eligibility;
  }

  public BankingProductDetail eligibility(List<BankingProductEligibility> eligibility) {
    this.eligibility = eligibility;
    return this;
  }

  public List<BankingProductFee> getFees() {
    return fees;
  }

  public void setFees(List<BankingProductFee> fees) {
    this.fees = fees;
  }

  public BankingProductDetail fees(List<BankingProductFee> fees) {
    this.fees = fees;
    return this;
  }

  public List<BankingProductDepositRate> getDepositRates() {
    return depositRates;
  }

  public void setDepositRates(List<BankingProductDepositRate> depositRates) {
    this.depositRates = depositRates;
  }

  public BankingProductDetail depositRates(List<BankingProductDepositRate> depositRates) {
    this.depositRates = depositRates;
    return this;
  }

  public List<BankingProductLendingRate> getLendingRates() {
    return lendingRates;
  }

  public void setLendingRates(List<BankingProductLendingRate> lendingRates) {
    this.lendingRates = lendingRates;
  }

  public BankingProductDetail lendingRates(List<BankingProductLendingRate> lendingRates) {
    this.lendingRates = lendingRates;
    return this;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    BankingProductDetail inputModel = (BankingProductDetail) o;
    if (!(productId.equals(inputModel.getProductId()))) {
      return false;
    }
    if (!(effectiveFrom.equals(inputModel.getEffectiveFrom()))) {
      return false;
    }
    if (!(effectiveTo.equals(inputModel.getEffectiveTo()))) {
      return false;
    }
    if (!(lastUpdated.equals(inputModel.getLastUpdated()))) {
      return false;
    }
    if (!(productCategory.equals(inputModel.getProductCategory()))) {
      return false;
    }
    if (!(name.equals(inputModel.getName()))) {
      return false;
    }
    if (!(description.equals(inputModel.getDescription()))) {
      return false;
    }
    if (!(brand.equals(inputModel.getBrand()))) {
      return false;
    }
    if (!(brandName.equals(inputModel.getBrandName()))) {
      return false;
    }
    if (!(applicationUri.equals(inputModel.getApplicationUri()))) {
      return false;
    }
    if (!(isTailored.equals(inputModel.getIsTailored()))) {
      return false;
    }
    if (!(additionalInformation.equals(inputModel.getAdditionalInformation()))) {
      return false;
    }
    if (!(bundles.equals(inputModel.getBundles()))) {
      return false;
    }
    if (!(features.equals(inputModel.getFeatures()))) {
      return false;
    }
    if (!(constraints.equals(inputModel.getConstraints()))) {
      return false;
    }
    if (!(eligibility.equals(inputModel.getEligibility()))) {
      return false;
    }
    if (!(fees.equals(inputModel.getFees()))) {
      return false;
    }
    if (!(depositRates.equals(inputModel.getDepositRates()))) {
      return false;
    }
    if (!(lendingRates.equals(inputModel.getLendingRates()))) {
      return false;
    }
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        productId,
        effectiveFrom,
        effectiveTo,
        lastUpdated,
        productCategory,
        name,
        description,
        brand,
        brandName,
        applicationUri,
        isTailored,
        additionalInformation,
        bundles,
        features,
        constraints,
        eligibility,
        fees,
        depositRates,
        lendingRates);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append(String.format("class %s {\n", getClass()));
    sb.append("    productId: ").append(toIndentedString(productId)).append("\n");
    sb.append("    effectiveFrom: ").append(toIndentedString(effectiveFrom)).append("\n");
    sb.append("    effectiveTo: ").append(toIndentedString(effectiveTo)).append("\n");
    sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
    sb.append("    productCategory: ").append(toIndentedString(productCategory)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    brand: ").append(toIndentedString(brand)).append("\n");
    sb.append("    brandName: ").append(toIndentedString(brandName)).append("\n");
    sb.append("    applicationUri: ").append(toIndentedString(applicationUri)).append("\n");
    sb.append("    isTailored: ").append(toIndentedString(isTailored)).append("\n");
    sb.append("    additionalInformation: ")
        .append(toIndentedString(additionalInformation))
        .append("\n");
    sb.append("    bundles: ").append(toIndentedString(bundles)).append("\n");
    sb.append("    features: ").append(toIndentedString(features)).append("\n");
    sb.append("    constraints: ").append(toIndentedString(constraints)).append("\n");
    sb.append("    eligibility: ").append(toIndentedString(eligibility)).append("\n");
    sb.append("    fees: ").append(toIndentedString(fees)).append("\n");
    sb.append("    depositRates: ").append(toIndentedString(depositRates)).append("\n");
    sb.append("    lendingRates: ").append(toIndentedString(lendingRates)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
