/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.tool;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.jini.url.httpmd.Handler;
import net.jini.url.httpmd.HttpmdUtil;

public class ComputeHttpmdCodebase {
    private static ResourceBundle resources;
    private static boolean resinit;

    private ComputeHttpmdCodebase() {
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            ComputeHttpmdCodebase.print("computecodebase.usage", (String)null);
            System.exit(1);
        }
        Handler handler = new Handler();
        StringBuffer codebase = new StringBuffer();
        try {
            boolean isURL;
            URL base;
            try {
                base = new URL(args[0].endsWith("/") ? args[0] : args[0] + "/");
                isURL = true;
            }
            catch (MalformedURLException e) {
                File sourceDirectory = new File(args[0]);
                if (!sourceDirectory.isDirectory()) {
                    ComputeHttpmdCodebase.print("computecodebase.notdir", args[0]);
                    System.exit(1);
                }
                base = sourceDirectory.toURI().toURL();
                isURL = false;
            }
            for (int i = 1; i < args.length; ++i) {
                String digest;
                URL url;
                String spec = args[i];
                if (!"httpmd:".regionMatches(true, 0, spec, 0, 7)) {
                    ComputeHttpmdCodebase.print("computecodebase.nonhttpmd", spec);
                    System.exit(1);
                }
                try {
                    url = new URL(null, spec, (URLStreamHandler)handler);
                }
                catch (MalformedURLException e) {
                    ComputeHttpmdCodebase.print("computecodebase.badurl", new String[]{spec, e.getLocalizedMessage()});
                    System.exit(1);
                    return;
                }
                String path = url.getPath();
                int paramIndex = path.lastIndexOf(59);
                int equalsIndex = path.indexOf(61, paramIndex);
                int commentIndex = path.indexOf(44, equalsIndex);
                String algorithm = path.substring(paramIndex + 1, equalsIndex);
                URL source = new URL(base, path.substring(path.startsWith("/") ? 1 : 0, path.indexOf(59)));
                try {
                    digest = HttpmdUtil.computeDigest((URL)source, (String)algorithm);
                }
                catch (FileNotFoundException e) {
                    ComputeHttpmdCodebase.print("computecodebase.notfound", isURL ? source.toExternalForm() : source.getPath());
                    System.exit(1);
                    return;
                }
                URL result = new URL(url, path.substring(0, equalsIndex + 1) + digest + (commentIndex < 0 ? "" : path.substring(commentIndex)) + (url.getQuery() == null ? "" : '?' + url.getQuery()) + (url.getRef() == null ? "" : '#' + url.getRef()));
                if (codebase.length() > 0) {
                    codebase.append(' ');
                }
                codebase.append(result);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
        System.out.println(codebase);
    }

    private static synchronized String getString(String key) {
        try {
            if (!resinit) {
                resources = ResourceBundle.getBundle("org.apache.river.tool.resources.computecodebase");
                resinit = true;
            }
            return resources.getString(key);
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
            System.err.println("Unable to find a required resource.");
            System.exit(1);
            return null;
        }
    }

    private static void print(String key, String val) {
        ComputeHttpmdCodebase.print(key, new String[]{val});
    }

    private static void print(String key, String[] vals) {
        String fmt = ComputeHttpmdCodebase.getString(key);
        if (fmt == null) {
            fmt = "no text found: \"" + key + "\" {0}";
        }
        System.err.println(MessageFormat.format(fmt, vals));
    }

    static {
        resinit = false;
    }
}

