/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.mercury;

import java.io.File;
import org.apache.river.mercury.StreamType;

class StreamKey {
    private final File file;
    private final StreamType type;
    private final int hash;

    StreamKey(File file, StreamType type) {
        if (file == null || type == null) {
            throw new IllegalArgumentException("Cannot use <null> for path or type arguments.");
        }
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("Cannot use a relative path for the <file> argument");
        }
        this.file = file;
        this.type = type;
        this.hash = file.hashCode();
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        StreamKey sk = (StreamKey)o;
        return this.type == sk.type && this.file.equals(sk.file);
    }
}

