/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.mercury;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Condition;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.id.Uuid;
import net.jini.io.MarshalledInstance;
import net.jini.security.ProxyPreparer;
import org.apache.river.api.io.AtomicSerial;
import org.apache.river.api.io.Valid;
import org.apache.river.landlord.AbstractLeasedResource;
import org.apache.river.mercury.EventID;
import org.apache.river.mercury.EventLogIterator;

@AtomicSerial
class ServiceRegistration
extends AbstractLeasedResource
implements Comparable,
Serializable {
    private static final long serialVersionUID = 2L;
    private final Uuid cookie;
    private volatile long expiration = 0L;
    private transient RemoteEventListener preparedEventTarget = null;
    private MarshalledObject marshalledEventTarget;
    private transient EventLogIterator eventIterator;
    private final Map<EventID, UnknownEventException> unknownEvents;
    private Uuid remoteEventIteratorID;
    private volatile transient Condition iteratorCondition;

    public ServiceRegistration(AtomicSerial.GetArg arg) throws IOException, ClassNotFoundException {
        this((Uuid)arg.get("cookie", null, Uuid.class), (EventLogIterator)arg.get("eventIterator", null, EventLogIterator.class), (Condition)arg.get("iteratorCondition", null, Condition.class), Valid.copyMap((Map)((Map)arg.get("unknownEvents", null, Map.class)), new ConcurrentHashMap(), EventID.class, UnknownEventException.class), (MarshalledObject)arg.get("marshalledEventType", null, MarshalledObject.class));
    }

    public ServiceRegistration(Uuid cookie, EventLogIterator eventIterator, Condition iteratorCondition) {
        this(cookie, eventIterator, iteratorCondition, new ConcurrentHashMap<EventID, UnknownEventException>(), null);
    }

    private ServiceRegistration(Uuid cookie, EventLogIterator eventIterator, Condition iteratorCondition, Map<EventID, UnknownEventException> unknownEvents, MarshalledObject marshalledEventTarget) {
        this.marshalledEventTarget = marshalledEventTarget;
        this.unknownEvents = unknownEvents;
        this.cookie = cookie;
        this.eventIterator = eventIterator;
        this.iteratorCondition = iteratorCondition;
    }

    public void setExpiration(long newExpiration) {
        this.expiration = newExpiration;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public Uuid getCookie() {
        return this.cookie;
    }

    void setCondition(Condition iteratorCondition) {
        this.iteratorCondition = iteratorCondition;
    }

    public Condition getIteratorCondition() {
        return this.iteratorCondition;
    }

    public Map getUnknownEvents() {
        return this.unknownEvents;
    }

    public synchronized RemoteEventListener getEventTarget() {
        return this.preparedEventTarget;
    }

    public synchronized void setEventTarget(RemoteEventListener preparedTarget) throws IOException {
        if (preparedTarget == null) {
            this.preparedEventTarget = null;
            this.marshalledEventTarget = null;
        } else {
            this.preparedEventTarget = preparedTarget;
            this.marshalledEventTarget = new MarshalledInstance((Object)preparedTarget).convertToMarshalledObject();
        }
    }

    public synchronized Uuid getRemoteEventIteratorID() {
        return this.remoteEventIteratorID;
    }

    public synchronized void setRemoteEventIteratorID(Uuid id) {
        this.remoteEventIteratorID = id;
    }

    public synchronized boolean hasEventTarget() {
        return this.marshalledEventTarget != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreTransientState(ProxyPreparer targetPreparer) throws IOException, ClassNotFoundException {
        if (targetPreparer == null) {
            throw new NullPointerException("targetPreparer cannot be null");
        }
        ServiceRegistration serviceRegistration = this;
        synchronized (serviceRegistration) {
            if (this.marshalledEventTarget != null) {
                RemoteEventListener unprepared = (RemoteEventListener)new MarshalledInstance(this.marshalledEventTarget).get(false);
                this.preparedEventTarget = (RemoteEventListener)targetPreparer.prepareProxy((Object)unprepared);
            }
        }
    }

    public synchronized EventLogIterator iterator() {
        return this.eventIterator;
    }

    public synchronized void setIterator(EventLogIterator iter) {
        this.eventIterator = iter;
    }

    public synchronized int compareTo(Object obj) {
        ServiceRegistration reg = (ServiceRegistration)obj;
        if (this == reg) {
            return 0;
        }
        if (this.expiration < reg.expiration || this.expiration == reg.expiration && this.cookie.getMostSignificantBits() < reg.cookie.getMostSignificantBits() && this.cookie.getLeastSignificantBits() < reg.cookie.getLeastSignificantBits()) {
            return -1;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.cookie);
        ServiceRegistration serviceRegistration = this;
        synchronized (serviceRegistration) {
            hash = 97 * hash + (int)(this.expiration ^ this.expiration >>> 32);
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceRegistration)) {
            return false;
        }
        ServiceRegistration that = (ServiceRegistration)o;
        if (!this.cookie.equals((Object)that.cookie)) {
            return false;
        }
        return this.expiration == that.expiration;
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.cookie.toString();
    }

    synchronized void dumpInfo(Logger logger) {
        logger.log(Level.FINEST, "{0}", this.toString());
        logger.log(Level.FINEST, "Expires at: {0}", new Date(this.expiration));
        logger.log(Level.FINEST, "Prepared target is: {0}", this.preparedEventTarget);
        logger.log(Level.FINEST, "Marshalled target is: {0}", this.marshalledEventTarget);
        logger.log(Level.FINEST, "Unknowns: {0}", this.unknownEvents.size());
        if (this.eventIterator != null) {
            try {
                logger.log(Level.FINEST, "hasNext: {0}", this.eventIterator.hasNext());
            }
            catch (IOException ioe) {
                logger.log(Level.FINEST, "hasNext exception.", ioe);
            }
        }
    }
}

