/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.mercury;

import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.security.auth.login.LoginContext;
import net.jini.activation.ActivationExporter;
import net.jini.activation.ActivationGroup;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.discovery.DiscoveryManagement;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import net.jini.jeri.AtomicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import org.apache.river.config.Config;
import org.apache.river.landlord.FixedLeasePeriodPolicy;
import org.apache.river.landlord.LeasePeriodPolicy;
import org.apache.river.mercury.EventLogFactory;
import org.apache.river.mercury.MailboxImpl;
import org.apache.river.mercury.ServiceRegistration;
import org.apache.river.mercury.proxy.MailboxBackEnd;

class MailboxImplInit {
    ActivationID activationID;
    ActivationSystem activationSystem;
    boolean activationPrepared;
    Exporter exporter;
    ProxyPreparer listenerPreparer;
    ProxyPreparer recoveredListenerPreparer;
    ProxyPreparer locatorToJoinPreparer;
    LeasePeriodPolicy leasePolicy;
    String persistenceDirectory;
    ProxyPreparer recoveredLocatorToJoinPreparer;
    int logToSnapshotThreshold;
    Uuid serviceID;
    String[] lookupGroups;
    LookupLocator[] lookupLocators;
    Entry[] lookupAttrs;
    long maxUnexportDelay;
    long unexportRetryDelay;
    DiscoveryManagement lookupDiscMgr;
    TreeMap<ServiceRegistration, ServiceRegistration> regByExpiration = new TreeMap();
    HashMap<Uuid, ServiceRegistration> regByID = new HashMap();
    Map<Uuid, MailboxImpl.NotifyTask> activeReg = new HashMap<Uuid, MailboxImpl.NotifyTask>();
    EventLogFactory eventLogFactory = new EventLogFactory();
    List<Uuid> pendingReg = new ArrayList<Uuid>();
    Configuration config;
    AccessControlContext context;
    LoginContext loginContext;
    String codebase;
    String certFactoryType;
    String certPathEncoding;
    byte[] encodedCerts;

    MailboxImplInit(Configuration config, boolean persistent, ActivationID activationID, Entry[] baseLookupAttrs) throws ConfigurationException, RemoteException, ActivationException {
        this.config = config;
        this.context = AccessController.getContext();
        if (activationID != null) {
            ProxyPreparer activationSystemPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)"org.apache.river.mercury", (String)"activationSystemPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
            if (MailboxImpl.INIT_LOGGER.isLoggable(Level.CONFIG)) {
                MailboxImpl.INIT_LOGGER.log(Level.CONFIG, "activationSystemPreparer: {0}", activationSystemPreparer);
            }
            this.activationSystem = (ActivationSystem)activationSystemPreparer.prepareProxy((Object)ActivationGroup.getSystem());
            if (MailboxImpl.INIT_LOGGER.isLoggable(Level.FINEST)) {
                MailboxImpl.INIT_LOGGER.log(Level.FINEST, "Prepared activation system is: {0}", this.activationSystem);
            }
            ProxyPreparer activationIdPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)"org.apache.river.mercury", (String)"activationIdPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
            if (MailboxImpl.INIT_LOGGER.isLoggable(Level.CONFIG)) {
                MailboxImpl.INIT_LOGGER.log(Level.CONFIG, "activationIdPreparer: {0}", activationIdPreparer);
            }
            activationID = (ActivationID)activationIdPreparer.prepareProxy((Object)activationID);
            if (MailboxImpl.INIT_LOGGER.isLoggable(Level.FINEST)) {
                MailboxImpl.INIT_LOGGER.log(Level.FINEST, "Prepared activationID is: {0}", activationID);
            }
            this.activationPrepared = true;
            this.exporter = (Exporter)Config.getNonNullEntry((Configuration)config, (String)"org.apache.river.mercury", (String)"serverExporter", Exporter.class, (Object)new ActivationExporter(activationID, (Exporter)new BasicJeriExporter((ServerEndpoint)TcpServerEndpoint.getInstance((int)0), (InvocationLayerFactory)new AtomicILFactory(null, null, MailboxBackEnd.class.getClassLoader()), false, true)), (Object)activationID);
            if (MailboxImpl.INIT_LOGGER.isLoggable(Level.CONFIG)) {
                MailboxImpl.INIT_LOGGER.log(Level.CONFIG, "Activatable service exporter is: {0}", this.exporter);
            }
            this.activationID = activationID;
        } else {
            this.exporter = (Exporter)Config.getNonNullEntry((Configuration)config, (String)"org.apache.river.mercury", (String)"serverExporter", Exporter.class, (Object)new BasicJeriExporter((ServerEndpoint)TcpServerEndpoint.getInstance((int)0), (InvocationLayerFactory)new AtomicILFactory(null, null, MailboxBackEnd.class.getClassLoader()), false, true));
            if (MailboxImpl.INIT_LOGGER.isLoggable(Level.CONFIG)) {
                MailboxImpl.INIT_LOGGER.log(Level.CONFIG, "Non-activatable service exporter is: {0}", this.exporter);
            }
        }
        this.codebase = (String)Config.getNonNullEntry((Configuration)config, (String)"org.apache.river.mercury", (String)"Codebase_Annotation", String.class, (Object)"");
        this.certFactoryType = (String)Config.getNonNullEntry((Configuration)config, (String)"org.apache.river.mercury", (String)"Codebase_CertFactoryType", String.class, (Object)"X.509");
        this.certPathEncoding = (String)Config.getNonNullEntry((Configuration)config, (String)"org.apache.river.mercury", (String)"Codebase_CertPathEncoding", String.class, (Object)"PkiPath");
        this.encodedCerts = (byte[])Config.getNonNullEntry((Configuration)config, (String)"org.apache.river.mercury", (String)"Codebase_Certs", byte[].class, (Object)new byte[0]);
        this.listenerPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)"org.apache.river.mercury", (String)"listenerPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
        if (MailboxImpl.INIT_LOGGER.isLoggable(Level.CONFIG)) {
            MailboxImpl.INIT_LOGGER.log(Level.CONFIG, "Listener preparer is: {0}", this.listenerPreparer);
        }
        this.locatorToJoinPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)"org.apache.river.mercury", (String)"locatorToJoinPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
        if (MailboxImpl.INIT_LOGGER.isLoggable(Level.CONFIG)) {
            MailboxImpl.INIT_LOGGER.log(Level.CONFIG, "Locator preparer is: {0}", this.locatorToJoinPreparer);
        }
        this.leasePolicy = (LeasePeriodPolicy)Config.getNonNullEntry((Configuration)config, (String)"org.apache.river.mercury", (String)"leasePeriodPolicy", LeasePeriodPolicy.class, (Object)new FixedLeasePeriodPolicy(10800000L, 3600000L));
        if (MailboxImpl.INIT_LOGGER.isLoggable(Level.CONFIG)) {
            MailboxImpl.INIT_LOGGER.log(Level.CONFIG, "LeasePeriodPolicy is: {0}", this.leasePolicy);
        }
        if (persistent) {
            this.persistenceDirectory = (String)Config.getNonNullEntry((Configuration)config, (String)"org.apache.river.mercury", (String)"persistenceDirectory", String.class);
            if (MailboxImpl.INIT_LOGGER.isLoggable(Level.CONFIG)) {
                MailboxImpl.INIT_LOGGER.log(Level.CONFIG, "Persistence directory is: {0}", this.persistenceDirectory);
            }
            this.recoveredListenerPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)"org.apache.river.mercury", (String)"recoveredListenerPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
            if (MailboxImpl.INIT_LOGGER.isLoggable(Level.CONFIG)) {
                MailboxImpl.INIT_LOGGER.log(Level.CONFIG, "Recovered listener preparer is: {0}", this.recoveredListenerPreparer);
            }
            this.recoveredLocatorToJoinPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)"org.apache.river.mercury", (String)"recoveredLocatorToJoinPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
            if (MailboxImpl.INIT_LOGGER.isLoggable(Level.CONFIG)) {
                MailboxImpl.INIT_LOGGER.log(Level.CONFIG, "Recovered locator preparer is: {0}", this.recoveredLocatorToJoinPreparer);
            }
            this.logToSnapshotThreshold = Config.getIntEntry((Configuration)config, (String)"org.apache.river.mercury", (String)"logToSnapshotThreshold", (int)50, (int)0, (int)Integer.MAX_VALUE);
        }
        this.maxUnexportDelay = Config.getLongEntry((Configuration)config, (String)"org.apache.river.mercury", (String)"maxUnexportDelay", (long)120000L, (long)0L, (long)Long.MAX_VALUE);
        this.unexportRetryDelay = Config.getLongEntry((Configuration)config, (String)"org.apache.river.mercury", (String)"unexportRetryDelay", (long)1000L, (long)1L, (long)Long.MAX_VALUE);
    }
}

