/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.mercury;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.NoSuchEntryException;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.event.InvalidIteratorException;
import net.jini.event.MailboxPullRegistration;
import net.jini.event.MailboxRegistration;
import net.jini.export.CodebaseAccessor;
import net.jini.export.Exporter;
import net.jini.export.ProxyAccessor;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.io.MarshalledInstance;
import net.jini.lookup.JoinManager;
import net.jini.lookup.ServiceAttributesAccessor;
import net.jini.lookup.ServiceIDAccessor;
import net.jini.lookup.ServiceProxyAccessor;
import net.jini.lookup.entry.ServiceInfo;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;
import org.apache.river.api.util.Startable;
import org.apache.river.config.Config;
import org.apache.river.constants.ThrowableConstants;
import org.apache.river.constants.TimeConstants;
import org.apache.river.landlord.Landlord;
import org.apache.river.landlord.LandlordLease;
import org.apache.river.landlord.LandlordUtil;
import org.apache.river.landlord.LeaseFactory;
import org.apache.river.landlord.LeasePeriodPolicy;
import org.apache.river.landlord.LeasedResource;
import org.apache.river.landlord.LocalLandlord;
import org.apache.river.logging.Levels;
import org.apache.river.lookup.entry.BasicServiceType;
import org.apache.river.lookup.entry.LookupAttributes;
import org.apache.river.mercury.EventID;
import org.apache.river.mercury.EventLogFactory;
import org.apache.river.mercury.EventLogIterator;
import org.apache.river.mercury.MailboxImplInit;
import org.apache.river.mercury.ServiceRegistration;
import org.apache.river.mercury.proxy.InternalMailboxException;
import org.apache.river.mercury.proxy.ListenerProxy;
import org.apache.river.mercury.proxy.MailboxAdminProxy;
import org.apache.river.mercury.proxy.MailboxBackEnd;
import org.apache.river.mercury.proxy.MailboxProxy;
import org.apache.river.mercury.proxy.ProxyVerifier;
import org.apache.river.mercury.proxy.Registration;
import org.apache.river.mercury.proxy.RemoteEventData;
import org.apache.river.mercury.proxy.RemoteEventIteratorData;
import org.apache.river.proxy.CodebaseProvider;
import org.apache.river.proxy.ThrowThis;
import org.apache.river.reliableLog.LogException;
import org.apache.river.reliableLog.LogHandler;
import org.apache.river.reliableLog.ReliableLog;
import org.apache.river.start.lifecycle.LifeCycle;
import org.apache.river.thread.InterruptedStatusThread;
import org.apache.river.thread.NamedThreadFactory;
import org.apache.river.thread.ReadersWriter;
import org.apache.river.thread.ReadyState;
import org.apache.river.thread.wakeup.RetryTask;
import org.apache.river.thread.wakeup.WakeupManager;

public class MailboxImpl
implements MailboxBackEnd,
TimeConstants,
ServerProxyTrust,
ProxyAccessor,
Startable,
CodebaseAccessor,
ServiceProxyAccessor,
ServiceAttributesAccessor,
ServiceIDAccessor {
    static final String MERCURY = "org.apache.river.mercury";
    static final Logger LEASE_LOGGER = Logger.getLogger("org.apache.river.mercury.lease");
    static final Logger DELIVERY_LOGGER = Logger.getLogger("org.apache.river.mercury.delivery");
    static final Logger ADMIN_LOGGER = Logger.getLogger("org.apache.river.mercury.admin");
    static final Logger INIT_LOGGER = Logger.getLogger("org.apache.river.mercury.init");
    static final Logger RECEIVE_LOGGER = Logger.getLogger("org.apache.river.mercury.receive");
    static final Logger EXPIRATION_LOGGER = Logger.getLogger("org.apache.river.mercury.expiration");
    static final Logger RECOVERY_LOGGER = Logger.getLogger("org.apache.river.mercury.recovery");
    static final Logger PERSISTENCE_LOGGER = Logger.getLogger("org.apache.river.mercury.persistence");
    static final Logger STARTUP_LOGGER = Logger.getLogger("org.apache.river.mercury.startup");
    static final Logger OPERATIONS_LOGGER = Logger.getLogger("org.apache.river.mercury.operations");
    static final String MAILBOX_SOURCE_CLASS = MailboxImpl.class.getName();
    private static final String NOTIFIER_SOURCE_CLASS = Notifier.class.getName();
    private static final String NOTIFY_TASK_SOURCE_CLASS = NotifyTask.class.getName();
    private static final String DESTROY_THREAD_SOURCE_CLASS = DestroyThread.class.getName();
    private static final String EXPIRATION_THREAD_SOURCE_CLASS = ExpirationThread.class.getName();
    private static final String REGISTRATION_LOG_OBJ_SOURCE_CLASS = RegistrationLogObj.class.getName();
    private static final String REGISTRATION_ENABLED_LOG_OBJ_SOURCE_CLASS = RegistrationEnabledLogObj.class.getName();
    private static final String REGISTRATION_DISABLED_LOG_OBJ_SOURCE_CLASS = RegistrationDisabledLogObj.class.getName();
    private static final String REGISTRATION_ITERATOR_ENABLED_LOG_OBJ_SOURCE_CLASS = RegistrationIteratorEnabledLogObj.class.getName();
    private static final String LOOKUP_GROUPS_CHANGED_LOG_OBJ_SOURCE_CLASS = LookupGroupsChangedLogObj.class.getName();
    private static final String LOOKUP_LOCATORS_CHANGED_LOG_OBJ_SOURCE_CLASS = LookupLocatorsChangedLogObj.class.getName();
    private static final String ATTRS_ADDED_LOG_OBJ_SOURCE_CLASS = AttrsAddedLogObj.class.getName();
    private static final String ATTRS_MODIFIED_LOG_OBJ_SOURCE_CLASS = AttrsModifiedLogObj.class.getName();
    private static final String REGISTRATION_RENEWED_LOG_OBJ_SOURCE_CLASS = RegistrationRenewedLogObj.class.getName();
    private static final String REGISTRATION_CANCELLED_LOG_OBJ_SOURCE_CLASS = RegistrationCancelledLogObj.class.getName();
    private static final String UNKNOWN_EVENT_EXCEPTION_LOG_OBJ_SOURCE_CLASS = UnknownEventExceptionLogObj.class.getName();
    private static final String SNAPSHOT_THREAD_SOURCE_CLASS = SnapshotThread.class.getName();
    private static final String PRODUCT = "EventMailbox";
    private static final String MANUFACTURER = "Sun Microsystems, Inc.";
    private static final String VENDOR = "Sun Microsystems, Inc.";
    private static final String VERSION = "3.1.0";
    private static final int LOG_VERSION = 2;
    private static final Entry[] BASE_LOOKUP_ATTRS = new Entry[]{new ServiceInfo("EventMailbox", "Sun Microsystems, Inc.", "Sun Microsystems, Inc.", "3.1.0", "", ""), new BasicServiceType("Event Mailbox")};
    private volatile MailboxBackEnd serverStub;
    private volatile MailboxProxy mailboxProxy;
    private volatile MailboxAdminProxy mailboxAdminProxy;
    private final ReadersWriter concurrentObj = new ReadersWriter();
    private final Map<Uuid, ServiceRegistration> regByID;
    private final TreeMap<ServiceRegistration, ServiceRegistration> regByExpiration;
    private final List<Uuid> pendingReg;
    private final Map<Uuid, NotifyTask> activeReg;
    private final ReliableLog log;
    private volatile boolean inRecovery;
    private int logFileSize = 0;
    private int logToSnapshotThreshold = 50;
    private final Object snapshotNotifier = new Object();
    private final Thread snapshotter;
    protected final LoginContext loginContext;
    private final String persistenceDirectory;
    private final ProxyPreparer listenerPreparer;
    private ProxyPreparer recoveredListenerPreparer;
    protected final Exporter exporter;
    private volatile Uuid serviceID;
    private final ActivationID activationID;
    private final boolean activationPrepared;
    private final ActivationSystem activationSystem;
    private final EventLogFactory eventLogFactory;
    private final LeasePeriodPolicy leasePolicy;
    private volatile LeaseFactory leaseFactory;
    private final LocalLandlordAdaptor localLandlord = new LocalLandlordAdaptor();
    private JoinManager joiner = null;
    private DiscoveryManagement lookupDiscMgr = null;
    private Entry[] lookupAttrs = new Entry[0];
    private String[] lookupGroups = LookupDiscovery.NO_GROUPS;
    private LookupLocator[] lookupLocators = new LookupLocator[0];
    private static ProxyPreparer locatorToJoinPreparer;
    private static ProxyPreparer recoveredLocatorToJoinPreparer;
    private final Thread notifier;
    private final Object eventNotifier = new Object();
    private final Thread expirer;
    private long minRegExpiration = Long.MAX_VALUE;
    private final Object expirationNotifier = new Object();
    private final Object destroyLock = new Object();
    private volatile boolean destroySucceeded = false;
    private final long maxUnexportDelay;
    private final long unexportRetryDelay;
    private final ReadyState readyState = new ReadyState();
    private volatile LifeCycle lifeCycle;
    private final boolean persistent;
    private Configuration config;
    private Throwable thrown;
    private boolean started = false;
    private final AccessControlContext context;
    private String codebase;
    private String certFactoryType;
    private String certPathEncoding;
    private byte[] encodedCerts;
    private static final long MAX_TIME = 3600000L;
    private static final int MAX_ATTEMPTS = 5;

    public Object getProxy() {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "getProxy");
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "getProxy", this.serverStub);
        }
        return this.serverStub;
    }

    public Object getServiceProxy() {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "getServiceProxy");
        }
        this.readyState.check();
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "getServiceProxy", this.mailboxProxy);
        }
        return this.mailboxProxy;
    }

    public Object getAdmin() throws RemoteException {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "getAdmin");
        }
        this.readyState.check();
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "getAdmin", this.mailboxAdminProxy);
        }
        return this.mailboxAdminProxy;
    }

    MailboxImpl(ActivationID activationID, MarshalledObject data) throws Exception {
        this((String[])new MarshalledInstance(data).get(false), activationID, true, new Object[]{activationID, data});
    }

    MailboxImpl(String[] configArgs, LifeCycle lc, boolean persistent) throws Exception {
        this(configArgs, null, persistent, new Object[]{Arrays.asList(configArgs), lc, persistent});
        this.lifeCycle = lc;
    }

    private static Configuration config(String[] configArgs) throws ConfigurationException {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "init", configArgs);
        }
        Configuration config = ConfigurationProvider.getInstance((String[])configArgs, (ClassLoader)MailboxImpl.class.getClassLoader());
        return config;
    }

    private static LoginContext loginContext(Configuration config) throws ConfigurationException {
        return (LoginContext)config.getEntry(MERCURY, "loginContext", LoginContext.class, null);
    }

    private static MailboxImplInit init(final Configuration config, LoginContext loginContext, final ActivationID activID, final boolean persistant, Object[] logMessage) throws ConfigurationException, LoginException, RemoteException, ActivationException, IOException, Exception {
        MailboxImplInit init = null;
        if (loginContext != null) {
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "doInitWithLogin", new Object[]{config, loginContext});
            }
            loginContext.login();
            try {
                init = Subject.doAsPrivileged(loginContext.getSubject(), new PrivilegedExceptionAction<MailboxImplInit>(){

                    @Override
                    public MailboxImplInit run() throws ConfigurationException, RemoteException, ActivationException, IOException {
                        return new MailboxImplInit(config, persistant, activID, BASE_LOOKUP_ATTRS);
                    }
                }, null);
            }
            catch (PrivilegedActionException e) {
                block9: {
                    try {
                        loginContext.logout();
                    }
                    catch (LoginException le) {
                        if (!INIT_LOGGER.isLoggable(Levels.HANDLED)) break block9;
                        INIT_LOGGER.log(Levels.HANDLED, "Trouble logging out", le);
                    }
                }
                throw e.getException();
            }
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "doInitWithLogin");
            }
        } else {
            init = new MailboxImplInit(config, persistant, activID, BASE_LOOKUP_ATTRS);
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "init");
        }
        return init;
    }

    private MailboxImpl(Configuration config, ActivationID activID, boolean persistant, Object[] logMessage) throws LoginException, ActivationException, IOException, RemoteException, Exception {
        this(MailboxImpl.init(config, MailboxImpl.loginContext(config), activID, persistant, logMessage), activID, persistant, logMessage);
    }

    private MailboxImpl(MailboxImplInit init, ActivationID activID, final boolean persistent, final Object[] logMessage) {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MailboxImpl.class.getName(), "MailboxImpl", logMessage);
        }
        this.persistent = persistent;
        this.activationID = init.activationID;
        this.activationSystem = init.activationSystem;
        this.activationPrepared = init.activationPrepared;
        this.exporter = init.exporter;
        this.listenerPreparer = init.listenerPreparer;
        this.recoveredListenerPreparer = init.recoveredListenerPreparer;
        locatorToJoinPreparer = init.locatorToJoinPreparer;
        this.leasePolicy = init.leasePolicy;
        this.persistenceDirectory = init.persistenceDirectory;
        recoveredLocatorToJoinPreparer = init.recoveredLocatorToJoinPreparer;
        this.logToSnapshotThreshold = init.logToSnapshotThreshold;
        this.serviceID = init.serviceID;
        this.lookupGroups = init.lookupGroups;
        this.lookupLocators = init.lookupLocators;
        this.lookupAttrs = init.lookupAttrs;
        this.maxUnexportDelay = init.maxUnexportDelay;
        this.unexportRetryDelay = init.unexportRetryDelay;
        this.lookupDiscMgr = init.lookupDiscMgr;
        this.regByExpiration = init.regByExpiration;
        this.regByID = init.regByID;
        this.activeReg = init.activeReg;
        this.eventLogFactory = init.eventLogFactory;
        this.pendingReg = init.pendingReg;
        this.config = init.config;
        this.loginContext = init.loginContext;
        this.context = init.context;
        this.codebase = init.codebase;
        this.certFactoryType = init.certFactoryType;
        this.certPathEncoding = init.certPathEncoding;
        this.encodedCerts = (byte[])init.encodedCerts.clone();
        Thread snapShotter = null;
        Thread notifieR = null;
        Thread expireR = null;
        ReliableLog loG = null;
        try {
            Object[] result = AccessController.doPrivileged(new PrivilegedExceptionAction<Object[]>(){

                @Override
                public Object[] run() throws Exception {
                    Object[] res = new Object[4];
                    res[0] = persistent ? new SnapshotThread() : null;
                    res[1] = new Notifier(MailboxImpl.this.config);
                    res[2] = new ExpirationThread();
                    if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                        OPERATIONS_LOGGER.entering(MailboxImpl.class.getName(), "MailboxImpl", logMessage);
                    }
                    res[3] = persistent ? new ReliableLog(MailboxImpl.this.persistenceDirectory, (LogHandler)new LocalLogHandler()) : null;
                    return res;
                }
            }, this.context);
            snapShotter = (Thread)result[0];
            notifieR = (Thread)result[1];
            expireR = (Thread)result[2];
            loG = (ReliableLog)result[3];
            this.thrown = null;
        }
        catch (PrivilegedActionException ex) {
            this.thrown = ex.getException();
        }
        this.log = loG;
        this.snapshotter = snapShotter;
        this.notifier = notifieR;
        this.expirer = expireR;
    }

    private MailboxImpl(String[] configArgs, ActivationID activID, boolean persistant, Object[] logMessage) throws ConfigurationException, ActivationException, IOException, RemoteException, Exception {
        this(MailboxImpl.config(configArgs), activID, persistant, logMessage);
    }

    public void start() throws Exception {
        this.concurrentObj.writeLock();
        if (this.started) {
            return;
        }
        this.started = true;
        try {
            if (this.thrown != null) {
                throw this.thrown;
            }
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws Exception {
                    if (MailboxImpl.this.persistent) {
                        if (INIT_LOGGER.isLoggable(Level.FINEST)) {
                            INIT_LOGGER.log(Level.FINEST, "Recovering persistent state");
                        }
                        MailboxImpl.this.log.recover(MailboxImpl.class.getClassLoader());
                    }
                    if (MailboxImpl.this.serviceID == null) {
                        if (INIT_LOGGER.isLoggable(Level.FINEST)) {
                            INIT_LOGGER.log(Level.FINEST, "Getting initial values.");
                        }
                        MailboxImpl.this.serviceID = UuidFactory.generate();
                        if (INIT_LOGGER.isLoggable(Level.FINEST)) {
                            INIT_LOGGER.log(Level.FINEST, "ServiceID: {0}", MailboxImpl.this.serviceID);
                        }
                        MailboxImpl.access$702(MailboxImpl.this, (String[])MailboxImpl.this.config.getEntry(MailboxImpl.MERCURY, "initialLookupGroups", String[].class, (Object)new String[]{""}));
                        if (INIT_LOGGER.isLoggable(Level.CONFIG)) {
                            INIT_LOGGER.log(Level.CONFIG, "Initial groups:");
                            MailboxImpl.dumpGroups(MailboxImpl.this.lookupGroups, INIT_LOGGER, Level.CONFIG);
                        }
                        MailboxImpl.access$802(MailboxImpl.this, (LookupLocator[])Config.getNonNullEntry((Configuration)MailboxImpl.this.config, (String)MailboxImpl.MERCURY, (String)"initialLookupLocators", LookupLocator[].class, (Object)new LookupLocator[0]));
                        if (INIT_LOGGER.isLoggable(Level.CONFIG)) {
                            INIT_LOGGER.log(Level.CONFIG, "Initial locators:");
                            MailboxImpl.dumpLocators(MailboxImpl.this.lookupLocators, INIT_LOGGER, Level.CONFIG);
                        }
                        Entry[] initialAttrs = (Entry[])Config.getNonNullEntry((Configuration)MailboxImpl.this.config, (String)MailboxImpl.MERCURY, (String)"initialLookupAttributes", Entry[].class, (Object)new Entry[0]);
                        if (INIT_LOGGER.isLoggable(Level.CONFIG)) {
                            INIT_LOGGER.log(Level.CONFIG, "Initial lookup attributes:");
                            MailboxImpl.dumpAttrs(initialAttrs, INIT_LOGGER, Level.CONFIG);
                        }
                        if (initialAttrs.length == 0) {
                            MailboxImpl.access$902(MailboxImpl.this, BASE_LOOKUP_ATTRS);
                        } else {
                            MailboxImpl.access$902(MailboxImpl.this, new Entry[initialAttrs.length + BASE_LOOKUP_ATTRS.length]);
                            int i = 0;
                            int j = 0;
                            while (j < BASE_LOOKUP_ATTRS.length) {
                                ((MailboxImpl)MailboxImpl.this).lookupAttrs[i] = BASE_LOOKUP_ATTRS[j];
                                ++j;
                                ++i;
                            }
                            j = 0;
                            while (j < initialAttrs.length) {
                                ((MailboxImpl)MailboxImpl.this).lookupAttrs[i] = initialAttrs[j];
                                ++j;
                                ++i;
                            }
                        }
                        if (INIT_LOGGER.isLoggable(Level.FINEST)) {
                            INIT_LOGGER.log(Level.FINEST, "Combined lookup attributes:");
                            MailboxImpl.dumpAttrs(MailboxImpl.this.lookupAttrs, INIT_LOGGER, Level.FINEST);
                        }
                    } else {
                        if (INIT_LOGGER.isLoggable(Level.FINEST)) {
                            INIT_LOGGER.log(Level.FINEST, "Preparing recovered locators:");
                            MailboxImpl.dumpLocators(MailboxImpl.this.lookupLocators, INIT_LOGGER, Level.FINEST);
                        }
                        MailboxImpl.prepareExistingLocators(recoveredLocatorToJoinPreparer, MailboxImpl.this.lookupLocators);
                    }
                    if (MailboxImpl.this.persistent) {
                        if (INIT_LOGGER.isLoggable(Level.FINEST)) {
                            INIT_LOGGER.log(Level.FINEST, "Taking snapshot.");
                        }
                        MailboxImpl.this.log.snapshot();
                        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "RebuildTransientState", MailboxImpl.this.recoveredListenerPreparer);
                        }
                        if (!MailboxImpl.this.regByID.isEmpty()) {
                            if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                                RECOVERY_LOGGER.log(Level.FINEST, "Rebuilding transient state ...");
                            }
                            Collection regs = MailboxImpl.this.regByID.values();
                            Iterator iter = regs.iterator();
                            ServiceRegistration reg = null;
                            Uuid uuid = null;
                            EventLogIterator eli = null;
                            while (iter.hasNext()) {
                                reg = (ServiceRegistration)iter.next();
                                uuid = reg.getCookie();
                                if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                                    RECOVERY_LOGGER.log(Level.FINEST, "Checking reg : {0}", reg);
                                }
                                if (MailboxImpl.ensureCurrent((LeasedResource)reg)) {
                                    if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                                        RECOVERY_LOGGER.log(Level.FINEST, "Restoring reg transient state ...");
                                    }
                                    try {
                                        reg.setCondition(MailboxImpl.this.concurrentObj.newCondition());
                                        MailboxImpl.this.concurrentObj.writeUnlock();
                                        reg.restoreTransientState(MailboxImpl.this.recoveredListenerPreparer);
                                    }
                                    catch (Exception e) {
                                        if (RECOVERY_LOGGER.isLoggable(Levels.HANDLED)) {
                                            RECOVERY_LOGGER.log(Levels.HANDLED, "Trouble restoring reg transient state", e);
                                        }
                                        try {
                                            reg.setEventTarget(null);
                                        }
                                        catch (IOException ioe) {
                                            throw new AssertionError((Object)("Setting a null target threw an exception: " + ioe));
                                        }
                                    }
                                    finally {
                                        MailboxImpl.this.concurrentObj.writeLock();
                                    }
                                    if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                                        RECOVERY_LOGGER.log(Level.FINEST, "Reinitializing iterator ...");
                                    }
                                    eli = MailboxImpl.this.eventLogFactory.iterator(uuid, MailboxImpl.getEventLogPath(MailboxImpl.this.persistenceDirectory, uuid));
                                    reg.setIterator(eli);
                                    if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                                        RECOVERY_LOGGER.log(Level.FINEST, "Adding registration to expiration watch list");
                                    }
                                    MailboxImpl.this.regByExpiration.put(reg, reg);
                                    if (!reg.hasEventTarget() || MailboxImpl.this.pendingReg.contains(uuid)) continue;
                                    if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                                        RECOVERY_LOGGER.log(Level.FINEST, "Adding registration to pending task list");
                                    }
                                    MailboxImpl.this.pendingReg.add(uuid);
                                    continue;
                                }
                                if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                                    RECOVERY_LOGGER.log(Level.FINEST, "Removing expired registration: ");
                                }
                                iter.remove();
                                MailboxImpl.this.removeRegistration(uuid, reg, true);
                            }
                        }
                        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "rebuildTransientState");
                        }
                        MailboxImpl.this.snapshotter.start();
                    }
                    MailboxImpl.this.notifier.start();
                    MailboxImpl.this.expirer.start();
                    MailboxImpl.this.serverStub = (MailboxBackEnd)MailboxImpl.this.exporter.export((Remote)((Object)MailboxImpl.this));
                    if (INIT_LOGGER.isLoggable(Level.FINEST)) {
                        INIT_LOGGER.log(Level.FINEST, "Service stub is: {0}", MailboxImpl.this.serverStub);
                    }
                    MailboxImpl.this.mailboxProxy = MailboxProxy.create((MailboxBackEnd)MailboxImpl.this.serverStub, (Uuid)MailboxImpl.this.serviceID);
                    if (INIT_LOGGER.isLoggable(Level.FINEST)) {
                        INIT_LOGGER.log(Level.FINEST, "Service proxy is: {0}", MailboxImpl.this.mailboxProxy);
                    }
                    MailboxImpl.this.mailboxAdminProxy = MailboxAdminProxy.create((MailboxBackEnd)MailboxImpl.this.serverStub, (Uuid)MailboxImpl.this.serviceID);
                    if (INIT_LOGGER.isLoggable(Level.FINEST)) {
                        INIT_LOGGER.log(Level.FINEST, "Service admin proxy is: {0}", MailboxImpl.this.mailboxAdminProxy);
                    }
                    MailboxImpl.this.leaseFactory = new LeaseFactory((Landlord)MailboxImpl.this.serverStub, MailboxImpl.this.serviceID);
                    try {
                        MailboxImpl.this.lookupDiscMgr = (DiscoveryManagement)Config.getNonNullEntry((Configuration)MailboxImpl.this.config, (String)MailboxImpl.MERCURY, (String)"discoveryManager", DiscoveryManagement.class);
                        if (MailboxImpl.this.lookupDiscMgr instanceof DiscoveryGroupManagement) {
                            String[] groups = ((DiscoveryGroupManagement)MailboxImpl.this.lookupDiscMgr).getGroups();
                            if (groups == DiscoveryGroupManagement.ALL_GROUPS || groups.length != 0) {
                                throw new ConfigurationException("discoveryManager entry must be configured  with no groups.");
                            }
                        } else {
                            throw new ConfigurationException("discoveryManager entry must implement DiscoveryGroupManagement");
                        }
                        if (MailboxImpl.this.lookupDiscMgr instanceof DiscoveryLocatorManagement) {
                            LookupLocator[] locs = ((DiscoveryLocatorManagement)MailboxImpl.this.lookupDiscMgr).getLocators();
                            if (locs != null && locs.length != 0) {
                                throw new ConfigurationException("discoveryManager entry must be configured with no locators");
                            }
                        } else {
                            throw new ConfigurationException("discoveryManager entry must implement DiscoveryLocatorManagement");
                        }
                        ((DiscoveryGroupManagement)MailboxImpl.this.lookupDiscMgr).setGroups(MailboxImpl.this.lookupGroups);
                        ((DiscoveryLocatorManagement)MailboxImpl.this.lookupDiscMgr).setLocators(MailboxImpl.this.lookupLocators);
                    }
                    catch (NoSuchEntryException e) {
                        MailboxImpl.this.lookupDiscMgr = (DiscoveryManagement)new LookupDiscoveryManager(MailboxImpl.this.lookupGroups, MailboxImpl.this.lookupLocators, null, MailboxImpl.this.config);
                    }
                    if (INIT_LOGGER.isLoggable(Level.FINEST)) {
                        INIT_LOGGER.log(Level.FINEST, "Discovery manager is: {0}", MailboxImpl.this.lookupDiscMgr);
                    }
                    ServiceID lookupID = new ServiceID(MailboxImpl.this.serviceID.getMostSignificantBits(), MailboxImpl.this.serviceID.getLeastSignificantBits());
                    if (INIT_LOGGER.isLoggable(Level.FINEST)) {
                        INIT_LOGGER.log(Level.FINEST, "Creating JoinManager.");
                    }
                    MailboxImpl.this.joiner = new JoinManager((Object)MailboxImpl.this.mailboxProxy, MailboxImpl.this.lookupAttrs, lookupID, MailboxImpl.this.lookupDiscMgr, null, MailboxImpl.this.config);
                    if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                        OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "doInit");
                    }
                    MailboxImpl.this.readyState.ready();
                    if (STARTUP_LOGGER.isLoggable(Level.INFO)) {
                        STARTUP_LOGGER.log(Level.INFO, "Mercury started: {0}", this);
                    }
                    return null;
                }
            }, this.context);
        }
        catch (Throwable t) {
            this.cleanup();
            this.initFailed(t);
        }
        finally {
            this.config = null;
            this.thrown = null;
            this.concurrentObj.writeUnlock();
        }
    }

    private void cleanup() {
        block31: {
            block30: {
                block29: {
                    block28: {
                        block27: {
                            block26: {
                                if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                                    OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "cleanup");
                                }
                                if (this.serverStub != null) {
                                    try {
                                        if (INIT_LOGGER.isLoggable(Level.FINEST)) {
                                            INIT_LOGGER.log(Level.FINEST, "Unexporting service");
                                        }
                                        this.exporter.unexport(true);
                                    }
                                    catch (Throwable t) {
                                        if (!INIT_LOGGER.isLoggable(Levels.HANDLED)) break block26;
                                        INIT_LOGGER.log(Levels.HANDLED, "Trouble unexporting service", t);
                                    }
                                }
                            }
                            if (this.joiner != null) {
                                try {
                                    if (INIT_LOGGER.isLoggable(Level.FINEST)) {
                                        INIT_LOGGER.log(Level.FINEST, "Terminating join manager");
                                    }
                                    this.joiner.terminate();
                                }
                                catch (Throwable t) {
                                    if (!INIT_LOGGER.isLoggable(Levels.HANDLED)) break block27;
                                    INIT_LOGGER.log(Levels.HANDLED, "Trouble terminating join manager", t);
                                }
                            }
                        }
                        if (this.lookupDiscMgr != null) {
                            try {
                                if (INIT_LOGGER.isLoggable(Level.FINEST)) {
                                    INIT_LOGGER.log(Level.FINEST, "Terminating lookup discovery manager");
                                }
                                this.lookupDiscMgr.terminate();
                            }
                            catch (Throwable t) {
                                if (!INIT_LOGGER.isLoggable(Levels.HANDLED)) break block28;
                                INIT_LOGGER.log(Levels.HANDLED, "Trouble terminating lookup discovery manager", t);
                            }
                        }
                    }
                    if (this.notifier != null) {
                        try {
                            if (INIT_LOGGER.isLoggable(Level.FINEST)) {
                                INIT_LOGGER.log(Level.FINEST, "Interrupting notifier");
                            }
                            this.notifier.interrupt();
                        }
                        catch (Throwable t) {
                            if (!INIT_LOGGER.isLoggable(Levels.HANDLED)) break block29;
                            INIT_LOGGER.log(Levels.HANDLED, "Trouble interrupting notifier", t);
                        }
                    }
                }
                if (this.expirer != null) {
                    try {
                        if (INIT_LOGGER.isLoggable(Level.FINEST)) {
                            INIT_LOGGER.log(Level.FINEST, "Interrupting expirer");
                        }
                        this.expirer.interrupt();
                    }
                    catch (Throwable t) {
                        if (!INIT_LOGGER.isLoggable(Levels.HANDLED)) break block30;
                        INIT_LOGGER.log(Levels.HANDLED, "Trouble interrupting expirer", t);
                    }
                }
            }
            if (this.snapshotter != null) {
                try {
                    if (INIT_LOGGER.isLoggable(Level.FINEST)) {
                        INIT_LOGGER.log(Level.FINEST, "Interrupting snapshotter");
                    }
                    this.snapshotter.interrupt();
                }
                catch (Throwable t) {
                    if (!INIT_LOGGER.isLoggable(Levels.HANDLED)) break block31;
                    INIT_LOGGER.log(Levels.HANDLED, "Trouble interrupting snapshotter", t);
                }
            }
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "cleanup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailboxRegistration register(long leaseDuration) throws RemoteException, LeaseDeniedException {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            Registration registration = this.registerDo(leaseDuration);
            return registration;
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailboxPullRegistration pullRegister(long leaseDuration) throws RemoteException, LeaseDeniedException {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            Registration registration = this.registerDo(leaseDuration);
            return registration;
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableDelivery(Uuid uuid, RemoteEventListener target) throws RemoteException, ThrowThis {
        this.readyState.check();
        RemoteEventListener preparedTarget = null;
        if (target == null) {
            this.disableDelivery(uuid);
            return;
        }
        try {
            preparedTarget = (RemoteEventListener)this.listenerPreparer.prepareProxy((Object)target);
            if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                DELIVERY_LOGGER.log(Level.FINEST, "prepared listener: {0}", preparedTarget);
            }
        }
        catch (RemoteException e) {
            throw new ThrowThis(e);
        }
        this.concurrentObj.writeLock();
        try {
            this.enableDeliveryDo(uuid, preparedTarget);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    public void disableDelivery(Uuid uuid) throws RemoteException, ThrowThis {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            this.disableDeliveryDo(uuid);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    public RemoteEventIteratorData getRemoteEvents(Uuid uuid) throws RemoteException, ThrowThis {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            RemoteEventIteratorData remoteEventIteratorData = this.getRemoteEventsDo(uuid);
            return remoteEventIteratorData;
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getNextBatch(Uuid regId, Uuid iterId, long timeout, Object lastEventCookie) throws InvalidIteratorException, ThrowThis {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            Collection collection = this.getNextBatchDo(regId, iterId, timeout, lastEventCookie);
            return collection;
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    public void addUnknownEvents(Uuid uuid, Collection unknownEvents) throws RemoteException, ThrowThis {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            this.addUnknownEventsDo(uuid, unknownEvents);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    public void notify(Uuid registrationID, RemoteEvent theEvent) throws UnknownEventException, RemoteException, ThrowThis {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            this.notifyDo(registrationID, theEvent);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long renew(Uuid cookie, long extension) throws LeaseDeniedException, UnknownLeaseException, RemoteException {
        this.readyState.check();
        this.concurrentObj.priorityWriteLock();
        try {
            long l = this.renewDo(cookie, extension);
            return l;
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    public void cancel(Uuid cookie) throws UnknownLeaseException, RemoteException {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            this.cancelDo(cookie);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Landlord.RenewResults renewAll(Uuid[] cookies, long[] extension) throws RemoteException {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            Landlord.RenewResults renewResults = this.renewAllDo(cookies, extension);
            return renewResults;
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    public Map cancelAll(Uuid[] cookies) throws RemoteException {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            Map map = this.cancelAllDo(cookies);
            return map;
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    public void destroy() {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "destroy");
        }
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            ServiceRegistration[] regs = this.regByID.values().toArray(new ServiceRegistration[this.regByID.size()]);
            if (ADMIN_LOGGER.isLoggable(Level.FINEST)) {
                ADMIN_LOGGER.log(Level.FINEST, "Notifying {0} possible registrations", this.regByID.size());
            }
            for (int i = 0; i < regs.length; ++i) {
                this.removeRegistration(regs[i].getCookie(), regs[i]);
                regs[i].getIteratorCondition().signal();
                if (!ADMIN_LOGGER.isLoggable(Level.FINEST)) continue;
                ADMIN_LOGGER.log(Level.FINEST, "Iterator for reg {0} notified", regs[i]);
            }
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        new DestroyThread().start();
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "destroy");
        }
    }

    public Entry[] getLookupAttributes() throws RemoteException {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "getLookupAttributes");
        }
        this.readyState.check();
        this.concurrentObj.readLock();
        try {
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "getLookupAttributes");
            }
            Entry[] entryArray = this.joiner.getAttributes();
            return entryArray;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    public void addLookupAttributes(Entry[] attrSets) throws RemoteException {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "addLookupAttributes");
        }
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            this.joiner.addAttributes(attrSets, true);
            this.lookupAttrs = this.joiner.getAttributes();
            this.addLogRecord(new AttrsAddedLogObj(attrSets));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "addLookupAttributes");
        }
    }

    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) throws RemoteException {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "modifyLookupAttributes");
        }
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            this.joiner.modifyAttributes(attrSetTemplates, attrSets, true);
            this.lookupAttrs = this.joiner.getAttributes();
            this.addLogRecord(new AttrsModifiedLogObj(attrSetTemplates, attrSets));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "modifyLookupAttributes");
        }
    }

    public String[] getLookupGroups() throws RemoteException {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "getLookupGroups");
        }
        this.readyState.check();
        this.concurrentObj.readLock();
        try {
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "getLookupGroups");
            }
            String[] stringArray = this.lookupGroups;
            return stringArray;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    public void addLookupGroups(String[] groups) throws RemoteException {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "addLookupGroups");
        }
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            try {
                ((DiscoveryGroupManagement)this.lookupDiscMgr).addGroups(groups);
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString());
            }
            this.lookupGroups = ((DiscoveryGroupManagement)this.lookupDiscMgr).getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.lookupGroups));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "addLookupGroups");
        }
    }

    public void removeLookupGroups(String[] groups) throws RemoteException {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "removeLookupGroups");
        }
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            ((DiscoveryGroupManagement)this.lookupDiscMgr).removeGroups(groups);
            this.lookupGroups = ((DiscoveryGroupManagement)this.lookupDiscMgr).getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.lookupGroups));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "removeLookupGroups");
        }
    }

    public void setLookupGroups(String[] groups) throws RemoteException {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "setLookupGroups");
        }
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            try {
                ((DiscoveryGroupManagement)this.lookupDiscMgr).setGroups(groups);
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString());
            }
            this.lookupGroups = ((DiscoveryGroupManagement)this.lookupDiscMgr).getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.lookupGroups));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "setLookupGroups");
        }
    }

    public LookupLocator[] getLookupLocators() throws RemoteException {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "getLookupLocators");
        }
        this.readyState.check();
        this.concurrentObj.readLock();
        try {
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "getLookupLocators");
            }
            LookupLocator[] lookupLocatorArray = this.lookupLocators;
            return lookupLocatorArray;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    public void addLookupLocators(LookupLocator[] locators) throws RemoteException {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "addLookupLocators");
        }
        this.readyState.check();
        MailboxImpl.prepareNewLocators(locatorToJoinPreparer, locators);
        this.concurrentObj.writeLock();
        try {
            ((DiscoveryLocatorManagement)this.lookupDiscMgr).addLocators(locators);
            this.lookupLocators = ((DiscoveryLocatorManagement)this.lookupDiscMgr).getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.lookupLocators));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "addLookupLocators");
        }
    }

    public void removeLookupLocators(LookupLocator[] locators) throws RemoteException {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "removeLookupLocators");
        }
        this.readyState.check();
        MailboxImpl.prepareNewLocators(locatorToJoinPreparer, locators);
        this.concurrentObj.writeLock();
        try {
            ((DiscoveryLocatorManagement)this.lookupDiscMgr).removeLocators(locators);
            this.lookupLocators = ((DiscoveryLocatorManagement)this.lookupDiscMgr).getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.lookupLocators));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "removeLookupLocators");
        }
    }

    public void setLookupLocators(LookupLocator[] locators) throws RemoteException {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "setLookupLocators");
        }
        this.readyState.check();
        MailboxImpl.prepareNewLocators(locatorToJoinPreparer, locators);
        this.concurrentObj.writeLock();
        try {
            ((DiscoveryLocatorManagement)this.lookupDiscMgr).setLocators(locators);
            this.lookupLocators = ((DiscoveryLocatorManagement)this.lookupDiscMgr).getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.lookupLocators));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "setLookupLocators");
        }
    }

    private void addUnknownEvent(Uuid regID, EventID evid) {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "addUnknownEvent", new Object[]{regID, evid});
        }
        this.concurrentObj.writeLock();
        try {
            this.addUnknownEventDo(regID, evid);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "addUnknownEvent");
        }
    }

    private void addUnknownEventDo(Uuid regID, EventID evid) {
        ServiceRegistration reg;
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "addUnknownEventDo", new Object[]{regID, evid});
        }
        if ((reg = this.regByID.get(regID)) == null || !MailboxImpl.ensureCurrent((LeasedResource)reg)) {
            return;
        }
        if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
            DELIVERY_LOGGER.log(Level.FINEST, "Using reg: {0} ", reg);
        }
        reg.getUnknownEvents().put(evid, evid);
        this.addLogRecord(new UnknownEventExceptionLogObj(regID, evid));
        if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
            DELIVERY_LOGGER.log(Level.FINEST, "UnknownEvents size: {0}", reg.getUnknownEvents().size());
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "addUnknownEventDo");
        }
    }

    private ServiceRegistration getServiceRegistration(Uuid regID) throws ThrowThis {
        ServiceRegistration reg;
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "getServiceRegistration", regID);
        }
        if ((reg = this.regByID.get(regID)) == null) {
            throw new ThrowThis((RemoteException)new NoSuchObjectException("Not managing requested registration object"));
        }
        if (!MailboxImpl.ensureCurrent((LeasedResource)reg)) {
            throw new ThrowThis((RemoteException)new NoSuchObjectException("Requested registration object has expired"));
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "getServiceRegistration", reg);
        }
        return reg;
    }

    private void removeRegistration(Uuid regID, ServiceRegistration reg) {
        this.removeRegistration(regID, reg, false);
    }

    private void removeRegistration(Uuid regID, ServiceRegistration reg, boolean initializing) {
        NotifyTask task;
        boolean exists;
        block10: {
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "removeRegistration", new Object[]{regID, reg, initializing});
            }
            if (!initializing) {
                this.regByID.remove(regID);
            }
            this.regByExpiration.remove(reg);
            exists = this.pendingReg.remove(regID);
            task = this.activeReg.remove(regID);
            if (task != null) {
                task.cancel(false);
                if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                    DELIVERY_LOGGER.log(Level.FINEST, "Cancelling active notification task for {0}", regID);
                }
            }
            try {
                EventLogIterator iter;
                if (PERSISTENCE_LOGGER.isLoggable(Level.FINEST)) {
                    PERSISTENCE_LOGGER.log(Level.FINEST, "Removing logs for {0}", reg);
                }
                if ((iter = reg.iterator()) != null) {
                    iter.destroy();
                }
            }
            catch (IOException ioe) {
                if (!PERSISTENCE_LOGGER.isLoggable(Levels.HANDLED)) break block10;
                PERSISTENCE_LOGGER.log(Levels.HANDLED, "Trouble removing logs", ioe);
            }
        }
        if (exists && task != null && LEASE_LOGGER.isLoggable(Level.SEVERE)) {
            LEASE_LOGGER.log(Level.SEVERE, "ERROR: Registration was found on both the active and pending lists");
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "removeRegistration");
        }
    }

    static File getEventLogPath(String parent, Uuid uuid) {
        return new File(parent, uuid.toString());
    }

    private Registration registerDo(long duration) {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "registerDo", duration);
        }
        if (duration < 1L && duration != -1L) {
            throw new IllegalArgumentException("Duration must be a positive value");
        }
        Uuid uuid = UuidFactory.generate();
        EventLogIterator iter = this.persistent ? this.eventLogFactory.iterator(uuid, MailboxImpl.getEventLogPath(this.persistenceDirectory, uuid)) : this.eventLogFactory.iterator(uuid);
        ServiceRegistration reg = new ServiceRegistration(uuid, iter, this.concurrentObj.newCondition());
        LandlordLease l = null;
        try {
            LeasePeriodPolicy.Result r = this.leasePolicy.grant((LeasedResource)reg, duration);
            reg.setExpiration(r.expiration);
            l = this.leaseFactory.newLease(uuid, r.expiration);
        }
        catch (LeaseDeniedException lde) {
            throw new InternalMailboxException("Registration lease was denied", (Throwable)lde);
        }
        this.addRegistration(reg);
        this.addLogRecord(new RegistrationLogObj(reg));
        if (reg.getExpiration() < this.minRegExpiration) {
            this.minRegExpiration = reg.getExpiration();
            if (EXPIRATION_LOGGER.isLoggable(Level.FINEST)) {
                EXPIRATION_LOGGER.log(Level.FINEST, "Notifying expiration thread");
            }
            this.concurrentObj.waiterNotify(this.expirationNotifier);
        }
        if (LEASE_LOGGER.isLoggable(Level.FINEST)) {
            LEASE_LOGGER.log(Level.FINEST, "Generated new lease for: {0}", reg);
            reg.dumpInfo(LEASE_LOGGER);
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "registerDo");
        }
        return Registration.create((Uuid)uuid, (MailboxBackEnd)this.serverStub, (Lease)l);
    }

    private void addRegistration(ServiceRegistration reg) {
        this.regByID.put(reg.getCookie(), reg);
        this.regByExpiration.put(reg, reg);
    }

    private ServiceRegistration renewRegistration(ServiceRegistration reg, long newExpiry) {
        ServiceRegistration replacement = (ServiceRegistration)reg.renew(newExpiry);
        this.regByID.replace(replacement.getCookie(), reg, replacement);
        this.regByExpiration.remove(reg);
        this.regByExpiration.put(replacement, replacement);
        return replacement;
    }

    private long renewDo(Uuid cookie, long extension) throws UnknownLeaseException, LeaseDeniedException {
        LeasePeriodPolicy.Result r;
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "renewDo", new Object[]{cookie, extension});
        }
        if (extension < 1L && extension != -1L) {
            throw new IllegalArgumentException("Duration must be a positive value");
        }
        ServiceRegistration reg = null;
        if (LEASE_LOGGER.isLoggable(Level.FINEST)) {
            LEASE_LOGGER.log(Level.FINEST, "Attempting to renew {0}''s lease for {1} sec", new Object[]{cookie, extension / 1000L});
        }
        try {
            reg = this.getServiceRegistration(cookie);
            r = this.leasePolicy.renew((LeasedResource)reg, extension);
            reg = this.renewRegistration(reg, r.expiration);
            this.addLogRecord(new RegistrationRenewedLogObj(cookie, reg.getExpiration()));
        }
        catch (ThrowThis tt) {
            if (LEASE_LOGGER.isLoggable(Level.FINEST)) {
                LEASE_LOGGER.log(Level.FINEST, "Lease for {0} was NOT renewed", cookie);
            }
            throw new UnknownLeaseException("Not managing requested lease");
        }
        if (LEASE_LOGGER.isLoggable(Level.FINEST)) {
            LEASE_LOGGER.log(Level.FINEST, "Lease for {0} was renewed", cookie);
            reg.dumpInfo(LEASE_LOGGER);
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "renewDo", r.duration);
        }
        return r.duration;
    }

    private void cancelDo(Uuid cookie) throws UnknownLeaseException {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "cancelDo", cookie);
        }
        ServiceRegistration reg = null;
        if (LEASE_LOGGER.isLoggable(Level.FINEST)) {
            LEASE_LOGGER.log(Level.FINEST, "Attempting to cancel lease for: {0}", cookie);
        }
        try {
            reg = this.getServiceRegistration(cookie);
            this.removeRegistration(cookie, reg);
            this.addLogRecord(new RegistrationCancelledLogObj(cookie));
            if (reg.getExpiration() == this.minRegExpiration) {
                if (EXPIRATION_LOGGER.isLoggable(Level.FINEST)) {
                    EXPIRATION_LOGGER.log(Level.FINEST, "Notifying expiration thread");
                }
                this.concurrentObj.waiterNotify(this.expirationNotifier);
            }
            reg.getIteratorCondition().signal();
            if (EXPIRATION_LOGGER.isLoggable(Level.FINEST)) {
                EXPIRATION_LOGGER.log(Level.FINEST, "Iterator notified");
            }
        }
        catch (ThrowThis tt) {
            throw new UnknownLeaseException("Not managing requested lease");
        }
        if (LEASE_LOGGER.isLoggable(Level.FINEST)) {
            LEASE_LOGGER.log(Level.FINEST, "Lease cancelled for: {0}", cookie);
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "cancelDo");
        }
    }

    private Landlord.RenewResults renewAllDo(Uuid[] cookie, long[] extension) throws RemoteException {
        Landlord.RenewResults rslt;
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "renewAllDo");
        }
        int count = cookie.length;
        if (LEASE_LOGGER.isLoggable(Level.FINEST)) {
            LEASE_LOGGER.log(Level.FINEST, "Attempting to renew a batch of {0} leases", count);
        }
        if ((rslt = LandlordUtil.renewAll((LocalLandlord)this.localLandlord, (Uuid[])cookie, (long[])extension)).noneDenied()) {
            if (LEASE_LOGGER.isLoggable(Level.FINEST)) {
                LEASE_LOGGER.log(Level.FINEST, "Batch renew totally successful");
            }
        } else if (LEASE_LOGGER.isLoggable(Level.FINEST)) {
            LEASE_LOGGER.log(Level.FINEST, "Batch renew contained exceptions");
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "renewAllDo");
        }
        return rslt;
    }

    private Map cancelAllDo(Uuid[] cookie) throws RemoteException {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "cancelAllDo");
        }
        int count = cookie.length;
        if (LEASE_LOGGER.isLoggable(Level.FINEST)) {
            LEASE_LOGGER.log(Level.FINEST, "Attempting to cancel a batch of {0} leases", count);
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "cancelAllDo");
        }
        return LandlordUtil.cancelAll((LocalLandlord)this.localLandlord, (Uuid[])cookie);
    }

    private void enableDeliveryDo(Uuid uuid, RemoteEventListener preparedTarget) throws ThrowThis {
        Uuid id;
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "enableDeliveryDo", new Object[]{uuid, preparedTarget});
        }
        if (preparedTarget instanceof ListenerProxy && this.regByID.get(id = ((ListenerProxy)preparedTarget).getReferentUuid()) != null) {
            if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                DELIVERY_LOGGER.log(Level.FINEST, "Disallowing resubmission of one of this service''s own listeners: {0}", id);
            }
            throw new IllegalArgumentException("Cannot submit a listener that was provided by the same EventMailbox service");
        }
        this.enableRegistration(uuid, preparedTarget);
        this.addLogRecord(new RegistrationEnabledLogObj(uuid, preparedTarget));
        this.concurrentObj.waiterNotify(this.eventNotifier);
        ServiceRegistration reg = this.getServiceRegistration(uuid);
        reg.getIteratorCondition().signal();
        if (EXPIRATION_LOGGER.isLoggable(Level.FINEST)) {
            EXPIRATION_LOGGER.log(Level.FINEST, "Iterator notified");
        }
        if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
            DELIVERY_LOGGER.log(Level.FINEST, "Enabling delivery for {0} to {1}", new Object[]{uuid, preparedTarget});
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "enableDeliveryDo");
        }
    }

    private void enableRegistration(Uuid uuid, RemoteEventListener preparedTarget) throws ThrowThis {
        ServiceRegistration reg = this.getServiceRegistration(uuid);
        try {
            reg.setEventTarget(preparedTarget);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Passed a listener that could not be serialized");
        }
        this.disableRegistrationIterator(uuid);
        reg.getUnknownEvents().clear();
        if (!this.pendingReg.contains(uuid) && !this.activeReg.containsKey(uuid)) {
            this.pendingReg.add(uuid);
        }
    }

    private void disableDeliveryDo(Uuid uuid) throws ThrowThis {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "disableDeliveryDo", uuid);
        }
        this.disableRegistration(uuid);
        this.addLogRecord(new RegistrationDisabledLogObj(uuid));
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "disableDeliveryDo");
        }
    }

    private void disableRegistration(Uuid uuid) throws ThrowThis {
        if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
            DELIVERY_LOGGER.log(Level.FINEST, "Attempting to disable delivery for {0}", uuid);
        }
        ServiceRegistration reg = this.getServiceRegistration(uuid);
        boolean wasEnabled = reg.hasEventTarget();
        try {
            reg.setEventTarget(null);
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)("Setting a null target threw an exception: " + ioe));
        }
        boolean inPending = this.pendingReg.remove(uuid);
        NotifyTask task = this.activeReg.remove(uuid);
        if (task != null) {
            task.cancel(false);
            if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                DELIVERY_LOGGER.log(Level.FINEST, "Cancelling active notification task for {0}", uuid);
            }
        }
        if (wasEnabled && !inPending && task == null && !this.inRecovery && DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
            DELIVERY_LOGGER.log(Level.FINEST, "*** Registration was not found on the active or pending lists");
        }
        if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
            DELIVERY_LOGGER.log(Level.FINEST, "Disabled delivery for {0}", uuid);
        }
    }

    private void enableRegistrationIterator(Uuid regId, Uuid iterId) throws ThrowThis {
        ServiceRegistration reg = this.getServiceRegistration(regId);
        reg.setRemoteEventIteratorID(iterId);
        this.disableRegistration(regId);
        reg.getUnknownEvents().clear();
    }

    private void disableRegistrationIterator(Uuid regId) throws ThrowThis {
        ServiceRegistration reg = this.getServiceRegistration(regId);
        reg.setRemoteEventIteratorID(null);
    }

    private void addUnknownEventsDo(Uuid uuid, Collection unknownEvents) throws ThrowThis {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "addUnknownEventsDo", new Object[]{uuid, unknownEvents});
        }
        this.getServiceRegistration(uuid);
        for (RemoteEvent ev : unknownEvents) {
            this.addUnknownEventDo(uuid, new EventID(ev));
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "addUnknownEventsDo");
        }
    }

    private RemoteEventIteratorData getRemoteEventsDo(Uuid uuid) throws ThrowThis {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "getRemoteEventsDo", new Object[]{uuid});
        }
        ArrayList<RemoteEventData> events = new ArrayList<RemoteEventData>();
        ServiceRegistration reg = this.getServiceRegistration(uuid);
        Uuid iteratorId = UuidFactory.generate();
        if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
            DELIVERY_LOGGER.log(Level.FINEST, "Generated remote event iterator id {0}", iteratorId);
        }
        this.addLogRecord(new RegistrationIteratorEnabledLogObj(uuid, iteratorId));
        this.enableRegistrationIterator(uuid, iteratorId);
        try {
            EventLogIterator eli = reg.iterator();
            if (eli.hasNext()) {
                RemoteEventData[] evts = eli.readAhead(Integer.MAX_VALUE);
                RemoteEvent evt = null;
                for (int i = 0; i < evts.length; ++i) {
                    evt = evts[i].getRemoteEvent();
                    if (evt == null || reg.getUnknownEvents().containsKey(new EventID(evt))) continue;
                    events.add(evts[i]);
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        reg.getIteratorCondition().signal();
        if (EXPIRATION_LOGGER.isLoggable(Level.FINEST)) {
            EXPIRATION_LOGGER.log(Level.FINEST, "Iterator notified");
        }
        events.trimToSize();
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "getRemoteEventsDo", events);
        }
        return new RemoteEventIteratorData(iteratorId, events);
    }

    private Collection getNextBatchDo(Uuid regId, Uuid iterId, long timeout, Object lastEventCookie) throws InvalidIteratorException, ThrowThis {
        ArrayList<RemoteEventData> events;
        block21: {
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "getNextBatchDo", new Object[]{regId, iterId, timeout, lastEventCookie});
            }
            if (timeout < 0L) {
                throw new IllegalArgumentException("Timeout value must non-negative");
            }
            long endTime = System.currentTimeMillis() + timeout;
            if (endTime < 0L) {
                endTime = Long.MAX_VALUE;
            }
            events = new ArrayList<RemoteEventData>();
            this.validateIterator(regId, iterId);
            try {
                ServiceRegistration reg = this.getServiceRegistration(regId);
                EventLogIterator eli = reg.iterator();
                if (OPERATIONS_LOGGER.isLoggable(Level.FINEST)) {
                    OPERATIONS_LOGGER.log(Level.FINEST, "Moving past lastEventCookie {0}", lastEventCookie);
                }
                if (lastEventCookie != null) {
                    eli.moveAhead(lastEventCookie);
                }
                do {
                    if (eli.hasNext()) {
                        RemoteEventData[] evts = eli.readAhead(Integer.MAX_VALUE);
                        RemoteEvent evt = null;
                        for (int i = 0; i < evts.length; ++i) {
                            try {
                                evt = evts[i].getRemoteEvent();
                                if (evt != null && !reg.getUnknownEvents().containsKey(new EventID(evt))) {
                                    events.add(evts[i]);
                                    continue;
                                }
                                if (!DELIVERY_LOGGER.isLoggable(Level.FINEST)) continue;
                                DELIVERY_LOGGER.log(Level.FINEST, "Problem with unknown or unrecoverable RemoteEvent {0} -- skipping", evt);
                                continue;
                            }
                            catch (ClassNotFoundException cnfe) {
                                if (!DELIVERY_LOGGER.isLoggable(Levels.HANDLED)) continue;
                                DELIVERY_LOGGER.log(Levels.HANDLED, "Problem accessing RemoteEvent -- skipping", cnfe);
                            }
                        }
                    }
                    long waitFor = endTime - System.currentTimeMillis();
                    if (events.size() != 0 || waitFor <= 0L) continue;
                    if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                        DELIVERY_LOGGER.log(Level.FINEST, "No available events. Attempting to wait for " + waitFor + " milliseconds.");
                    }
                    try {
                        reg.getIteratorCondition().await(timeout, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        return new ArrayList(0);
                    }
                    this.validateIterator(regId, iterId);
                } while (System.currentTimeMillis() < endTime && events.size() == 0);
            }
            catch (IOException ioe) {
                if (DELIVERY_LOGGER.isLoggable(Levels.HANDLED)) {
                    DELIVERY_LOGGER.log(Levels.HANDLED, "Trouble accessing event state - skipping", ioe);
                }
            }
            catch (NoSuchElementException nse) {
                if (DELIVERY_LOGGER.isLoggable(Level.WARNING)) {
                    DELIVERY_LOGGER.log(Level.WARNING, "Invalid iterator access", nse);
                }
                throw new InvalidIteratorException("Invalid iterator access: " + nse);
            }
            catch (ClassNotFoundException cnfe) {
                if (!DELIVERY_LOGGER.isLoggable(Levels.HANDLED)) break block21;
                DELIVERY_LOGGER.log(Levels.HANDLED, "Trouble accessing remote event(s) - skipping", cnfe);
            }
        }
        events.trimToSize();
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "getNextBatchDo", events);
        }
        return events;
    }

    private void validateIterator(Uuid regId, Uuid iterId) throws InvalidIteratorException, ThrowThis {
        ServiceRegistration reg = this.getServiceRegistration(regId);
        Uuid validIterId = reg.getRemoteEventIteratorID();
        if (!iterId.equals((Object)validIterId)) {
            if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                DELIVERY_LOGGER.log(Level.FINEST, "Provided iterator id " + iterId + " doesn't match current valid iterator id " + validIterId);
            }
            throw new InvalidIteratorException("Iterator is not valid");
        }
    }

    private void notifyDo(Uuid registrationID, RemoteEvent theEvent) throws UnknownEventException, RemoteException, ThrowThis {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "notifyDo", new Object[]{registrationID, theEvent});
        }
        if (RECEIVE_LOGGER.isLoggable(Level.FINEST)) {
            RECEIVE_LOGGER.log(Level.FINEST, "RemoteEvent {0}, ID {1}, Seq# {2}", new Object[]{theEvent, theEvent.getID(), theEvent.getSequenceNumber()});
        }
        ServiceRegistration reg = this.getServiceRegistration(registrationID);
        EventID evtid = new EventID(theEvent);
        if (reg.getUnknownEvents().containsKey(evtid)) {
            if (RECEIVE_LOGGER.isLoggable(Level.FINEST)) {
                RECEIVE_LOGGER.log(Level.FINEST, "Discarding event -- it is unknown");
            }
            throw new UnknownEventException();
        }
        try {
            reg.iterator().add(theEvent);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (reg.hasEventTarget()) {
            this.concurrentObj.waiterNotify(this.eventNotifier);
            if (RECEIVE_LOGGER.isLoggable(Level.FINEST)) {
                RECEIVE_LOGGER.log(Level.FINEST, "Notifier notified");
            }
        } else if (reg.getRemoteEventIteratorID() != null) {
            reg.getIteratorCondition().signal();
            if (RECEIVE_LOGGER.isLoggable(Level.FINEST)) {
                RECEIVE_LOGGER.log(Level.FINEST, "Iterator notified");
            }
        } else if (RECEIVE_LOGGER.isLoggable(Level.FINEST)) {
            RECEIVE_LOGGER.log(Level.FINEST, "Notification skipped");
        }
        if (RECEIVE_LOGGER.isLoggable(Level.FINEST)) {
            RECEIVE_LOGGER.log(Level.FINEST, "");
            reg.dumpInfo(RECEIVE_LOGGER);
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "notifyDo");
        }
    }

    public Entry[] getServiceAttributes() throws IOException {
        return this.getLookupAttributes();
    }

    public ServiceID serviceID() throws IOException {
        return new ServiceID(this.serviceID.getMostSignificantBits(), this.serviceID.getLeastSignificantBits());
    }

    public String getClassAnnotation() throws IOException {
        return "".equals(this.codebase) ? CodebaseProvider.getClassAnnotation(MailboxBackEnd.class) : this.codebase;
    }

    public String getCertFactoryType() throws IOException {
        return this.certFactoryType;
    }

    public String getCertPathEncoding() throws IOException {
        return this.certPathEncoding;
    }

    public byte[] getEncodedCerts() throws IOException {
        return (byte[])this.encodedCerts.clone();
    }

    private static MarshalledObject[] marshalAttributes(Entry[] attrs) {
        if (attrs == null) {
            return new MarshalledObject[0];
        }
        ArrayList<MarshalledObject> marshalledAttrs = new ArrayList<MarshalledObject>();
        for (int i = 0; i < attrs.length; ++i) {
            try {
                marshalledAttrs.add(new MarshalledInstance((Object)attrs[i]).convertToMarshalledObject());
                continue;
            }
            catch (Throwable e) {
                if (!RECOVERY_LOGGER.isLoggable(Levels.HANDLED)) continue;
                RECOVERY_LOGGER.log(Levels.HANDLED, "Error while marshalling attribute[{0}]: {1}", new Object[]{i, attrs[i]});
                RECOVERY_LOGGER.log(Levels.HANDLED, "Marshalling exception", e);
            }
        }
        return marshalledAttrs.toArray(new MarshalledObject[marshalledAttrs.size()]);
    }

    private static Entry[] unmarshalAttributes(MarshalledObject[] marshalledAttrs) {
        if (marshalledAttrs == null) {
            return new Entry[0];
        }
        ArrayList<Entry> attrs = new ArrayList<Entry>();
        for (int i = 0; i < marshalledAttrs.length; ++i) {
            try {
                attrs.add((Entry)new MarshalledInstance(marshalledAttrs[i]).get(false));
                continue;
            }
            catch (Throwable e) {
                if (!RECOVERY_LOGGER.isLoggable(Levels.HANDLED)) continue;
                RECOVERY_LOGGER.log(Levels.HANDLED, "Error while unmarshalling attribute[{0}]: {1}", new Object[]{i, marshalledAttrs[i]});
                RECOVERY_LOGGER.log(Levels.HANDLED, "Exception was", e);
            }
        }
        return attrs.toArray(new Entry[attrs.size()]);
    }

    private void addLogRecord(LogRecord rec) {
        block8: {
            if (this.log == null) {
                return;
            }
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "addLogRecord", rec);
            }
            try {
                if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                    RECOVERY_LOGGER.log(Level.FINEST, "Adding log record: {0}", rec);
                }
                this.log.update((Object)rec, true);
                if (++this.logFileSize >= this.logToSnapshotThreshold) {
                    if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                        RECOVERY_LOGGER.log(Level.FINEST, "Notifying snapshot thread");
                    }
                    this.concurrentObj.waiterNotify(this.snapshotNotifier);
                }
            }
            catch (Exception e) {
                if (!RECOVERY_LOGGER.isLoggable(Levels.HANDLED)) break block8;
                RECOVERY_LOGGER.log(Levels.HANDLED, "Exception adding LogRecord", e);
            }
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "addLogRecord");
        }
    }

    private void takeSnapshot(OutputStream out) throws IOException {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "takeSnapshot", out);
        }
        if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
            RECOVERY_LOGGER.log(Level.FINEST, "Taking snapshot ...");
        }
        ObjectOutputStream stream = new ObjectOutputStream(out);
        stream.writeUTF(MAILBOX_SOURCE_CLASS);
        stream.writeInt(2);
        stream.writeObject(this.serviceID);
        stream.writeObject(this.lookupGroups);
        stream.writeObject(this.lookupLocators);
        stream.writeObject(MailboxImpl.marshalAttributes(this.lookupAttrs));
        stream.writeObject(this.regByID);
        stream.flush();
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "takeSnapshot");
        }
    }

    private void recoverSnapshot(InputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream stream;
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "recoverSnapshot", in);
        }
        if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
            RECOVERY_LOGGER.log(Level.FINEST, "Recovering snapshot ...");
        }
        if (!MAILBOX_SOURCE_CLASS.equals((stream = new ObjectInputStream(in)).readUTF())) {
            throw new IOException("log from wrong implementation");
        }
        if (stream.readInt() != 2) {
            throw new IOException("wrong log format version");
        }
        this.serviceID = (Uuid)stream.readObject();
        this.lookupGroups = (String[])stream.readObject();
        this.lookupLocators = (LookupLocator[])stream.readObject();
        MarshalledObject[] marshalledAttrs = (MarshalledObject[])stream.readObject();
        this.lookupAttrs = MailboxImpl.unmarshalAttributes(marshalledAttrs);
        HashMap regByID = (HashMap)stream.readObject();
        for (ServiceRegistration reg : regByID.values()) {
            if (reg == null) continue;
            reg.setCondition(this.concurrentObj.newCondition());
        }
        this.regByID.clear();
        this.regByID.putAll(regByID);
        if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
            RECOVERY_LOGGER.log(Level.FINEST, "serviceID: {0}", this.serviceID);
            RECOVERY_LOGGER.log(Level.FINEST, "lookupGroups:");
            MailboxImpl.dumpGroups(this.lookupGroups, RECOVERY_LOGGER, Level.FINEST);
            RECOVERY_LOGGER.log(Level.FINEST, "lookupLocators:");
            MailboxImpl.dumpLocators(this.lookupLocators, RECOVERY_LOGGER, Level.FINEST);
            RECOVERY_LOGGER.log(Level.FINEST, "lookupAttributes:");
            MailboxImpl.dumpAttrs(this.lookupAttrs, RECOVERY_LOGGER, Level.FINEST);
            Collection regs = regByID.values();
            for (ServiceRegistration reg : regs) {
                reg.dumpInfo(RECOVERY_LOGGER);
            }
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "recoverSnapshot");
        }
    }

    static void dumpGroups(String[] grps, Logger logger, Level level) {
        if (logger.isLoggable(level)) {
            if (grps == null) {
                logger.log(level, "<ALL_GROUPS>");
            } else if (grps.length == 0) {
                logger.log(level, "<NO_GROUPS>");
            } else {
                String[] dups = new String[grps.length];
                for (int i = 0; i < grps.length; ++i) {
                    dups[i] = "".equals(grps[i]) ? "<PUBLIC_GROUP>" : grps[i];
                }
                logger.log(level, "Groups: {0}", Arrays.asList(dups));
            }
        }
    }

    static void dumpLocators(LookupLocator[] locs, Logger logger, Level level) {
        if (logger.isLoggable(level)) {
            if (locs == null) {
                logger.log(level, "<null>");
            } else if (locs.length == 0) {
                logger.log(level, "<EMPTY>");
            } else {
                logger.log(level, "Locators: {0}", Arrays.asList(locs));
            }
        }
    }

    static void dumpAttrs(Entry[] attrs, Logger logger, Level level) {
        if (logger.isLoggable(level)) {
            if (attrs == null) {
                logger.log(level, "<null>");
            } else if (attrs.length == 0) {
                logger.log(level, "<EMPTY>");
            } else {
                logger.log(level, "Attributes: {0}", Arrays.asList(attrs));
            }
        }
    }

    protected void initFailed(Throwable e) throws Exception {
        INIT_LOGGER.log(Level.SEVERE, "Mercury failed to initialize", e);
        if (e instanceof PrivilegedActionException) {
            e = e.getCause();
        }
        if (e instanceof Exception) {
            throw (Exception)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new IllegalStateException(e.getMessage(), e);
    }

    private static void prepareNewLocators(ProxyPreparer preparer, LookupLocator[] locators) throws RemoteException {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "prepareNewLocators");
        }
        for (int i = 0; i < locators.length; ++i) {
            locators[i] = (LookupLocator)preparer.prepareProxy((Object)locators[i]);
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "prepareNewLocators");
        }
    }

    static LookupLocator[] prepareExistingLocators(ProxyPreparer preparer, LookupLocator[] lookupLocators) {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "prepareExistingLocators");
        }
        ArrayList<Object> locsList = new ArrayList<Object>(lookupLocators.length);
        for (int i = 0; i < lookupLocators.length; ++i) {
            try {
                locsList.add(preparer.prepareProxy((Object)lookupLocators[i]));
                continue;
            }
            catch (Exception e) {
                if (!DELIVERY_LOGGER.isLoggable(Level.INFO)) continue;
                DELIVERY_LOGGER.log(Level.INFO, "Failure preparing recovered lookup locator: {0}", lookupLocators[i]);
                DELIVERY_LOGGER.log(Level.INFO, "Associated exception is: ", e);
            }
        }
        lookupLocators = locsList.toArray(new LookupLocator[locsList.size()]);
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "prepareExistingLocators");
        }
        return lookupLocators;
    }

    public TrustVerifier getProxyVerifier() {
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.entering(MAILBOX_SOURCE_CLASS, "getProxyVerifier");
        }
        this.readyState.check();
        if (!(this.mailboxProxy instanceof RemoteMethodControl)) {
            throw new UnsupportedOperationException();
        }
        if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
            OPERATIONS_LOGGER.exiting(MAILBOX_SOURCE_CLASS, "getProxyVerifier");
        }
        return new ProxyVerifier(this.serverStub, this.serviceID);
    }

    static boolean ensureCurrent(LeasedResource resource) {
        return resource.getExpiration() > System.currentTimeMillis();
    }

    static /* synthetic */ String[] access$702(MailboxImpl x0, String[] x1) {
        x0.lookupGroups = x1;
        return x1;
    }

    static /* synthetic */ LookupLocator[] access$802(MailboxImpl x0, LookupLocator[] x1) {
        x0.lookupLocators = x1;
        return x1;
    }

    static /* synthetic */ Entry[] access$902(MailboxImpl x0, Entry[] x1) {
        x0.lookupAttrs = x1;
        return x1;
    }

    private class SnapshotThread
    extends InterruptedStatusThread {
        public SnapshotThread() {
            super("SnapshotThread");
            this.setDaemon(false);
        }

        public void run() {
            block16: {
                if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                    OPERATIONS_LOGGER.entering(SNAPSHOT_THREAD_SOURCE_CLASS, "run");
                }
                try {
                    MailboxImpl.this.concurrentObj.readLock();
                }
                catch (ReadersWriter.ConcurrentLockException e) {
                    return;
                }
                while (true) {
                    if (this.hasBeenInterrupted()) break block16;
                    MailboxImpl.this.concurrentObj.readerWait(MailboxImpl.this.snapshotNotifier, Long.MAX_VALUE);
                    try {
                        MailboxImpl.this.log.snapshot();
                        MailboxImpl.this.logFileSize = 0;
                        continue;
                    }
                    catch (InterruptedIOException e) {
                        MailboxImpl.this.concurrentObj.readUnlock();
                        return;
                    }
                    catch (Exception e) {
                        block17: {
                            if (!(e instanceof LogException) || !(((LogException)e).detail instanceof InterruptedIOException)) break block17;
                            MailboxImpl.this.concurrentObj.readUnlock();
                            return;
                        }
                        try {
                            if (!PERSISTENCE_LOGGER.isLoggable(Levels.HANDLED)) continue;
                            PERSISTENCE_LOGGER.log(Levels.HANDLED, "Exception taking snapshot", e);
                            continue;
                        }
                        catch (ReadersWriter.ConcurrentLockException e2) {
                            MailboxImpl.this.concurrentObj.readUnlock();
                            return;
                        }
                    }
                    break;
                }
                finally {
                    MailboxImpl.this.concurrentObj.readUnlock();
                }
            }
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(SNAPSHOT_THREAD_SOURCE_CLASS, "run");
            }
        }
    }

    private class LocalLogHandler
    extends LogHandler {
        public void snapshot(OutputStream out) throws IOException {
            MailboxImpl.this.concurrentObj.readLock();
            try {
                MailboxImpl.this.takeSnapshot(out);
            }
            finally {
                MailboxImpl.this.concurrentObj.readUnlock();
            }
        }

        public void recover(InputStream in) throws IOException, ClassNotFoundException {
            MailboxImpl.this.concurrentObj.writeLock();
            try {
                MailboxImpl.this.recoverSnapshot(in);
            }
            finally {
                MailboxImpl.this.concurrentObj.writeUnlock();
            }
        }

        public void applyUpdate(Object logRecObj) {
            ((LogRecord)logRecObj).apply(MailboxImpl.this);
        }
    }

    private static class UnknownEventExceptionLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private Uuid regID;
        private EventID evtID;

        public UnknownEventExceptionLogObj(Uuid id, EventID eid) {
            this.regID = id;
            this.evtID = eid;
        }

        @Override
        public void apply(MailboxImpl mb) {
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.entering(UNKNOWN_EVENT_EXCEPTION_LOG_OBJ_SOURCE_CLASS, "apply", mb);
            }
            if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                RECOVERY_LOGGER.log(Level.FINEST, "Applying a {0}", this.getClass().getName());
                RECOVERY_LOGGER.log(Level.FINEST, "Adding: {0} to {1}", new Object[]{this.evtID, this.regID});
            }
            ServiceRegistration reg = (ServiceRegistration)mb.regByID.get(this.regID);
            reg.getUnknownEvents().put(this.evtID, this.evtID);
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(UNKNOWN_EVENT_EXCEPTION_LOG_OBJ_SOURCE_CLASS, "apply");
            }
        }
    }

    private static class RegistrationCancelledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private Uuid regID;

        public RegistrationCancelledLogObj(Uuid id) {
            this.regID = id;
        }

        @Override
        public void apply(MailboxImpl mb) {
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.entering(REGISTRATION_CANCELLED_LOG_OBJ_SOURCE_CLASS, "apply", mb);
            }
            if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                RECOVERY_LOGGER.log(Level.FINEST, "Applying a {0}", this.getClass().getName());
                RECOVERY_LOGGER.log(Level.FINEST, "Cancelling Reg: {0}", this.regID);
            }
            ServiceRegistration reg = (ServiceRegistration)mb.regByID.get(this.regID);
            mb.removeRegistration(this.regID, reg);
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(REGISTRATION_CANCELLED_LOG_OBJ_SOURCE_CLASS, "apply");
            }
        }
    }

    private static class RegistrationRenewedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private Uuid regID;
        private long expirationTime;

        public RegistrationRenewedLogObj(Uuid id, long time) {
            this.regID = id;
            this.expirationTime = time;
        }

        @Override
        public void apply(MailboxImpl mb) {
            ServiceRegistration reg;
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.entering(REGISTRATION_RENEWED_LOG_OBJ_SOURCE_CLASS, "apply", mb);
            }
            if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                RECOVERY_LOGGER.log(Level.FINEST, "Applying a {0}", this.getClass().getName());
                RECOVERY_LOGGER.log(Level.FINEST, "Reg: {0} will expire at {1}", new Object[]{this.regID, new Date(this.expirationTime)});
            }
            if ((reg = (ServiceRegistration)mb.regByID.get(this.regID)) != null) {
                mb.renewRegistration(reg, this.expirationTime);
            } else if (RECOVERY_LOGGER.isLoggable(Levels.HANDLED)) {
                RECOVERY_LOGGER.log(Levels.HANDLED, "*** Registration not renewed - not found");
            }
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(REGISTRATION_RENEWED_LOG_OBJ_SOURCE_CLASS, "apply");
            }
        }
    }

    private static class AttrsModifiedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private MarshalledObject[] marshalledAttrTmpls;
        private MarshalledObject[] marshalledModAttrs;

        public AttrsModifiedLogObj(Entry[] attrTmpls, Entry[] modAttrs) {
            this.marshalledAttrTmpls = MailboxImpl.marshalAttributes(attrTmpls);
            this.marshalledModAttrs = MailboxImpl.marshalAttributes(modAttrs);
        }

        @Override
        public void apply(MailboxImpl mb) {
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.entering(ATTRS_MODIFIED_LOG_OBJ_SOURCE_CLASS, "apply", mb);
            }
            if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                RECOVERY_LOGGER.log(Level.FINEST, "Applying a {0}", this.getClass().getName());
                RECOVERY_LOGGER.log(Level.FINEST, "Attributes (before):");
                MailboxImpl.dumpAttrs(mb.lookupAttrs, RECOVERY_LOGGER, Level.FINEST);
            }
            Entry[] attrTmpls = MailboxImpl.unmarshalAttributes(this.marshalledAttrTmpls);
            Entry[] modAttrs = MailboxImpl.unmarshalAttributes(this.marshalledModAttrs);
            MailboxImpl.access$902(mb, LookupAttributes.modify((Entry[])mb.lookupAttrs, (Entry[])attrTmpls, (Entry[])modAttrs));
            if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                RECOVERY_LOGGER.log(Level.FINEST, "Attributes (after):");
                MailboxImpl.dumpAttrs(mb.lookupAttrs, RECOVERY_LOGGER, Level.FINEST);
            }
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(ATTRS_MODIFIED_LOG_OBJ_SOURCE_CLASS, "apply");
            }
        }
    }

    private static class AttrsAddedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private MarshalledObject[] marshalledAttrs;

        public AttrsAddedLogObj(Entry[] attrs) {
            this.marshalledAttrs = MailboxImpl.marshalAttributes(attrs);
        }

        @Override
        public void apply(MailboxImpl mb) {
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.entering(ATTRS_ADDED_LOG_OBJ_SOURCE_CLASS, "apply", mb);
            }
            if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                RECOVERY_LOGGER.log(Level.FINEST, "Applying a {0}", this.getClass().getName());
            }
            Entry[] attrs = MailboxImpl.unmarshalAttributes(this.marshalledAttrs);
            MailboxImpl.access$902(mb, LookupAttributes.add((Entry[])mb.lookupAttrs, (Entry[])attrs));
            if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                RECOVERY_LOGGER.log(Level.FINEST, "Added the attributes:");
                MailboxImpl.dumpAttrs(attrs, RECOVERY_LOGGER, Level.FINEST);
            }
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(ATTRS_ADDED_LOG_OBJ_SOURCE_CLASS, "apply");
            }
        }
    }

    private static class LookupLocatorsChangedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private LookupLocator[] locators;

        public LookupLocatorsChangedLogObj(LookupLocator[] locators) {
            this.locators = locators;
        }

        @Override
        public void apply(MailboxImpl mb) {
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.entering(LOOKUP_LOCATORS_CHANGED_LOG_OBJ_SOURCE_CLASS, "apply", mb);
            }
            if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                RECOVERY_LOGGER.log(Level.FINEST, "Applying a {0}", this.getClass().getName());
                MailboxImpl.dumpLocators(this.locators, RECOVERY_LOGGER, Level.FINEST);
            }
            MailboxImpl.access$802(mb, this.locators);
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(LOOKUP_LOCATORS_CHANGED_LOG_OBJ_SOURCE_CLASS, "apply");
            }
        }
    }

    private static class LookupGroupsChangedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private String[] groups;

        public LookupGroupsChangedLogObj(String[] groups) {
            this.groups = groups;
        }

        @Override
        public void apply(MailboxImpl mb) {
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.entering(LOOKUP_GROUPS_CHANGED_LOG_OBJ_SOURCE_CLASS, "apply", mb);
            }
            if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                RECOVERY_LOGGER.log(Level.FINEST, "Applying a {0}", this.getClass().getName());
                MailboxImpl.dumpGroups(this.groups, RECOVERY_LOGGER, Level.FINEST);
            }
            MailboxImpl.access$702(mb, this.groups);
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(LOOKUP_GROUPS_CHANGED_LOG_OBJ_SOURCE_CLASS, "apply");
            }
        }
    }

    private static class RegistrationIteratorEnabledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private Uuid regID;
        private Uuid iterID;

        public RegistrationIteratorEnabledLogObj(Uuid rid, Uuid iid) {
            this.regID = rid;
            this.iterID = iid;
        }

        @Override
        public void apply(MailboxImpl mb) {
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.entering(REGISTRATION_ITERATOR_ENABLED_LOG_OBJ_SOURCE_CLASS, "apply", mb);
            }
            if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                RECOVERY_LOGGER.log(Level.FINEST, "Applying a {0}, regID = {1}, iterID = {2}", new Object[]{this.getClass().getName(), this.regID, this.iterID});
            }
            try {
                mb.enableRegistrationIterator(this.regID, this.iterID);
            }
            catch (ThrowThis throwThis) {
                // empty catch block
            }
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(REGISTRATION_ITERATOR_ENABLED_LOG_OBJ_SOURCE_CLASS, "apply");
            }
        }
    }

    private static class RegistrationDisabledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private Uuid regID;

        public RegistrationDisabledLogObj(Uuid id) {
            this.regID = id;
        }

        @Override
        public void apply(MailboxImpl mb) {
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.entering(REGISTRATION_DISABLED_LOG_OBJ_SOURCE_CLASS, "apply", mb);
            }
            if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                RECOVERY_LOGGER.log(Level.FINEST, "Applying a {0}, regID = {1}", new Object[]{this.getClass().getName(), this.regID});
            }
            try {
                mb.disableRegistration(this.regID);
            }
            catch (ThrowThis throwThis) {
                // empty catch block
            }
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(REGISTRATION_DISABLED_LOG_OBJ_SOURCE_CLASS, "apply");
            }
        }
    }

    private static class RegistrationEnabledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private Uuid regID;
        private transient RemoteEventListener target;

        public RegistrationEnabledLogObj(Uuid id, RemoteEventListener l) {
            this.regID = id;
            this.target = l;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeObject(new MarshalledInstance((Object)this.target).convertToMarshalledObject());
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            block2: {
                stream.defaultReadObject();
                MarshalledObject mo = (MarshalledObject)stream.readObject();
                try {
                    this.target = (RemoteEventListener)new MarshalledInstance(mo).get(false);
                }
                catch (Throwable e) {
                    if (!(e instanceof Error) || e instanceof LinkageError || e instanceof OutOfMemoryError || e instanceof StackOverflowError) break block2;
                    throw (Error)e;
                }
            }
        }

        @Override
        public void apply(MailboxImpl mb) {
            block8: {
                if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                    OPERATIONS_LOGGER.entering(REGISTRATION_ENABLED_LOG_OBJ_SOURCE_CLASS, "apply", mb);
                }
                if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                    RECOVERY_LOGGER.log(Level.FINEST, "Applying a {0}, regID = {1}, target = {2}", new Object[]{this.getClass().getName(), this.regID, this.target});
                }
                try {
                    if (this.target != null) {
                        mb.enableRegistration(this.regID, this.target);
                    } else if (RECOVERY_LOGGER.isLoggable(Levels.HANDLED)) {
                        RECOVERY_LOGGER.log(Levels.HANDLED, "{0} cancelled due to null target", this.getClass().getName());
                    }
                }
                catch (ThrowThis tt) {
                    if (!RECOVERY_LOGGER.isLoggable(Levels.HANDLED)) break block8;
                    RECOVERY_LOGGER.log(Levels.HANDLED, "{0} Null or expired registration entry", this.getClass().getName());
                }
            }
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(REGISTRATION_ENABLED_LOG_OBJ_SOURCE_CLASS, "apply");
            }
        }
    }

    private static class RegistrationLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private ServiceRegistration reg;

        public RegistrationLogObj(ServiceRegistration reg) {
            this.reg = reg;
        }

        @Override
        public void apply(MailboxImpl mb) {
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.entering(REGISTRATION_LOG_OBJ_SOURCE_CLASS, "apply", mb);
            }
            if (RECOVERY_LOGGER.isLoggable(Level.FINEST)) {
                RECOVERY_LOGGER.log(Level.FINEST, "Applying a {0}", this.getClass().getName());
                this.reg.dumpInfo(RECOVERY_LOGGER);
            }
            mb.addRegistration(this.reg);
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(REGISTRATION_LOG_OBJ_SOURCE_CLASS, "apply");
            }
        }
    }

    private static interface LogRecord
    extends Serializable {
        public void apply(MailboxImpl var1);
    }

    private class LocalLandlordAdaptor
    implements LocalLandlord {
        private LocalLandlordAdaptor() {
        }

        public long renew(Uuid cookie, long extension) throws LeaseDeniedException, UnknownLeaseException {
            return MailboxImpl.this.renewDo(cookie, extension);
        }

        public void cancel(Uuid cookie) throws UnknownLeaseException {
            MailboxImpl.this.cancelDo(cookie);
        }
    }

    private class ExpirationThread
    extends InterruptedStatusThread
    implements TimeConstants {
        public ExpirationThread() {
            super("ExpirationThread");
            this.setDaemon(false);
            if (EXPIRATION_LOGGER.isLoggable(Level.FINEST)) {
                EXPIRATION_LOGGER.log(Level.FINEST, "ExpirationThread started ...");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.entering(EXPIRATION_THREAD_SOURCE_CLASS, "run");
            }
            ServiceRegistration reg = null;
            long delay = 0L;
            try {
                MailboxImpl.this.concurrentObj.writeLock();
            }
            catch (ReadersWriter.ConcurrentLockException e) {
                return;
            }
            try {
                while (!this.hasBeenInterrupted()) {
                    long now = System.currentTimeMillis();
                    if (EXPIRATION_LOGGER.isLoggable(Level.FINEST)) {
                        EXPIRATION_LOGGER.log(Level.FINEST, "ExpirationThread checking regs @ {0}", new Date(now));
                    }
                    while (!MailboxImpl.this.regByExpiration.isEmpty()) {
                        reg = (ServiceRegistration)MailboxImpl.this.regByExpiration.firstKey();
                        MailboxImpl.this.minRegExpiration = reg.getExpiration();
                        if (EXPIRATION_LOGGER.isLoggable(Level.FINEST)) {
                            EXPIRATION_LOGGER.log(Level.FINEST, "ExpirationThread checking {0} which expires @ {1}", new Object[]{reg, new Date(MailboxImpl.this.minRegExpiration)});
                        }
                        if (MailboxImpl.this.minRegExpiration > now) break;
                        MailboxImpl.this.removeRegistration(reg.getCookie(), reg);
                        reg.getIteratorCondition().signal();
                        if (!EXPIRATION_LOGGER.isLoggable(Level.FINEST)) continue;
                        EXPIRATION_LOGGER.log(Level.FINEST, "Iterator notified");
                    }
                    try {
                        delay = MailboxImpl.this.minRegExpiration - now;
                        long l = delay = delay >= 0L ? delay : Long.MAX_VALUE;
                        if (EXPIRATION_LOGGER.isLoggable(Level.FINEST)) {
                            EXPIRATION_LOGGER.log(Level.FINEST, "ExpirationThread delayed until {0}", new Date(delay + now));
                        }
                        MailboxImpl.this.concurrentObj.writerWait(MailboxImpl.this.expirationNotifier, delay);
                    }
                    catch (ReadersWriter.ConcurrentLockException e) {
                        MailboxImpl.this.concurrentObj.writeUnlock();
                        if (EXPIRATION_LOGGER.isLoggable(Level.FINEST)) {
                            EXPIRATION_LOGGER.log(Level.FINEST, "ExpirationThread exiting ...");
                        }
                        return;
                    }
                }
            }
            finally {
                MailboxImpl.this.concurrentObj.writeUnlock();
                if (EXPIRATION_LOGGER.isLoggable(Level.FINEST)) {
                    EXPIRATION_LOGGER.log(Level.FINEST, "ExpirationThread exiting ...");
                }
            }
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(EXPIRATION_THREAD_SOURCE_CLASS, "run");
            }
        }
    }

    private class DestroyThread
    extends Thread {
        public DestroyThread() {
            super("DestroyThread");
            this.setDaemon(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.entering(DESTROY_THREAD_SOURCE_CLASS, "run");
            }
            Object object = MailboxImpl.this.destroyLock;
            synchronized (object) {
                block60: {
                    long now;
                    long endTime;
                    block57: {
                        if (MailboxImpl.this.destroySucceeded) {
                            if (ADMIN_LOGGER.isLoggable(Level.FINEST)) {
                                ADMIN_LOGGER.log(Level.FINEST, "DestroyThread skipped ...");
                            }
                            return;
                        }
                        if (MailboxImpl.this.activationPrepared) {
                            try {
                                MailboxImpl.this.activationSystem.unregisterObject(MailboxImpl.this.activationID);
                            }
                            catch (RemoteException e) {
                                if (ADMIN_LOGGER.isLoggable(Level.WARNING)) {
                                    ADMIN_LOGGER.log(Level.WARNING, "aborting shutdown - could not unregister activation ID", e);
                                }
                                return;
                            }
                            catch (ActivationException e) {
                                if (!ADMIN_LOGGER.isLoggable(Levels.HANDLED)) break block57;
                                ADMIN_LOGGER.log(Levels.HANDLED, "problem shutting down - could not unregister activation ID", e);
                            }
                        }
                    }
                    if ((endTime = (now = System.currentTimeMillis()) + MailboxImpl.this.maxUnexportDelay) < 0L) {
                        endTime = Long.MAX_VALUE;
                    }
                    boolean unexported = false;
                    while (!unexported && now < endTime) {
                        unexported = MailboxImpl.this.exporter.unexport(false);
                        if (!unexported) {
                            if (ADMIN_LOGGER.isLoggable(Level.FINEST)) {
                                ADMIN_LOGGER.log(Level.FINEST, "Waiting for in-progress calls to complete");
                            }
                            try {
                                long sleepTime = Math.min(MailboxImpl.this.unexportRetryDelay, endTime - now);
                                DestroyThread.sleep(sleepTime);
                                now = System.currentTimeMillis();
                                continue;
                            }
                            catch (InterruptedException ie) {
                                if (!ADMIN_LOGGER.isLoggable(Levels.HANDLED)) break;
                                ADMIN_LOGGER.log(Levels.HANDLED, "problem unexporting nicely", ie);
                                break;
                            }
                        }
                        if (!ADMIN_LOGGER.isLoggable(Level.FINEST)) continue;
                        ADMIN_LOGGER.log(Level.FINEST, "Unexport completed");
                    }
                    if (!unexported) {
                        MailboxImpl.this.exporter.unexport(true);
                        if (ADMIN_LOGGER.isLoggable(Level.FINEST)) {
                            ADMIN_LOGGER.log(Level.FINEST, "Forced unexport completed");
                        }
                    }
                    if (MailboxImpl.this.joiner != null) {
                        if (ADMIN_LOGGER.isLoggable(Level.FINEST)) {
                            ADMIN_LOGGER.log(Level.FINEST, "Terminating JoinManager ...");
                        }
                        MailboxImpl.this.joiner.terminate();
                        MailboxImpl.this.joiner = null;
                    }
                    if (MailboxImpl.this.lookupDiscMgr != null) {
                        if (ADMIN_LOGGER.isLoggable(Level.FINEST)) {
                            ADMIN_LOGGER.log(Level.FINEST, "Terminating lookupDiscMgr ...");
                        }
                        MailboxImpl.this.lookupDiscMgr.terminate();
                        MailboxImpl.this.lookupDiscMgr = null;
                    }
                    if (ADMIN_LOGGER.isLoggable(Level.FINEST)) {
                        ADMIN_LOGGER.log(Level.FINEST, "Interrupting Notifier ...");
                    }
                    MailboxImpl.this.notifier.interrupt();
                    if (ADMIN_LOGGER.isLoggable(Level.FINEST)) {
                        ADMIN_LOGGER.log(Level.FINEST, "Interrupting Expirer ...");
                    }
                    MailboxImpl.this.expirer.interrupt();
                    if (MailboxImpl.this.snapshotter != null) {
                        if (ADMIN_LOGGER.isLoggable(Level.FINEST)) {
                            ADMIN_LOGGER.log(Level.FINEST, "Interrupting Snapshotter ...");
                        }
                        MailboxImpl.this.snapshotter.interrupt();
                    }
                    try {
                        if (ADMIN_LOGGER.isLoggable(Level.FINEST)) {
                            ADMIN_LOGGER.log(Level.FINEST, "Waiting for Notifier ...");
                        }
                        MailboxImpl.this.notifier.join();
                        if (ADMIN_LOGGER.isLoggable(Level.FINEST)) {
                            ADMIN_LOGGER.log(Level.FINEST, "Waiting for Expirer ...");
                        }
                        MailboxImpl.this.expirer.join();
                        if (MailboxImpl.this.snapshotter != null) {
                            if (ADMIN_LOGGER.isLoggable(Level.FINEST)) {
                                ADMIN_LOGGER.log(Level.FINEST, "Waiting for Snapshotter ...");
                            }
                            MailboxImpl.this.snapshotter.join();
                        }
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    MailboxImpl.this.concurrentObj.writeLock();
                    try {
                        ServiceRegistration[] regs = MailboxImpl.this.regByID.values().toArray(new ServiceRegistration[MailboxImpl.this.regByID.size()]);
                        EventLogIterator logIter = null;
                        if (ADMIN_LOGGER.isLoggable(Level.FINEST)) {
                            ADMIN_LOGGER.log(Level.FINEST, "Destroying {0} registration storage locations", MailboxImpl.this.regByID.size());
                        }
                        for (int i = 0; i < regs.length; ++i) {
                            block58: {
                                try {
                                    if (PERSISTENCE_LOGGER.isLoggable(Level.FINEST)) {
                                        PERSISTENCE_LOGGER.log(Level.FINEST, "Destroying logs for -> {0}", regs[i]);
                                    }
                                    MailboxImpl.this.regByID.remove(regs[i].getCookie());
                                    logIter = regs[i].iterator();
                                    if (logIter != null) {
                                        logIter.destroy();
                                    }
                                }
                                catch (IOException ioe) {
                                    if (PERSISTENCE_LOGGER.isLoggable(Levels.HANDLED)) {
                                        PERSISTENCE_LOGGER.log(Levels.HANDLED, "Destroy unsuccessful.", ioe);
                                    }
                                }
                                catch (Exception de) {
                                    if (!PERSISTENCE_LOGGER.isLoggable(Levels.HANDLED)) break block58;
                                    PERSISTENCE_LOGGER.log(Levels.HANDLED, "Destroy unsuccessful", de);
                                }
                            }
                            regs[i].getIteratorCondition().signal();
                            if (!EXPIRATION_LOGGER.isLoggable(Level.FINEST)) continue;
                            EXPIRATION_LOGGER.log(Level.FINEST, "Iterator notified");
                        }
                    }
                    finally {
                        MailboxImpl.this.concurrentObj.writeUnlock();
                    }
                    if (MailboxImpl.this.log != null) {
                        MailboxImpl.this.log.deletePersistentStore();
                    }
                    if (MailboxImpl.this.activationID != null) {
                        ActivationGroupID gid = ActivationGroup.currentGroupID();
                        try {
                            Activatable.inactive((ActivationID)MailboxImpl.this.activationID);
                        }
                        catch (RemoteException remoteException) {
                        }
                        catch (ActivationException activationException) {}
                    } else if (MailboxImpl.this.lifeCycle != null) {
                        MailboxImpl.this.lifeCycle.unregister((Object)MailboxImpl.this);
                    }
                    if (MailboxImpl.this.loginContext != null) {
                        try {
                            if (ADMIN_LOGGER.isLoggable(Level.FINEST)) {
                                ADMIN_LOGGER.log(Level.FINEST, "Logging out");
                            }
                            MailboxImpl.this.loginContext.logout();
                        }
                        catch (Exception e) {
                            if (!ADMIN_LOGGER.isLoggable(Levels.HANDLED)) break block60;
                            ADMIN_LOGGER.log(Levels.HANDLED, "Exception while logging out", e);
                        }
                    }
                }
                if (ADMIN_LOGGER.isLoggable(Level.FINEST)) {
                    ADMIN_LOGGER.log(Level.FINEST, "DestroyThread finished ...");
                }
                MailboxImpl.this.destroySucceeded = true;
                MailboxImpl.this.readyState.shutdown();
            }
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(DESTROY_THREAD_SOURCE_CLASS, "run");
            }
        }
    }

    private static class NotifyListener
    implements PrivilegedExceptionAction {
        private final RemoteEventListener listener;
        private final RemoteEvent event;

        public NotifyListener(RemoteEventListener listener, RemoteEvent event) {
            this.listener = listener;
            this.event = event;
        }

        public Object run() throws Exception {
            this.listener.notify(this.event);
            return null;
        }
    }

    class NotifyTask
    extends RetryTask {
        private Uuid regID;

        NotifyTask(ExecutorService tm, WakeupManager mgr, Uuid regID) {
            super(tm, mgr);
            this.regID = regID;
        }

        private RemoteEvent getNextEvent(ServiceRegistration reg) {
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.entering(NOTIFY_TASK_SOURCE_CLASS, "getNextEvent", reg);
            }
            RemoteEvent evt = null;
            try {
                if (reg.iterator().hasNext()) {
                    try {
                        evt = reg.iterator().next();
                    }
                    catch (IOException iOException) {
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(NOTIFY_TASK_SOURCE_CLASS, "getNextEvent", evt);
            }
            return evt;
        }

        private void deleteNextEvent(ServiceRegistration reg) {
            block8: {
                if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                    OPERATIONS_LOGGER.entering(NOTIFY_TASK_SOURCE_CLASS, "deleteNextEvent", reg);
                }
                try {
                    if (reg.iterator().hasNext()) {
                        try {
                            reg.iterator().remove();
                        }
                        catch (IOException ioe) {
                            if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                                DELIVERY_LOGGER.log(Level.FINEST, "NotifyTask could not deleteNextEvent for reg: {0}", reg);
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    if (!DELIVERY_LOGGER.isLoggable(Level.FINEST)) break block8;
                    DELIVERY_LOGGER.log(Level.FINEST, "NotifyTask could not delete event because state info for {0} was inaccessible", reg);
                }
            }
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(NOTIFY_TASK_SOURCE_CLASS, "deleteNextEvent");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean disableRegistration(Uuid regID, RemoteEventListener l) {
            boolean disabled;
            block9: {
                if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                    OPERATIONS_LOGGER.entering(NOTIFY_TASK_SOURCE_CLASS, "disableRegistration", new Object[]{regID, l});
                }
                disabled = true;
                MailboxImpl.this.concurrentObj.writeLock();
                try {
                    try {
                        ServiceRegistration reg = MailboxImpl.this.getServiceRegistration(regID);
                        RemoteEventListener currentListener = reg.getEventTarget();
                        if (currentListener == l) {
                            MailboxImpl.this.disableDeliveryDo(regID);
                            break block9;
                        }
                        if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                            DELIVERY_LOGGER.log(Level.FINEST, "Disabling registration for {0} skipped due to listener change.", regID);
                        }
                        disabled = false;
                    }
                    catch (ThrowThis throwThis) {
                        // empty catch block
                    }
                }
                finally {
                    MailboxImpl.this.concurrentObj.writeUnlock();
                }
            }
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(NOTIFY_TASK_SOURCE_CLASS, "disableRegistration", disabled);
            }
            return disabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryOnce() {
            long curTime;
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.entering(NOTIFY_TASK_SOURCE_CLASS, "tryOnce");
            }
            boolean succeeded = false;
            boolean deleteEvent = false;
            boolean doNotify = true;
            ServiceRegistration reg = null;
            RemoteEventListener listener = null;
            RemoteEvent ev = null;
            if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                DELIVERY_LOGGER.log(Level.FINEST, "Attempting event delivery for: {0} at {1}", new Object[]{this.regID, new Date(System.currentTimeMillis())});
            }
            if ((curTime = System.currentTimeMillis()) - this.startTime() > 3600000L) {
                succeeded = true;
                deleteEvent = false;
                doNotify = false;
                if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                    DELIVERY_LOGGER.log(Level.FINEST, "Cancelling delivery due to time limit expiration.");
                }
            } else {
                MailboxImpl.this.concurrentObj.readLock();
                try {
                    try {
                        reg = MailboxImpl.this.getServiceRegistration(this.regID);
                        listener = reg.getEventTarget();
                        ev = this.getNextEvent(reg);
                        if (listener == null) {
                            succeeded = true;
                            deleteEvent = false;
                            doNotify = false;
                            if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                                DELIVERY_LOGGER.log(Level.FINEST, "Cancelling delivery because of disabled listener");
                            }
                        } else if (ev == null) {
                            succeeded = true;
                            deleteEvent = false;
                            doNotify = false;
                            if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                                DELIVERY_LOGGER.log(Level.FINEST, "Cancelling delivery because of null event");
                            }
                        } else if (reg.getUnknownEvents().containsKey(new EventID(ev))) {
                            succeeded = true;
                            deleteEvent = true;
                            doNotify = false;
                            if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                                DELIVERY_LOGGER.log(Level.FINEST, "Cancelling delivery because of unknown event");
                            }
                        }
                    }
                    catch (ThrowThis tt) {
                        succeeded = true;
                        deleteEvent = false;
                        doNotify = false;
                        if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                            DELIVERY_LOGGER.log(Level.FINEST, "Cancelling delivery because of unknown registration");
                        }
                    }
                }
                finally {
                    MailboxImpl.this.concurrentObj.readUnlock();
                }
            }
            if (doNotify) {
                if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                    DELIVERY_LOGGER.log(Level.FINEST, "Delivering evt: {0}, ID {1}, Seq# {2}", new Object[]{ev, ev.getID(), ev.getSequenceNumber()});
                }
                try {
                    try {
                        AccessController.doPrivileged(new NotifyListener(listener, ev), MailboxImpl.this.context);
                    }
                    catch (PrivilegedActionException e) {
                        throw e.getException();
                    }
                    succeeded = true;
                    deleteEvent = true;
                    if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                        DELIVERY_LOGGER.log(Level.FINEST, "Delivery was successful");
                    }
                }
                catch (UnknownEventException e) {
                    if (DELIVERY_LOGGER.isLoggable(Levels.HANDLED)) {
                        DELIVERY_LOGGER.log(Levels.HANDLED, "Caught UnknownEventException during notify");
                    }
                    MailboxImpl.this.addUnknownEvent(this.regID, new EventID(ev));
                    succeeded = true;
                    deleteEvent = true;
                }
                catch (Throwable t) {
                    int cat = ThrowableConstants.retryable((Throwable)t);
                    if (cat == 2) {
                        if (DELIVERY_LOGGER.isLoggable(Levels.HANDLED)) {
                            DELIVERY_LOGGER.log(Levels.HANDLED, "Caught a BAD_OBJECT exception during notify", t);
                        }
                        this.disableRegistration(this.regID, listener);
                        succeeded = true;
                        deleteEvent = false;
                    }
                    if (cat == 0) {
                        if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                            DELIVERY_LOGGER.log(Level.FINEST, "Caught an INDEFINITE exception during notify", t);
                        }
                        succeeded = false;
                        deleteEvent = false;
                    }
                    if (cat == 1) {
                        if (DELIVERY_LOGGER.isLoggable(Levels.HANDLED)) {
                            DELIVERY_LOGGER.log(Levels.HANDLED, "Caught a BAD_INVOCATION exception during notify", t);
                        }
                        succeeded = true;
                        deleteEvent = true;
                    }
                    if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                        DELIVERY_LOGGER.log(Level.FINEST, "Caught an uncategorized exception during notify", t);
                    }
                    succeeded = false;
                    deleteEvent = false;
                }
            }
            if (!succeeded && this.attempt() > 5) {
                if (DELIVERY_LOGGER.isLoggable(Levels.HANDLED)) {
                    DELIVERY_LOGGER.log(Levels.HANDLED, "Maximum delivery attempts reached");
                }
                succeeded = true;
                deleteEvent = true;
            }
            if (succeeded || deleteEvent) {
                MailboxImpl.this.concurrentObj.writeLock();
                try {
                    try {
                        reg = MailboxImpl.this.getServiceRegistration(this.regID);
                        if (succeeded) {
                            if (reg.hasEventTarget()) {
                                if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                                    DELIVERY_LOGGER.log(Level.FINEST, "Putting task back onto pending list");
                                }
                                MailboxImpl.this.activeReg.remove(this.regID);
                                MailboxImpl.this.pendingReg.add(this.regID);
                            } else {
                                if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                                    DELIVERY_LOGGER.log(Level.FINEST, "Removing task ...");
                                }
                                if ((MailboxImpl.this.activeReg.remove(this.regID) != null || MailboxImpl.this.pendingReg.remove(this.regID)) && DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                                    DELIVERY_LOGGER.log(Level.FINEST, "ERROR: Found pending/active task for a disabled registration");
                                }
                            }
                        }
                        if (deleteEvent) {
                            if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                                DELIVERY_LOGGER.log(Level.FINEST, "Deleting event ...");
                            }
                            this.deleteNextEvent(reg);
                        }
                    }
                    catch (ThrowThis throwThis) {
                        // empty catch block
                    }
                    if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                        DELIVERY_LOGGER.log(Level.FINEST, "Waking up notifier");
                    }
                    MailboxImpl.this.concurrentObj.waiterNotify(MailboxImpl.this.eventNotifier);
                }
                finally {
                    MailboxImpl.this.concurrentObj.writeUnlock();
                }
            }
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(NOTIFY_TASK_SOURCE_CLASS, "tryOnce", succeeded);
            }
            return succeeded;
        }
    }

    private class Notifier
    extends InterruptedStatusThread
    implements TimeConstants {
        private final ExecutorService taskManager;
        private final WakeupManager wakeupMgr;
        private final Random rand;
        private static final long PAUSE_TIME = 5000L;

        Notifier(Configuration config) throws ConfigurationException {
            super("Notifier");
            this.wakeupMgr = new WakeupManager(new WakeupManager.ThreadDesc(null, true));
            this.rand = new Random(System.currentTimeMillis());
            this.taskManager = (ExecutorService)Config.getNonNullEntry((Configuration)config, (String)MailboxImpl.MERCURY, (String)"notificationsExecutorService", ExecutorService.class, (Object)new ThreadPoolExecutor(10, 10, 15L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("EventTypeGenerator", false)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.entering(NOTIFIER_SOURCE_CLASS, "run");
            }
            try {
                MailboxImpl.this.concurrentObj.writeLock();
            }
            catch (ReadersWriter.ConcurrentLockException e) {
                return;
            }
            try {
                while (!this.hasBeenInterrupted()) {
                    int count = MailboxImpl.this.pendingReg.size();
                    if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                        DELIVERY_LOGGER.log(Level.FINEST, "Notifier checking {0} possible registrations", count);
                    }
                    while (count-- > 0) {
                        int index = this.rand.nextInt(MailboxImpl.this.pendingReg.size());
                        Uuid uuid = (Uuid)MailboxImpl.this.pendingReg.get(index);
                        ServiceRegistration reg = null;
                        try {
                            reg = MailboxImpl.this.getServiceRegistration(uuid);
                            if (!reg.iterator().hasNext()) continue;
                            if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                                DELIVERY_LOGGER.log(Level.FINEST, "Scheduling delivery task for reg: {0} ", reg);
                            }
                            NotifyTask t = new NotifyTask(this.taskManager, this.wakeupMgr, uuid);
                            this.taskManager.execute((Runnable)((Object)t));
                            MailboxImpl.this.activeReg.put(uuid, t);
                            MailboxImpl.this.pendingReg.remove(index);
                        }
                        catch (ThrowThis tt) {
                            if (!DELIVERY_LOGGER.isLoggable(Level.FINEST)) continue;
                            DELIVERY_LOGGER.log(Level.FINEST, "Notifier: invalid registration for {0}", uuid);
                        }
                        catch (IOException ioe) {
                            if (!DELIVERY_LOGGER.isLoggable(Level.FINEST)) continue;
                            DELIVERY_LOGGER.log(Level.FINEST, "Notifier: inaccessible registration data for {0}", uuid);
                        }
                    }
                    try {
                        if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                            DELIVERY_LOGGER.log(Level.FINEST, "Notifier: delayed until {0}", new Date(5000L + System.currentTimeMillis()));
                        }
                        MailboxImpl.this.concurrentObj.writerWait(MailboxImpl.this.eventNotifier, 5000L);
                    }
                    catch (ReadersWriter.ConcurrentLockException e) {
                        MailboxImpl.this.concurrentObj.writeUnlock();
                        if (this.hasBeenInterrupted()) {
                            if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                                DELIVERY_LOGGER.log(Level.FINEST, "Notifier: terminating taskManager");
                            }
                            this.wakeupMgr.stop();
                            this.wakeupMgr.cancelAll();
                            this.taskManager.shutdownNow();
                        }
                        if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                            DELIVERY_LOGGER.log(Level.FINEST, " Notifier: exiting ...");
                        }
                        return;
                    }
                }
            }
            finally {
                MailboxImpl.this.concurrentObj.writeUnlock();
                if (this.hasBeenInterrupted()) {
                    if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                        DELIVERY_LOGGER.log(Level.FINEST, "Notifier: terminating taskManager");
                    }
                    this.wakeupMgr.stop();
                    this.wakeupMgr.cancelAll();
                    this.taskManager.shutdownNow();
                }
                if (DELIVERY_LOGGER.isLoggable(Level.FINEST)) {
                    DELIVERY_LOGGER.log(Level.FINEST, " Notifier: exiting ...");
                }
            }
            if (OPERATIONS_LOGGER.isLoggable(Level.FINER)) {
                OPERATIONS_LOGGER.exiting(NOTIFIER_SOURCE_CLASS, "run");
            }
        }
    }
}

