/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.mercury;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.SyncFailedException;
import org.apache.river.mercury.LogStream;
import org.apache.river.mercury.StreamKey;

class LogOutputStream
extends OutputStream
implements LogStream {
    private static final int BUFSIZE = 1024;
    private byte[] buf = new byte[1024];
    private int pos = 0;
    private long offset = 0L;
    private FileOutputStream out;
    private StreamKey key;

    public LogOutputStream(File file, StreamKey key, boolean append) throws FileNotFoundException {
        if (file == null || key == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this.out = new FileOutputStream(file.getPath(), append);
        if (append) {
            this.offset = file.length();
        }
        this.key = key;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.pos >= 1024) {
            this.drain();
        }
        this.buf[this.pos++] = (byte)b;
        ++this.offset;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.pos + len >= 1024) {
            this.drain();
        }
        if (len >= 1024) {
            this.out.write(b, off, len);
        } else {
            System.arraycopy(b, off, this.buf, this.pos, len);
            this.pos += len;
        }
        this.offset += (long)len;
    }

    @Override
    public void flush() throws IOException {
        this.drain();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    long getOffset() {
        return this.offset;
    }

    void sync() throws IOException, SyncFailedException {
        this.out.getFD().sync();
    }

    void drain() throws IOException {
        if (this.pos > 0) {
            this.out.write(this.buf, 0, this.pos);
        }
        this.pos = 0;
    }

    @Override
    public Object getKey() {
        return this.key;
    }
}

