/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.mercury;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.river.mercury.LogStream;
import org.apache.river.mercury.StreamKey;

class LogInputStream
extends InputStream
implements LogStream {
    private static final int BUFSIZE = 1024;
    private byte[] buf = new byte[1024];
    private int count = 0;
    private int pos = 0;
    private long offset = 0L;
    private FileInputStream in;
    private StreamKey key;

    public LogInputStream(File file, StreamKey key) throws FileNotFoundException {
        if (file == null || key == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this.in = new FileInputStream(file);
        this.key = key;
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.count) {
            this.refill();
        }
        if (this.count < 0) {
            return -1;
        }
        ++this.offset;
        return this.buf[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.pos >= this.count) {
            this.refill();
        }
        if (this.count < 0) {
            return -1;
        }
        int rlen = Math.min(len, this.count - this.pos);
        System.arraycopy(this.buf, this.pos, b, off, rlen);
        this.pos += rlen;
        this.offset += (long)rlen;
        return rlen;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.count < 0) {
            return 0L;
        }
        int slen = (int)Math.min(n, (long)(this.count - this.pos));
        this.pos += slen;
        if ((n -= (long)slen) > 0L) {
            slen = (int)((long)slen + this.in.skip(n));
        }
        this.offset += (long)slen;
        return slen;
    }

    @Override
    public int available() throws IOException {
        return this.count >= 0 ? this.count - this.pos + this.in.available() : 0;
    }

    @Override
    public void close() throws IOException {
        this.count = -1;
        this.in.close();
    }

    public long getOffset() {
        return this.offset;
    }

    private void refill() throws IOException {
        if (this.count < 0) {
            return;
        }
        this.pos = 0;
        do {
            this.count = this.in.read(this.buf);
        } while (this.count == 0);
    }

    @Override
    public Object getKey() {
        return this.key;
    }
}

