/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.mercury;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.rmi.MarshalledObject;
import net.jini.core.event.RemoteEvent;
import net.jini.io.MarshalledInstance;
import org.apache.river.mercury.LogOutputStream;

class EventWriter {
    private EventOutputStream eout;
    private SwitchOutputStream sout = new SwitchOutputStream(null);

    public EventWriter() throws IOException {
        this.eout = new EventOutputStream(this.sout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(RemoteEvent ev, LogOutputStream out) throws IOException, SyncFailedException {
        this.sout.setOutputStream(out);
        try {
            MarshalledObject mo = new MarshalledInstance((Object)ev).convertToMarshalledObject();
            this.eout.reset();
            this.eout.writeObject(mo);
            this.eout.flush();
            out.sync();
        }
        finally {
            this.sout.setOutputStream(null);
        }
    }

    private static class SwitchOutputStream
    extends OutputStream {
        private LogOutputStream out;

        public SwitchOutputStream(LogOutputStream out) {
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        public void setOutputStream(LogOutputStream out) {
            this.out = out;
        }
    }

    private static class EventOutputStream
    extends ObjectOutputStream {
        public EventOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        protected void writeStreamHeader() throws IOException {
        }
    }
}

