/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.mercury;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import net.jini.core.event.RemoteEvent;
import net.jini.io.MarshalledInstance;
import org.apache.river.api.io.AtomicSerial;

@AtomicSerial
class EventID
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Object source = null;
    private final long id;

    public EventID(AtomicSerial.GetArg arg) throws IOException {
        this(null, arg.get("id", 0L), EventID.check(((RO)arg.getReader()).source, "Null source read from stream"));
    }

    public EventID(Object source, long id) {
        this(null, id, EventID.check(source, "Source argument must be non-null"));
    }

    public EventID(RemoteEvent evt) {
        this(EventID.check(evt, "RemoteEvent argument must be non-null"), evt.getID(), EventID.check(evt.getSource(), "Source argument must be non-null"));
    }

    private static <T> T check(T nullCheck, String message) {
        if (nullCheck == null) {
            throw new IllegalArgumentException(message);
        }
        return nullCheck;
    }

    private EventID(Object check, long id, Object source) {
        this.source = source;
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        EventID eid = (EventID)o;
        return this.source.equals(eid.source) && this.id == eid.id;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public String toString() {
        return this.getClass().getName() + "[source=" + this.source + "][id=" + this.id + "]";
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(new MarshalledInstance(this.source).convertToMarshalledObject());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        block2: {
            stream.defaultReadObject();
            MarshalledObject mo = (MarshalledObject)stream.readObject();
            try {
                this.source = new MarshalledInstance(mo).get(false);
            }
            catch (Throwable e) {
                if (!(e instanceof Error) || e instanceof LinkageError || e instanceof OutOfMemoryError || e instanceof StackOverflowError) break block2;
                throw (Error)e;
            }
        }
    }

    private static class RO
    implements AtomicSerial.ReadObject {
        Object source;

        private RO() {
        }

        public void read(ObjectInput stream) throws IOException, ClassNotFoundException {
            block2: {
                MarshalledObject mo = (MarshalledObject)stream.readObject();
                try {
                    this.source = new MarshalledInstance(mo).get(false);
                }
                catch (Throwable e) {
                    if (!(e instanceof Error) || e instanceof LinkageError || e instanceof OutOfMemoryError || e instanceof StackOverflowError) break block2;
                    throw (Error)e;
                }
            }
        }
    }
}

