/*
 * Decompiled with CFR 0.152.
 */
package au.net.causal.projo.prefs.truevfs;

import au.net.causal.projo.prefs.PreferencesException;
import au.net.causal.projo.prefs.ProjoStoreBuilder;
import au.net.causal.projo.prefs.StandardTransformPhase;
import au.net.causal.projo.prefs.TransformPhase;
import au.net.causal.projo.prefs.transform.PathToStringTransformer;
import au.net.causal.projo.prefs.transform.PreferenceTransformer;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.java.truevfs.access.TPath;

public class TrueVfsPathToStringTransformer
extends PathToStringTransformer {
    public static void configureBuilder(ProjoStoreBuilder builder) {
        builder.replaceTransformer(PathToStringTransformer.class, (PreferenceTransformer)new TrueVfsPathToStringTransformer(), (TransformPhase)StandardTransformPhase.DATATYPE);
    }

    private boolean isWindowsNetworkPath(String s) {
        return s.startsWith("\\\\");
    }

    protected String pathToStringForSpecialFileSystem(Path path) throws PreferencesException {
        if (path instanceof TPath) {
            return path.toString();
        }
        return null;
    }

    protected Path stringToPathForSpecialFileSystem(String s) throws PreferencesException {
        if (this.isWindowsNetworkPath(s)) {
            return Paths.get(s, new String[0]);
        }
        TPath tPath = new TPath(s, new String[0]);
        return tPath;
    }
}

