/*
 * Decompiled with CFR 0.152.
 */
package au.id.simo.dbversion.xml;

import au.id.simo.dbversion.Task;
import au.id.simo.dbversion.TaskListBuilder;
import au.id.simo.dbversion.common.xml.Element;
import au.id.simo.dbversion.common.xml.Sax2DomHandler;
import au.id.simo.dbversion.xml.ClassTaskTagProcessor;
import au.id.simo.dbversion.xml.SQLTaskTagProcessor;
import au.id.simo.dbversion.xml.TagProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLTaskListBuilder
implements TaskListBuilder {
    private static final String LOAD_TAG = "loadTagProcessor";
    private Map<String, TagProcessor> tagProccessorMap = new TreeMap<String, TagProcessor>();
    private List<Task> taskList = new LinkedList<Task>();

    public XMLTaskListBuilder() {
        this.addTagProcessor(new ClassTaskTagProcessor());
        this.addTagProcessor(new SQLTaskTagProcessor());
    }

    public void setClassTaskClassLoader(ClassLoader classLoader) {
        ClassTaskTagProcessor tp = (ClassTaskTagProcessor)this.getTagProcessor("classTask");
        tp.setClassLoader(classLoader);
    }

    public TagProcessor addTagProcessor(TagProcessor tp) {
        return this.tagProccessorMap.put(tp.getTagName(), tp);
    }

    protected TagProcessor getTagProcessor(String name) {
        return this.tagProccessorMap.get(name);
    }

    public void loadTaskList(InputStream in) throws IOException {
        Element docroot = this.parseXML(in);
        Iterator itr = docroot.getElementIterator();
        while (itr.hasNext()) {
            Element taskElement = (Element)itr.next();
            if (LOAD_TAG.equals(taskElement.getName())) {
                this.loadTagProccessor(taskElement);
                continue;
            }
            TagProcessor tp = this.getTagProcessor(taskElement.getName());
            if (tp == null) {
                System.err.println("Unknown Task Tag: " + taskElement.getName());
                continue;
            }
            try {
                Task task = tp.createTask(taskElement);
                this.taskList.add(task);
            }
            catch (Throwable t) {
                System.err.println("Unable to load Task: " + t.getMessage());
            }
        }
    }

    private void loadTagProccessor(Element taskElement) {
        try {
            Class<TagProcessor> tpClass = this.getClass().getClassLoader().loadClass(taskElement.getText().trim());
            if (tpClass.isAssignableFrom(TagProcessor.class)) {
                this.addTagProcessor((TagProcessor)tpClass.newInstance());
            }
        }
        catch (Throwable t) {
            System.err.println("Unable to load TagProcessor: " + t.getClass().getName() + ": " + t.getMessage());
        }
    }

    private Element parseXML(InputStream in) throws IOException {
        try {
            SAXParser sp = SAXParserFactory.newInstance().newSAXParser();
            Sax2DomHandler s2dh = new Sax2DomHandler();
            sp.parse(in, (DefaultHandler)s2dh);
            return s2dh.getElementTree();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public List<Task> getTaskList() {
        return this.taskList;
    }
}

