/*
 * Decompiled with CFR 0.152.
 */
package au.id.simo.dbversion.xml;

import au.id.simo.dbversion.Task;
import au.id.simo.dbversion.common.xml.Element;
import au.id.simo.dbversion.xml.TagProcessor;
import java.util.Iterator;

public class ClassTaskTagProcessor
implements TagProcessor {
    protected static final String TAG_NAME = "classTask";
    private static final String CLASS_TAG_NAME = "class";
    private ClassLoader classLoader = ClassTaskTagProcessor.class.getClassLoader();

    public String getTagName() {
        return TAG_NAME;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Task createTask(Element taskRoot) {
        Iterator itr = taskRoot.getElementIterator();
        while (itr.hasNext()) {
            Element e = (Element)itr.next();
            if (!e.getName().equals(CLASS_TAG_NAME)) continue;
            try {
                Class<Task> taskClass = this.classLoader.loadClass(e.getText());
                if (!taskClass.isAssignableFrom(Task.class)) continue;
                return (Task)taskClass.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new Error(cnfe);
            }
            catch (IllegalAccessException e1) {
                throw new Error(e1);
            }
            catch (InstantiationException e1) {
                throw new Error(e1);
            }
        }
        throw new Error("Missing 'class' tag");
    }
}

