/*
 * Decompiled with CFR 0.152.
 */
package au.id.simo.dbversion.common.xml;

import au.id.simo.dbversion.common.xml.Element;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Sax2DomHandler
extends DefaultHandler {
    protected Element root;
    private Element currele;
    protected Stack<Element> stack = new Stack();

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currele = new Element(qName);
        int atts = attributes.getLength();
        for (int i = 0; i < atts; ++i) {
            this.currele.addAttribute(attributes.getQName(i), attributes.getValue(i));
        }
        if (this.stack.isEmpty()) {
            this.root = this.currele;
        } else {
            this.stack.peek().addElement(this.currele);
        }
        this.stack.push(this.currele);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.currele = this.currele.getParent();
        this.stack.pop();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currele.appendText(new String(ch, start, length));
    }

    public void endDocument() throws SAXException {
    }

    public Element getElementTree() {
        return this.root;
    }

    public void printElements(Element e) {
        System.out.print("<" + e.getName() + ">" + e.getText());
        for (Element element : e.getElementList()) {
            this.printElements(element);
        }
        System.out.print("</" + e.getName() + ">");
    }
}

