/*
 * Decompiled with CFR 0.152.
 */
package au.id.simo.dbversion.common.xml;

import au.id.simo.dbversion.common.xml.Element;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Set;

public class ElementRenderer {
    private static final String STD_HEADER = "<?xml version=\"1.0\"?>";
    private Element elementRoot;
    private boolean humanReadable;
    private String padString;

    public ElementRenderer(Element root) {
        this.elementRoot = root;
        this.humanReadable = true;
        this.padString = "\t";
    }

    public Element getElementRoot() {
        return this.elementRoot;
    }

    public void setElementRoot(Element elementRoot) {
        this.elementRoot = elementRoot;
    }

    public boolean isHumanReadable() {
        return this.humanReadable;
    }

    public void setHumanReadable(boolean humanReadable) {
        this.humanReadable = humanReadable;
    }

    public String getPadString() {
        return this.padString;
    }

    public void setPadString(String padString) {
        this.padString = padString;
    }

    public void renderElement(PrintStream output) {
        this.printHeader(output);
        this.renderElement(this.elementRoot, output, 0);
    }

    private void printHeader(PrintStream out) {
        out.println(STD_HEADER);
    }

    private void renderElement(Element element, PrintStream out, int depth) {
        this.renderIndentPadding(out, depth);
        out.print("<");
        out.print(element.getName());
        Set<String> attSet = element.getAttributeKeys();
        if (!attSet.isEmpty()) {
            out.print(' ');
            for (String key : attSet) {
                this.renderAttribute(out, key, element.getAttribute(key));
            }
        }
        out.print('>');
        if (element.hasNonWhiteSpaceText()) {
            out.print(element.getText());
        } else if (this.isHumanReadable()) {
            out.println();
        }
        Iterator itr = element.getElementIterator();
        while (itr.hasNext()) {
            this.renderElement((Element)itr.next(), out, depth + 1);
        }
        if (!element.hasNonWhiteSpaceText()) {
            this.renderIndentPadding(out, depth);
        }
        out.print("</");
        out.print(element.getName());
        out.print('>');
        if (this.isHumanReadable()) {
            out.println();
        }
    }

    private void renderIndentPadding(PrintStream out, int depth) {
        for (int i = 0; i < depth && this.isHumanReadable(); ++i) {
            out.print(this.padString);
        }
    }

    private void renderAttribute(PrintStream out, String name, String value) {
        out.print(name);
        out.print('=');
        out.print('\"');
        out.print(value);
        out.print('\"');
        out.print(' ');
    }
}

