/*
 * Decompiled with CFR 0.152.
 */
package au.id.simo.dbversion.common;

import java.util.StringTokenizer;

public class Version
implements Comparable {
    private int major;
    private int minor;
    private int patch;

    public Version() {
    }

    public Version(String version) {
        StringTokenizer tok = new StringTokenizer(version, ".");
        this.major = Integer.parseInt(tok.nextToken());
        this.minor = Integer.parseInt(tok.nextToken());
        this.patch = Integer.parseInt(tok.nextToken());
    }

    public Version(int major, int minor, int patch) {
        this.patch = patch;
        this.minor = minor;
        this.major = major;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public void setPatch(int patch) {
        this.patch = patch;
    }

    public int compareTo(Object o) {
        Version v = (Version)o;
        if (this.compareMajorTo(v) > 0) {
            return -1;
        }
        if (this.compareMajorTo(v) < 0) {
            return 1;
        }
        if (this.compareMinorTo(v) > 0) {
            return -1;
        }
        if (this.compareMinorTo(v) < 0) {
            return 1;
        }
        if (this.comparePatchTo(v) > 0) {
            return -1;
        }
        if (this.comparePatchTo(v) < 0) {
            return 1;
        }
        return 0;
    }

    public int compareMajorTo(Version v) {
        if (v.getMajor() > this.getMajor()) {
            return 1;
        }
        if (v.getMajor() == this.getMajor()) {
            return 0;
        }
        return -1;
    }

    public int compareMinorTo(Version v) {
        if (v.getMinor() > this.getMinor()) {
            return 1;
        }
        if (v.getMinor() == this.getMinor()) {
            return 0;
        }
        return -1;
    }

    public int comparePatchTo(Version v) {
        if (v.getPatch() > this.getPatch()) {
            return 1;
        }
        if (v.getPatch() == this.getPatch()) {
            return 0;
        }
        return -1;
    }

    public boolean newer(Version version) {
        return this.compareTo(version) > 0;
    }

    public boolean newerOrEqualTo(Version version) {
        return this.compareTo(version) >= 0;
    }

    public boolean older(Version version) {
        return this.compareTo(version) < 0;
    }

    public boolean olderOrEqualTo(Version version) {
        return this.compareTo(version) <= 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version v = (Version)obj;
        return this.compareTo(v) == 0;
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + this.major;
        hash = 71 * hash + this.minor;
        hash = 71 * hash + this.patch;
        return hash;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }
}

