/*
 * Decompiled with CFR 0.152.
 */
package au.id.simo.dbversion;

import au.id.simo.dbversion.DatabaseType;
import au.id.simo.dbversion.Target;
import au.id.simo.dbversion.Task;
import au.id.simo.dbversion.common.Version;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBVersionManager {
    private static final String DEFAULT_TABLE = "DBVersionTasks";
    private String schema;
    private String tableName;

    public String getTableName() {
        if (this.tableName == null) {
            return DEFAULT_TABLE;
        }
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getTableNameWithSchema() {
        if (this.getSchema() == null) {
            return this.getTableName();
        }
        return this.getSchema() + "." + this.getTableName();
    }

    public void ensureUptoDate(List<Task> tasklist, Connection con) throws SQLException {
        Version largestVersion = this.getLargestVersionInList(tasklist);
        this.executeUpgrade(null, largestVersion, tasklist, con);
    }

    public void ensureUptoDate(Target target, List<Task> tasklist, Connection con) throws SQLException {
        Version largestVersion = this.getLargestVersionInList(tasklist);
        this.executeUpgrade(target, largestVersion, tasklist, con);
    }

    public Version getCurrentVersion(Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("select distinct version from " + this.getTableNameWithSchema());
        ArrayList<Version> versionList = new ArrayList<Version>();
        while (rs.next()) {
            Version tempVersion = new Version(rs.getString(1));
            versionList.add(tempVersion);
        }
        rs.close();
        stmt.close();
        Collections.sort(versionList);
        if (versionList.size() > 0) {
            return (Version)versionList.get(versionList.size() - 1);
        }
        return new Version(0, 0, 0);
    }

    private Version getLargestVersionInList(List<Task> tasklist) {
        Version largestVersion = new Version(0, 0, 0);
        for (Task task : tasklist) {
            Version taskVer = task.getVersion();
            if (taskVer == null || largestVersion.compareTo(taskVer) >= 0) continue;
            largestVersion = taskVer;
        }
        return largestVersion;
    }

    public void executeUpgrade(Version targetVersion, List<Task> taskList, Connection con) throws SQLException {
        this.executeUpgrade(null, targetVersion, taskList, con);
    }

    public void executeUpgrade(Target target, Version version, List<Task> taskList, Connection con) throws SQLException {
        this.createVersionTableIfNeeded(con);
        this.filterTasksNotToRun(target, version, taskList, con);
        this.runTasks(taskList, version, con);
    }

    private void runTasks(List<Task> list, Version targetVersion, Connection con) throws SQLException {
        for (Task task : list) {
            if (!task.runTask(con)) continue;
            this.saveTask(task, con);
        }
    }

    private void filterTasksNotToRun(Target target, Version schemaVersion, List<Task> taskList, Connection con) throws SQLException {
        List<String> hasRunList = this.getTasksAlreadyRun(con);
        Iterator<Task> itr = taskList.iterator();
        while (itr.hasNext()) {
            boolean hasRun;
            Task task = itr.next();
            if (task.isRun(target, schemaVersion, hasRun = hasRunList.contains(task.getIdentifier()))) continue;
            itr.remove();
        }
    }

    public List<String> getTasksAlreadyRun(Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("select id from " + this.getTableNameWithSchema());
        LinkedList<String> list = new LinkedList<String>();
        while (rs.next()) {
            list.add(rs.getString(1));
        }
        rs.close();
        stmt.close();
        return list;
    }

    private boolean versionTableExists(Connection con) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        String[] tableTypes = new String[]{"TABLE"};
        ResultSet rs = metaData.getTables(null, this.getSchema(), this.getTableName(), tableTypes);
        boolean containsTable = rs.next();
        rs.close();
        if (!containsTable) {
            rs = metaData.getTables(null, this.getSchema(), this.getTableName().toUpperCase(), tableTypes);
            containsTable = rs.next();
            rs.close();
        }
        return containsTable;
    }

    private void createVersionTableIfNeeded(Connection con) throws SQLException {
        if (!this.versionTableExists(con)) {
            Statement stmt = con.createStatement();
            if (this.getSchema() != null) {
                boolean schemaExists = false;
                DatabaseMetaData dbmd = con.getMetaData();
                ResultSet rs = dbmd.getSchemas();
                while (rs.next()) {
                    if (!this.getSchema().equalsIgnoreCase(rs.getString(1))) continue;
                    schemaExists = true;
                }
                rs.close();
                if (!schemaExists) {
                    stmt.execute("create schema " + this.getSchema());
                }
            }
            DatabaseType type = DatabaseType.getDatabaseType(con);
            String sql = this.createTableSQL(type);
            stmt.execute(sql);
            stmt.close();
        }
    }

    private String createTableSQL(DatabaseType type) {
        StringBuilder sb = new StringBuilder();
        sb.append("create table " + this.getTableNameWithSchema() + " (");
        sb.append("  id varchar(255) not null,");
        sb.append("  target varchar(255) null,");
        sb.append("  comment_text varchar(255) null,");
        sb.append("  version varchar(255) not null,");
        if (DatabaseType.SQL_SERVER.equals((Object)type)) {
            sb.append("  up_time datetime not null,");
        } else {
            sb.append("  up_time timestamp not null,");
        }
        sb.append("  constraint \"PK_" + this.getTableName().toUpperCase() + "\" primary key (\"ID\")");
        sb.append(") ");
        return sb.toString();
    }

    private void saveTask(Task task, Connection con) throws SQLException {
        String sql = "insert into " + this.getTableNameWithSchema() + " (id,target,comment_text,version,up_time) values (?,?,?,?,?)";
        PreparedStatement ps = con.prepareStatement(sql);
        ps.setString(1, task.getIdentifier());
        if (task.getTarget() == null) {
            ps.setNull(2, 12);
        } else {
            ps.setString(2, task.getTarget().getIdentifier());
        }
        if (task.getComment() == null) {
            ps.setNull(3, 12);
        } else {
            ps.setString(3, task.getComment());
        }
        Version v = task.getVersion();
        if (v == null) {
            v = new Version(0, 0, 0);
        }
        ps.setString(4, v.toString());
        ps.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
        ps.execute();
        ps.close();
        if (!con.getAutoCommit()) {
            con.commit();
        }
    }
}

