/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.mariweb;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import rx.Observable;
import rx.Subscriber;

public class OperatorExtractValuesFromInsertStatement
implements Observable.Operator<List<String>, String> {
    private static final char COMMA = ',';
    private static final char QUOTE = '\'';
    private static final char ESCAPE = '\\';
    private static final char SPACE = ' ';
    private static final boolean DEBUG = false;
    private static final int CHECK_UNSUBSCRIBED_EVERY = 1000;

    public Subscriber<? super String> call(final Subscriber<? super List<String>> child) {
        return new Subscriber<String>(child){

            public void onCompleted() {
                if (!child.isUnsubscribed()) {
                    child.onCompleted();
                }
            }

            public void onError(Throwable e) {
                if (!child.isUnsubscribed()) {
                    child.onError(e);
                }
            }

            public void onNext(String line) {
                if (!child.isUnsubscribed()) {
                    String clause = OperatorExtractValuesFromInsertStatement.this.getClause(line);
                    OperatorExtractValuesFromInsertStatement.parseValuesFromClause(clause, (Subscriber<? super List<String>>)child);
                }
            }
        };
    }

    private String getClause(String s) {
        int i = s.indexOf("VALUES");
        return s.substring(i + "VALUES".length()).trim();
    }

    private static <T> T unexpected() {
        throw new RuntimeException();
    }

    static void parseValuesFromClause(String s, Subscriber<? super List<String>> subscriber) {
        int charPosition = 0;
        boolean isOpen = false;
        boolean isEscaped = false;
        boolean isInQuotes = false;
        ArrayList<String> values = new ArrayList<String>();
        StringBuilder token = new StringBuilder();
        long count = 0L;
        char currentCh = '?';
        try {
            for (int i = 0; i < s.length(); ++i) {
                char ch;
                currentCh = ch = s.charAt(i);
                if (ch == '(' && !isInQuotes) {
                    if (isOpen) {
                        OperatorExtractValuesFromInsertStatement.unexpected();
                    } else {
                        isOpen = true;
                    }
                } else if (ch == ')' && !isInQuotes) {
                    if (!isOpen) {
                        OperatorExtractValuesFromInsertStatement.unexpected();
                    } else {
                        isOpen = false;
                        if (token.length() > 0) {
                            values.add(token.toString());
                            token = new StringBuilder();
                        }
                        if (++count % 1000L == 0L && subscriber.isUnsubscribed()) {
                            return;
                        }
                        subscriber.onNext(values);
                        values = new ArrayList();
                    }
                } else if (ch == '\'' && !isInQuotes) {
                    isInQuotes = true;
                } else if (ch == '\'' && !isEscaped) {
                    isInQuotes = false;
                } else if (ch == '\'') {
                    token.append('\'');
                    isEscaped = false;
                } else if (ch == '\\' && isInQuotes && isEscaped) {
                    token.append('\\');
                    isEscaped = false;
                } else if (ch == '\\' && isInQuotes) {
                    isEscaped = true;
                } else if (ch == '\\') {
                    OperatorExtractValuesFromInsertStatement.unexpected();
                } else if (ch == ',' && !isInQuotes && isOpen) {
                    values.add(token.toString());
                    token = new StringBuilder();
                } else if (ch == ',' && isInQuotes) {
                    token.append(',');
                } else if (ch != ',' && (ch != ' ' || isInQuotes)) {
                    token.append(ch);
                    isEscaped = false;
                }
                ++charPosition;
                if (token.length() > 2000) {
                    throw new RuntimeException("token too long (>2000)");
                }
                if (values.size() <= 100) continue;
                throw new RuntimeException("too many columns found in a values clause (>100)");
            }
        }
        catch (RuntimeException e) {
            System.out.println("'" + currentCh + "' open=" + isOpen + ", escaped=" + isEscaped + ",inQuotes=" + isInQuotes + ",token=" + token + "values=" + values);
            OperatorExtractValuesFromInsertStatement.writeLineToFile(s);
            throw new RuntimeException("error at position " + charPosition + ". line with problem written to target/error-line.txt", e);
        }
    }

    private static void writeLineToFile(String s) {
        try {
            FileOutputStream fos = new FileOutputStream("target/error-line.txt");
            fos.write(s.getBytes("US-ASCII"));
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

