/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.mariweb;

import au.gov.amsa.mariweb.OperatorExtractValuesFromInsertStatement;
import au.gov.amsa.streams.Strings;
import au.gov.amsa.util.nmea.NmeaMessageParser;
import au.gov.amsa.util.nmea.NmeaUtil;
import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Func1;

public class BackupReader {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final Set<String> TABLES = new HashSet<String>(Arrays.asList("ITU21_data", "ITU411_data", "ITU123_data", "ITU5_data", "ITU18_data", "ITU19_data"));

    static Observable<String> getNmea(InputStream is) {
        AtomicInteger lineNo = new AtomicInteger(0);
        return Strings.split((Observable)Strings.from((Reader)new InputStreamReader(is)), (String)"\n").doOnNext(line -> lineNo.incrementAndGet()).filter(line -> {
            for (String table : TABLES) {
                if (!line.startsWith("INSERT INTO `" + table + "`")) continue;
                return true;
            }
            return false;
        }).lift((Observable.Operator)new OperatorExtractValuesFromInsertStatement()).onBackpressureBuffer().flatMap(BackupReader.toNmea());
    }

    private static Func1<List<String>, Observable<String>> toNmea() {
        return row -> {
            String tagBlockAmended;
            String aisMessage = (String)row.get(5);
            String[] items = aisMessage.split("\\|");
            ArrayList<String> list = new ArrayList<String>();
            String positionTime = (String)row.get(1);
            String arrivalTime = (String)row.get(2);
            String tagBlock = (String)row.get(6);
            if (tagBlock.length() == 0) {
                throw new RuntimeException("tag block is empty!");
            }
            if (tagBlock.charAt(0) != '\\') {
                throw new RuntimeException("tag block should start with \\:" + tagBlock);
            }
            if (tagBlock.length() < 5) {
                throw new RuntimeException("tag block should be at least 5 characters:" + tagBlock);
            }
            LinkedHashMap tags = NmeaMessageParser.extractTags((String)tagBlock.substring(1, tagBlock.length() - 1));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sdf.setTimeZone(UTC);
            try {
                long unixSeconds = sdf.parse(arrivalTime).getTime() / 1000L;
                StringBuilder s = new StringBuilder();
                String source = (String)tags.get("s");
                if (source != null) {
                    source = source.trim();
                    s.append("s:");
                    s.append(source);
                }
                long positionTimeUnixSeconds = sdf.parse(positionTime).getTime() / 1000L;
                if (s.length() > 0) {
                    s.append(',');
                }
                s.append("c:");
                s.append(positionTimeUnixSeconds);
                if (s.length() > 0) {
                    s.append(',');
                }
                s.append("at:");
                s.append(unixSeconds);
                String checksum = NmeaUtil.getChecksum((String)s.toString());
                s.append('*');
                s.append(checksum);
                s.append('\\');
                s.insert(0, '\\');
                tagBlockAmended = s.toString();
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            for (String item : items) {
                list.add(tagBlockAmended + item);
            }
            return Observable.from(list);
        };
    }

    public Observable<String> getNmea(String s) {
        return BackupReader.getNmea(new ByteArrayInputStream(s.getBytes()));
    }

    public void extractNmea(File file, File output) {
        GZIPInputStream is = null;
        DeflaterOutputStream fos = null;
        try {
            is = new GZIPInputStream(new FileInputStream(file));
            fos = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(output)));
            this.extractNmea(is, fos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractNmea(InputStream is, OutputStream os) {
        try (final PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, Charset.forName("UTF-8"))));){
            final AtomicReference exception = new AtomicReference();
            BackupReader.getNmea(is).subscribe((Observer)new Observer<String>(){
                Long time = System.currentTimeMillis();
                final int rateEvery = 1000000;
                long count;

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                    e.printStackTrace();
                    exception.set(e);
                }

                public void onNext(String line) {
                    writer.println(line);
                    this.incrementCount();
                }

                private void incrementCount() {
                    long n;
                    if ((n = ++this.count) % 1000000L == 0L) {
                        long t = System.currentTimeMillis();
                        double rate = 1.0E9 / (double)(t - this.time);
                        System.out.println(new Date() + ":" + n + " msgsPerSecond = " + rate);
                        this.time = t;
                    }
                }
            });
            if (exception.get() != null) {
                throw new RuntimeException((Throwable)exception.get());
            }
        }
    }

    public static void convertDirectoryToNmea(File directory, final Scheduler scheduler, boolean recurse) {
        int count = (Integer)Observable.from(BackupReader.getFilesToProcess(directory, recurse)).flatMap((Func1)new Func1<File, Observable<File>>(){

            public Observable<File> call(final File file) {
                return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<File>(){

                    public void call(Subscriber<? super File> subscriber) {
                        BackupReader.convertFileToNmea(file);
                        subscriber.onNext((Object)file);
                        subscriber.onCompleted();
                    }
                }).subscribeOn(scheduler);
            }
        }).count().toBlocking().single();
        System.out.println(count + "files converted");
    }

    private static List<File> getFilesToProcess(File directory, boolean recurse) {
        Preconditions.checkArgument((boolean)directory.exists(), (Object)("directory does not exist: " + directory));
        Preconditions.checkArgument((boolean)directory.isDirectory(), (Object)("file is not a directory: " + directory));
        File[] files = directory.listFiles((dir, name) -> (name.startsWith("LSS_20") || name.startsWith("ITU_20")) && name.endsWith(".bu.gz"));
        Arrays.sort(files, (a, b) -> a.getName().compareTo(b.getName()));
        ArrayList<File> list = new ArrayList<File>(Arrays.asList(files));
        if (recurse) {
            for (File d : directory.listFiles()) {
                if (!d.isDirectory() || d.getName().startsWith(".")) continue;
                list.addAll(BackupReader.getFilesToProcess(d, recurse));
            }
        }
        return list;
    }

    static void convertFileToNmea(File file) {
        String baseName = "NMEA_" + file.getName().replace(".bu", "").replace("LSS_", "ITU_");
        File output = new File(file.getParentFile(), baseName + ".tmp");
        File finalOutput = new File(file.getParentFile(), baseName);
        if (!finalOutput.exists()) {
            System.out.println("converting " + file);
            try {
                BackupReader b = new BackupReader();
                b.extractNmea(file, output);
                output.renameTo(finalOutput);
                if (finalOutput.length() < 1000000L) {
                    throw new RuntimeException("file less than 1MB, deleting " + finalOutput);
                }
                System.out.println("converted " + file);
            }
            catch (RuntimeException e) {
                System.out.println("problem processing " + file);
                e.printStackTrace(System.out);
                finalOutput.delete();
            }
        } else {
            System.out.println("output exists: " + finalOutput);
        }
    }
}

