/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.navigation.ais;

import au.gov.amsa.ais.message.AisPositionBExtended;
import au.gov.amsa.ais.message.AisShipStaticA;
import au.gov.amsa.navigation.Identifier;
import au.gov.amsa.navigation.Mmsi;
import au.gov.amsa.navigation.ais.Vessel;
import com.google.common.base.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class VesselData {
    private ConcurrentHashMap<Identifier, Vessel> map = new ConcurrentHashMap();

    public Optional<Vessel> get(Identifier id) {
        return Optional.fromNullable((Object)this.map.get(id));
    }

    public VesselData add(AisShipStaticA m, Optional<String> nmea) {
        boolean inserted;
        Mmsi id = new Mmsi(m.getMmsi());
        do {
            Optional value;
            Optional v = !(value = Optional.fromNullable((Object)this.map.get(id))).isPresent() ? Optional.of((Object)Vessel.builder().mmsi(m.getMmsi()).build()) : value;
            Vessel.Builder builder = Vessel.from((Vessel)v.get());
            if (m.getImo().isPresent()) {
                builder = builder.imo((Optional<Integer>)m.getImo());
            }
            if (m.getDimensionA().isPresent()) {
                builder = builder.dimensionA((Optional<Integer>)m.getDimensionA());
            }
            if (m.getDimensionB().isPresent()) {
                builder = builder.dimensionB((Optional<Integer>)m.getDimensionB());
            }
            if (m.getDimensionC().isPresent()) {
                builder = builder.dimensionC((Optional<Integer>)m.getDimensionC());
            }
            if (m.getDimensionD().isPresent()) {
                builder = builder.dimensionD((Optional<Integer>)m.getDimensionD());
            }
            if (m.getLengthMetres().isPresent()) {
                builder = builder.lengthMetres((Optional<Integer>)m.getLengthMetres());
            }
            if (nmea.isPresent()) {
                builder = builder.nmea(nmea);
            }
            builder = builder.shipType((Optional<Integer>)Optional.of((Object)m.getShipType()));
            Vessel vessel = builder.build();
            if (value.isPresent()) {
                inserted = this.map.replace(id, (Vessel)v.get(), vessel);
                continue;
            }
            boolean bl = inserted = this.map.putIfAbsent(id, vessel) == null;
        } while (!inserted);
        return this;
    }

    public VesselData add(AisPositionBExtended message, Optional<String> line) {
        return this;
    }
}

