/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.navigation.ais;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class Vessel {
    private long mmsi;
    private Optional<Integer> imo;
    private Optional<Integer> shipType;
    private Optional<Integer> dimensionA;
    private Optional<Integer> dimensionB;
    private Optional<Integer> dimensionC;
    private Optional<Integer> dimensionD;
    private Optional<Integer> lengthMetres;
    private Optional<Integer> widthMetres;
    private Optional<String> nmea;

    private Vessel(long mmsi, Optional<Integer> imo, Optional<Integer> shipType, Optional<Integer> dimensionA, Optional<Integer> dimensionB, Optional<Integer> dimensionC, Optional<Integer> dimensionD, Optional<Integer> lengthMetres, Optional<Integer> widthMetres, Optional<String> nmea) {
        Preconditions.checkNotNull(imo);
        Preconditions.checkNotNull(shipType);
        Preconditions.checkNotNull(dimensionA);
        Preconditions.checkNotNull(dimensionB);
        Preconditions.checkNotNull(dimensionC);
        Preconditions.checkNotNull(dimensionD);
        Preconditions.checkNotNull(lengthMetres);
        Preconditions.checkNotNull(widthMetres);
        Preconditions.checkNotNull(nmea);
        this.mmsi = mmsi;
        this.imo = imo;
        this.shipType = shipType;
        this.dimensionA = dimensionA;
        this.dimensionB = dimensionB;
        this.dimensionC = dimensionC;
        this.dimensionD = dimensionD;
        this.lengthMetres = lengthMetres;
        this.widthMetres = widthMetres;
        this.nmea = nmea;
    }

    public long getMmsi() {
        return this.mmsi;
    }

    public Optional<Integer> getImo() {
        return this.imo;
    }

    public Optional<Integer> getShipType() {
        return this.shipType;
    }

    public Optional<Integer> getDimensionA() {
        return this.dimensionA;
    }

    public Optional<Integer> getDimensionB() {
        return this.dimensionB;
    }

    public Optional<Integer> getDimensionC() {
        return this.dimensionC;
    }

    public Optional<Integer> getDimensionD() {
        return this.dimensionD;
    }

    public Optional<Integer> getLengthMetres() {
        return this.lengthMetres;
    }

    public Optional<Integer> getWidthMetres() {
        return this.widthMetres;
    }

    public Optional<String> getNmea() {
        return this.nmea;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder from(Vessel v) {
        return Vessel.builder().mmsi(v.mmsi).imo(v.imo).shipType(v.shipType).dimensionA(v.dimensionA).dimensionB(v.dimensionB).dimensionC(v.dimensionC).dimensionD(v.dimensionD).lengthMetres(v.lengthMetres).widthMetres(v.widthMetres).nmea(v.nmea);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Vessel [mmsi=");
        b.append(this.mmsi);
        b.append(", imo=");
        b.append(this.imo);
        b.append(", shipType=");
        b.append(this.shipType);
        b.append(", dimensionA=");
        b.append(this.dimensionA);
        b.append(", dimensionB=");
        b.append(this.dimensionB);
        b.append(", dimensionC=");
        b.append(this.dimensionC);
        b.append(", dimensionD=");
        b.append(this.dimensionD);
        b.append(", lengthMetres=");
        b.append(this.lengthMetres);
        b.append(", widthMetres=");
        b.append(this.widthMetres);
        b.append(", nmea=");
        b.append(this.nmea);
        b.append("]");
        return b.toString();
    }

    public static class Builder {
        private long mmsi;
        private Optional<Integer> imo = Optional.absent();
        private Optional<Integer> shipType = Optional.absent();
        private Optional<Integer> dimensionA = Optional.absent();
        private Optional<Integer> dimensionB = Optional.absent();
        private Optional<Integer> dimensionC = Optional.absent();
        private Optional<Integer> dimensionD = Optional.absent();
        private Optional<Integer> lengthMetres = Optional.absent();
        private Optional<Integer> widthMetres = Optional.absent();
        private Optional<String> nmea = Optional.absent();

        private Builder() {
        }

        public Builder mmsi(long mmsi) {
            this.mmsi = mmsi;
            return this;
        }

        public Builder imo(Optional<Integer> imo) {
            this.imo = imo;
            return this;
        }

        public Builder shipType(Optional<Integer> shipType) {
            this.shipType = shipType;
            return this;
        }

        public Builder dimensionA(Optional<Integer> dimensionA) {
            this.dimensionA = dimensionA;
            return this;
        }

        public Builder dimensionB(Optional<Integer> dimensionB) {
            this.dimensionB = dimensionB;
            return this;
        }

        public Builder dimensionC(Optional<Integer> dimensionC) {
            this.dimensionC = dimensionC;
            return this;
        }

        public Builder dimensionD(Optional<Integer> dimensionD) {
            this.dimensionD = dimensionD;
            return this;
        }

        public Builder lengthMetres(Optional<Integer> lengthMetres) {
            this.lengthMetres = lengthMetres;
            return this;
        }

        public Builder widthMetres(Optional<Integer> widthMetres) {
            this.widthMetres = widthMetres;
            return this;
        }

        public Builder nmea(Optional<String> nmea) {
            this.nmea = nmea;
            return this;
        }

        public Vessel build() {
            return new Vessel(this.mmsi, this.imo, this.shipType, this.dimensionA, this.dimensionB, this.dimensionC, this.dimensionD, this.lengthMetres, this.widthMetres, this.nmea);
        }
    }
}

