/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.navigation.ais;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import rx.Observable;
import rx.Subscriber;

public class SortOperator<T>
implements Observable.Operator<T, T> {
    private ArrayList<T> list;
    private Comparator<T> comparator;

    public SortOperator(Comparator<T> comparator, int size) {
        this.comparator = comparator;
        this.list = new ArrayList(size);
    }

    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        return new Subscriber<T>(){
            long count = 0L;

            public void onCompleted() {
                Collections.sort(SortOperator.this.list, SortOperator.this.comparator);
                for (Object t : SortOperator.this.list) {
                    if (child.isUnsubscribed()) {
                        return;
                    }
                    child.onNext(t);
                }
                child.onCompleted();
            }

            public void onError(Throwable e) {
                child.onError(e);
            }

            public void onNext(T t) {
                if (++this.count % 100000L == 0L) {
                    System.out.println("count=" + this.count);
                }
                SortOperator.this.list.add(t);
            }
        };
    }
}

