/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.navigation.ais;

import au.gov.amsa.ais.AisMessage;
import au.gov.amsa.ais.Timestamped;
import au.gov.amsa.ais.message.AisPosition;
import au.gov.amsa.ais.message.AisPositionA;
import au.gov.amsa.ais.message.NavigationalStatus;
import au.gov.amsa.ais.rx.Streams;
import au.gov.amsa.navigation.Mmsi;
import au.gov.amsa.navigation.VesselClass;
import au.gov.amsa.navigation.VesselPosition;
import au.gov.amsa.navigation.ais.AisMessageAndVesselData;
import au.gov.amsa.navigation.ais.SortOperator;
import au.gov.amsa.navigation.ais.Util;
import au.gov.amsa.navigation.ais.Vessel;
import com.google.common.base.Optional;
import java.util.Comparator;
import rx.Observable;
import rx.functions.Func1;

public class AisVesselPositions {
    private static final Func1<AisMessageAndVesselData, Boolean> isPosition = m -> {
        if (m.message().isPresent() && ((Timestamped)((Streams.TimestampedAndLine)m.message().get()).getMessage().get()).message() instanceof AisPosition) {
            AisPosition p = (AisPosition)((Timestamped)((Streams.TimestampedAndLine)m.message().get()).getMessage().get()).message();
            return p.getLatitude() != null && p.getLongitude() != null;
        }
        return false;
    };
    private static final Func1<AisMessageAndVesselData, VesselPosition> toVesselPosition = messageAndData -> {
        AisPositionA a;
        Optional<Integer> shipType;
        AisPosition p = (AisPosition)((Timestamped)((Streams.TimestampedAndLine)messageAndData.message().get()).getMessage().get()).message();
        VesselClass cls = p instanceof AisPositionA ? VesselClass.A : VesselClass.B;
        Mmsi id = new Mmsi(p.getMmsi());
        Optional<Vessel> vessel = messageAndData.data().get(id);
        Optional<Integer> lengthMetres = vessel.isPresent() ? ((Vessel)vessel.get()).getLengthMetres() : Optional.absent();
        Optional<Integer> widthMetres = vessel.isPresent() ? ((Vessel)vessel.get()).getWidthMetres() : Optional.absent();
        Optional speedMetresPerSecond = p.getSpeedOverGroundKnots() != null ? Optional.of((Object)(p.getSpeedOverGroundKnots() * 0.5144444444)) : Optional.absent();
        Optional<Integer> optional = shipType = vessel.isPresent() ? ((Vessel)vessel.get()).getShipType() : Optional.absent();
        VesselPosition.NavigationalStatus navigationalStatus = p instanceof AisPositionA ? (Util.equals((a = (AisPositionA)p).getNavigationalStatus(), NavigationalStatus.AT_ANCHOR) ? VesselPosition.NavigationalStatus.AT_ANCHOR : (Util.equals(a.getNavigationalStatus(), NavigationalStatus.MOORED) ? VesselPosition.NavigationalStatus.MOORED : VesselPosition.NavigationalStatus.NOT_DEFINED)) : VesselPosition.NavigationalStatus.NOT_DEFINED;
        Optional positionAisNmea = p instanceof AisPositionA ? Optional.of((Object)((Streams.TimestampedAndLine)messageAndData.message().get()).getLine()) : Optional.absent();
        Optional<String> shipStaticAisNmea = vessel.isPresent() ? ((Vessel)vessel.get()).getNmea() : Optional.absent();
        return VesselPosition.builder().cogDegrees((Optional<Double>)Optional.fromNullable((Object)p.getCourseOverGround())).headingDegrees((Optional<Double>)Optional.fromNullable((Object)AisVesselPositions.toDouble(p.getTrueHeading()))).speedMetresPerSecond((Optional<Double>)speedMetresPerSecond).lat(p.getLatitude()).lon(p.getLongitude()).id(id).lengthMetres(lengthMetres).widthMetres(widthMetres).time(((Timestamped)((Streams.TimestampedAndLine)messageAndData.message().get()).getMessage().get()).time()).shipType(shipType).cls(cls).navigationalStatus(navigationalStatus).positionAisNmea((Optional<String>)positionAisNmea).shipStaticAisNmea(shipStaticAisNmea).build();
    };

    public static Observable<VesselPosition> positions(Observable<String> nmea) {
        return Streams.extract(nmea).filter(AisVesselPositions.isPresent()).scan((Object)new AisMessageAndVesselData(), AisMessageAndVesselData.aggregate).filter(isPosition).map(toVesselPosition);
    }

    public static Observable.Transformer<String, VesselPosition> positions() {
        return nmea -> AisVesselPositions.positions((Observable<String>)nmea);
    }

    private static Func1<Streams.TimestampedAndLine<AisMessage>, Boolean> isPresent() {
        return t -> t.getMessage().isPresent();
    }

    public static Observable<Streams.TimestampedAndLine<AisMessage>> sortByTime(Observable<Streams.TimestampedAndLine<AisMessage>> source) {
        Comparator comparator = (t1, t2) -> Long.valueOf(((Timestamped)t1.getMessage().get()).time()).compareTo(((Timestamped)t2.getMessage().get()).time());
        return source.lift(new SortOperator(comparator, 20000000));
    }

    public static Observable<VesselPosition> positionsSortedByTime(Observable<String> nmea) {
        return AisVesselPositions.sortByTime((Observable<Streams.TimestampedAndLine<AisMessage>>)Streams.extract(nmea)).scan((Object)new AisMessageAndVesselData(), AisMessageAndVesselData.aggregate).filter(isPosition).map(toVesselPosition);
    }

    private static Double toDouble(Number i) {
        if (i == null) {
            return null;
        }
        return i.doubleValue();
    }
}

