/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.navigation;

import au.gov.amsa.navigation.Mmsi;
import au.gov.amsa.navigation.VesselClass;
import au.gov.amsa.navigation.VesselPosition;
import au.gov.amsa.risky.format.AisClass;
import au.gov.amsa.risky.format.Fix;
import au.gov.amsa.risky.format.HasFix;
import au.gov.amsa.risky.format.NavigationalStatus;
import com.google.common.base.Optional;
import java.util.concurrent.TimeUnit;
import rx.functions.Func1;

public class VesselPositions {
    private static final double KNOTS_TO_METRES_PER_SECOND = 1852.0 / (double)TimeUnit.HOURS.toSeconds(1L);
    public static Func1<HasFix, VesselPosition> TO_VESSEL_POSITION = fix -> VesselPositions.toVesselPosition(fix.fix(), Optional.absent());

    public static VesselPosition toVesselPosition(Fix fix, Optional<?> data) {
        return VesselPosition.builder().id(new Mmsi(fix.mmsi())).lat(fix.lat()).lon(fix.lon()).time(fix.time()).cls(fix.aisClass() == AisClass.A ? VesselClass.A : VesselClass.B).cogDegrees(VesselPositions.toDouble((Optional<Float>)fix.courseOverGroundDegrees())).headingDegrees(VesselPositions.toDouble((Optional<Float>)fix.headingDegrees())).speedMetresPerSecond(VesselPositions.multiply((Optional<Float>)fix.speedOverGroundKnots(), KNOTS_TO_METRES_PER_SECOND)).navigationalStatus(fix.navigationalStatus().isPresent() ? VesselPosition.NavigationalStatus.values()[((NavigationalStatus)fix.navigationalStatus().get()).ordinal()] : VesselPosition.NavigationalStatus.NOT_DEFINED).positionAisNmea((Optional<String>)Optional.absent()).shipStaticAisNmea((Optional<String>)Optional.absent()).data(data).build();
    }

    public static <T extends HasFix> Func1<T, VesselPosition> toVesselPosition(Func1<T, Optional<?>> dataExtractor) {
        return fix -> VesselPositions.toVesselPosition(fix.fix(), (Optional)dataExtractor.call(fix));
    }

    private static Optional<Double> toDouble(Optional<Float> value) {
        if (!value.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)((Float)value.get()).floatValue());
    }

    private static Optional<Double> multiply(Optional<Float> value, double factor) {
        if (!value.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)((double)((Float)value.get()).floatValue() * factor));
    }
}

