/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.navigation;

import au.gov.amsa.navigation.Identifier;
import au.gov.amsa.navigation.Mmsi;
import au.gov.amsa.navigation.Times;
import au.gov.amsa.navigation.Vector;
import au.gov.amsa.navigation.VesselClass;
import au.gov.amsa.risky.format.AisClass;
import au.gov.amsa.risky.format.Fix;
import au.gov.amsa.risky.format.HasFix;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;

public class VesselPosition
implements HasFix {
    public static boolean validate = true;
    private static final double EARTH_RADIUS_KM = 6378.1;
    private static final int maxDimensionMetresWhenUnknown = 30;
    private final double lat;
    private final double lon;
    private final Optional<Integer> lengthMetres;
    private final Optional<Integer> widthMetres;
    private final Optional<Double> cogDegrees;
    private final Optional<Double> headingDegrees;
    private final Optional<Double> speedMetresPerSecond;
    private final Optional<String> positionAisNmea;
    private final Optional<String> shipStaticAisNmea;
    private final NavigationalStatus navigationalStatus;
    private final long time;
    private final Identifier id;
    private final VesselClass cls;
    private final Optional<Integer> shipType;
    private static AtomicLong counter = new AtomicLong();
    private final long messageId;
    private final Optional<?> data;

    private VesselPosition(long messageId, Identifier id, double lat, double lon, Optional<Integer> lengthMetres, Optional<Integer> widthMetres, Optional<Double> cog, Optional<Double> heading, Optional<Double> speedMetresPerSecond, VesselClass cls, NavigationalStatus navigationalStatus, long time, Optional<Integer> shipType, Optional<String> positionAisNmea, Optional<String> shipStaticAisNmea, Optional<?> data) {
        if (validate) {
            Preconditions.checkArgument((lat >= -90.0 && lat <= 90.0 ? 1 : 0) != 0);
            Preconditions.checkArgument((lon >= -180.0 && lon <= 180.0 ? 1 : 0) != 0);
            Preconditions.checkNotNull((Object)id);
            Preconditions.checkNotNull(lengthMetres);
            Preconditions.checkNotNull(widthMetres);
            Preconditions.checkNotNull(shipType);
            Preconditions.checkNotNull(positionAisNmea);
            Preconditions.checkNotNull(shipStaticAisNmea);
            Preconditions.checkNotNull((Object)((Object)navigationalStatus));
        }
        this.messageId = messageId;
        this.cls = cls;
        this.id = id;
        this.lat = lat;
        this.lon = lon;
        this.lengthMetres = lengthMetres;
        this.widthMetres = widthMetres;
        this.cogDegrees = cog;
        this.headingDegrees = heading;
        this.speedMetresPerSecond = speedMetresPerSecond;
        this.time = time;
        this.navigationalStatus = navigationalStatus;
        this.shipType = shipType;
        this.positionAisNmea = positionAisNmea;
        this.shipStaticAisNmea = shipStaticAisNmea;
        this.data = data;
    }

    public long messageId() {
        return this.messageId;
    }

    public Identifier id() {
        return this.id;
    }

    public double lat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    public Optional<?> data() {
        return this.data;
    }

    public Optional<Integer> lengthMetres() {
        return this.lengthMetres;
    }

    public Optional<Integer> widthMetres() {
        return this.widthMetres;
    }

    public Optional<Integer> maxDimensionMetres() {
        if (this.lengthMetres.isPresent() && this.widthMetres.isPresent()) {
            return Optional.of((Object)Math.max((Integer)this.lengthMetres.get(), (Integer)this.widthMetres.get()));
        }
        return Optional.absent();
    }

    public Optional<Double> cogDegrees() {
        return this.cogDegrees;
    }

    public Optional<Double> headingDegrees() {
        return this.headingDegrees;
    }

    public Optional<Double> speedMetresPerSecond() {
        return this.speedMetresPerSecond;
    }

    public VesselClass cls() {
        return this.cls;
    }

    public long time() {
        return this.time;
    }

    public NavigationalStatus navigationalStatus() {
        return this.navigationalStatus;
    }

    public Optional<Integer> shipType() {
        return this.shipType;
    }

    public Optional<String> positionAisNmea() {
        return this.positionAisNmea;
    }

    public Optional<String> shipStaticAisNmea() {
        return this.shipStaticAisNmea;
    }

    public static Builder builder() {
        return new Builder();
    }

    private double metresPerDegreeLongitude() {
        return 111.31884502145034 * Math.cos(Math.toRadians(this.lat));
    }

    private double metresPerDegreeLatitude() {
        return 111321.543;
    }

    public Vector position(VesselPosition relativeTo) {
        double xMetres = (this.lon - relativeTo.lon()) * relativeTo.metresPerDegreeLongitude();
        double yMetres = (this.lat - relativeTo.lat()) * relativeTo.metresPerDegreeLatitude();
        return new Vector(xMetres, yMetres);
    }

    public Optional<VesselPosition> predict(long t) {
        if (!this.speedMetresPerSecond.isPresent() || !this.cogDegrees.isPresent() || this.navigationalStatus == NavigationalStatus.AT_ANCHOR || this.navigationalStatus == NavigationalStatus.MOORED) {
            return Optional.absent();
        }
        double lat = this.lat - (Double)this.speedMetresPerSecond.get() / this.metresPerDegreeLatitude() * (double)(t - this.time) / 1000.0 * Math.cos(Math.toRadians((Double)this.cogDegrees.get()));
        double lon = this.lon + (Double)this.speedMetresPerSecond.get() / this.metresPerDegreeLongitude() * (double)(t - this.time) / 1000.0 * Math.sin(Math.toRadians((Double)this.cogDegrees.get()));
        return Optional.of((Object)new VesselPosition(this.messageId, this.id, lat, lon, this.lengthMetres, this.widthMetres, this.cogDegrees, this.headingDegrees, this.speedMetresPerSecond, this.cls, this.navigationalStatus, this.time, this.shipType, this.positionAisNmea, this.shipStaticAisNmea, this.data));
    }

    private Optional<Vector> velocity() {
        if (this.speedMetresPerSecond.isPresent() && this.cogDegrees.isPresent()) {
            return Optional.of((Object)new Vector((Double)this.speedMetresPerSecond.get() * Math.sin(Math.toRadians((Double)this.cogDegrees.get())), (Double)this.speedMetresPerSecond.get() * Math.cos(Math.toRadians((Double)this.cogDegrees.get()))));
        }
        return Optional.absent();
    }

    public Optional<Times> intersectionTimes(VesselPosition vp) {
        Optional<VesselPosition> p = vp.predict(this.time);
        Vector deltaV = ((Vector)this.velocity().get()).minus((Vector)((VesselPosition)p.get()).velocity().get());
        Vector deltaP = this.position(this).minus(((VesselPosition)p.get()).position(this));
        double r = (Integer)((VesselPosition)p.get()).maxDimensionMetres().or((Object)30) / 2 + (Integer)this.maxDimensionMetres().or((Object)30) / 2;
        if (deltaP.dot(deltaP) <= r) {
            return Optional.of((Object)new Times(((VesselPosition)p.get()).time()));
        }
        double a = deltaV.dot(deltaV);
        double b = 2.0 * deltaV.dot(deltaP);
        double c = deltaP.dot(deltaP) - r * r;
        double discriminant = b * b - 4.0 * a * c;
        if (a == 0.0) {
            return Optional.absent();
        }
        if (discriminant < 0.0) {
            return Optional.absent();
        }
        if (discriminant == 0.0) {
            return Optional.of((Object)new Times(Math.round(-b / 2.0 / a)));
        }
        long alpha1 = Math.round((-b + Math.sqrt(discriminant)) / 2.0 / a);
        long alpha2 = Math.round((-b - Math.sqrt(discriminant)) / 2.0 / a);
        return Optional.of((Object)new Times(alpha1, alpha2));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VesselPosition [lat=");
        b.append(this.lat);
        b.append(", lon=");
        b.append(this.lon);
        b.append(", lengthMetres=");
        b.append(this.lengthMetres);
        b.append(", widthMetres=");
        b.append(this.widthMetres);
        b.append(", cogDegrees=");
        b.append(this.cogDegrees);
        b.append(", headingDegrees=");
        b.append(this.headingDegrees);
        b.append(", speedMetresPerSecond=");
        b.append(this.speedMetresPerSecond);
        b.append(", positionAisNmea=");
        b.append(this.positionAisNmea);
        b.append(", shipStaticAisNmea=");
        b.append(this.shipStaticAisNmea);
        b.append(", navStatus=");
        b.append((Object)this.navigationalStatus);
        b.append(", time=");
        b.append(this.time);
        b.append(", id=");
        b.append(this.id);
        b.append(", cls=");
        b.append((Object)this.cls);
        b.append(", shipType=");
        b.append(this.shipType);
        b.append(", messageId=");
        b.append(this.messageId);
        b.append(", data=");
        b.append(this.data);
        b.append("]");
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (int)(this.messageId ^ this.messageId >>> 32);
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VesselPosition other = (VesselPosition)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.messageId != other.messageId) {
            return false;
        }
        return this.time == other.time;
    }

    public Fix fix() {
        return new Fix(){

            public Fix fix() {
                return this;
            }

            public int mmsi() {
                return (int)((Mmsi)VesselPosition.this.id).uniqueId();
            }

            public long time() {
                return VesselPosition.this.time;
            }

            public float lat() {
                return (float)VesselPosition.this.lat;
            }

            public float lon() {
                return (float)VesselPosition.this.lon;
            }

            public Optional<au.gov.amsa.risky.format.NavigationalStatus> navigationalStatus() {
                return Optional.of((Object)au.gov.amsa.risky.format.NavigationalStatus.values()[VesselPosition.this.navigationalStatus.ordinal()]);
            }

            public Optional<Float> speedOverGroundKnots() {
                if (VesselPosition.this.speedMetresPerSecond.isPresent()) {
                    return Optional.of((Object)Float.valueOf((float)VesselPosition.metresPerSecondToKnots((Double)VesselPosition.this.speedMetresPerSecond.get())));
                }
                return Optional.absent();
            }

            public Optional<Float> courseOverGroundDegrees() {
                return VesselPosition.toFloat((Optional<Double>)VesselPosition.this.cogDegrees);
            }

            public Optional<Float> headingDegrees() {
                return VesselPosition.toFloat((Optional<Double>)VesselPosition.this.headingDegrees);
            }

            public AisClass aisClass() {
                if (VesselPosition.this.cls == VesselClass.A) {
                    return AisClass.A;
                }
                if (VesselPosition.this.cls == VesselClass.B) {
                    return AisClass.B;
                }
                throw new RuntimeException("unexpected");
            }

            public Optional<Integer> latencySeconds() {
                return Optional.absent();
            }

            public Optional<Short> source() {
                return Optional.absent();
            }

            public Optional<Byte> rateOfTurn() {
                return Optional.absent();
            }
        };
    }

    static double metresPerSecondToKnots(double x) {
        return x * 3600.0 / 1852.0;
    }

    private static Optional<Float> toFloat(Optional<Double> value) {
        if (value.isPresent()) {
            return Optional.of((Object)Float.valueOf(((Double)value.get()).floatValue()));
        }
        return Optional.absent();
    }

    public static class Builder {
        private Identifier id;
        private double lat;
        private double lon;
        private Optional<Integer> lengthMetres = Optional.absent();
        private Optional<Integer> widthMetres = Optional.absent();
        private Optional<Double> cogDegrees;
        private Optional<Double> headingDegrees;
        private Optional<Double> speedMetresPerSecond;
        private Optional<String> positionAisNmea;
        private Optional<String> shipStaticAisNmea;
        private VesselClass cls;
        private long time;
        private Optional<Integer> shipType = Optional.absent();
        private NavigationalStatus navigationalStatus;
        private Optional<?> data;

        private Builder() {
        }

        public Builder id(Identifier id) {
            this.id = id;
            return this;
        }

        public Builder lat(double lat) {
            this.lat = lat;
            return this;
        }

        public Builder lon(double lon) {
            this.lon = lon;
            return this;
        }

        public Builder lengthMetres(Optional<Integer> lengthMetres) {
            this.lengthMetres = lengthMetres;
            return this;
        }

        public Builder widthMetres(Optional<Integer> widthMetres) {
            this.widthMetres = widthMetres;
            return this;
        }

        public Builder cogDegrees(Optional<Double> cog) {
            this.cogDegrees = cog;
            return this;
        }

        public Builder headingDegrees(Optional<Double> heading) {
            this.headingDegrees = heading;
            return this;
        }

        public Builder speedMetresPerSecond(Optional<Double> speedMetresPerSecond) {
            this.speedMetresPerSecond = speedMetresPerSecond;
            return this;
        }

        public Builder time(long time) {
            this.time = time;
            return this;
        }

        public Builder cls(VesselClass cls) {
            this.cls = cls;
            return this;
        }

        public Builder shipType(Optional<Integer> shipType) {
            this.shipType = shipType;
            return this;
        }

        public Builder positionAisNmea(Optional<String> nmea) {
            this.positionAisNmea = nmea;
            return this;
        }

        public Builder shipStaticAisNmea(Optional<String> nmea) {
            this.shipStaticAisNmea = nmea;
            return this;
        }

        public Builder navigationalStatus(NavigationalStatus status) {
            this.navigationalStatus = status;
            return this;
        }

        public Builder data(Optional<?> data) {
            this.data = data;
            return this;
        }

        public VesselPosition build() {
            return new VesselPosition(counter.incrementAndGet(), this.id, this.lat, this.lon, this.lengthMetres, this.widthMetres, this.cogDegrees, this.headingDegrees, this.speedMetresPerSecond, this.cls, this.navigationalStatus, this.time, this.shipType, this.positionAisNmea, this.shipStaticAisNmea, this.data);
        }
    }

    public static enum NavigationalStatus {
        UNDER_WAY_USING_ENGINE,
        AT_ANCHOR,
        NOT_UNDER_COMMAND,
        RESTRICTED_MANOEUVRABILITY,
        CONSTRAINED_BY_HER_DRAUGHT,
        MOORED,
        AGROUND,
        ENGAGED_IN_FISHING,
        UNDER_WAY,
        RESERVED_1,
        RESERVED_2,
        FUTURE_1,
        FUTURE_2,
        FUTURE_3,
        AIS_SART,
        NOT_DEFINED;

    }
}

