/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.navigation;

import com.google.common.base.Optional;

public class Times {
    private final long time1;
    private final Optional<Long> time2;

    private Times(long time1, Optional<Long> time2) {
        this.time1 = time1;
        this.time2 = time2;
    }

    public Times(long time1) {
        this(time1, (Optional<Long>)Optional.absent());
    }

    public Times(long time1, long time2) {
        this(time1, (Optional<Long>)Optional.of((Object)time2));
    }

    public long time1() {
        return this.time1;
    }

    public Optional<Long> time2() {
        return this.time2;
    }

    public Optional<Long> leastPositive() {
        if (this.time1 >= 0L && this.time2.isPresent() && (Long)this.time2.get() >= 0L) {
            return Optional.of((Object)Math.min(this.time1, (Long)this.time2.get()));
        }
        if (this.time1 >= 0L) {
            return Optional.of((Object)this.time1);
        }
        if (this.time2.isPresent() && (Long)this.time2.get() >= 0L) {
            return Optional.of((Object)this.time2.get());
        }
        return Optional.absent();
    }
}

