/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.navigation;

import au.gov.amsa.navigation.Comparators;
import au.gov.amsa.navigation.Identifier;
import au.gov.amsa.navigation.Mmsi;
import au.gov.amsa.navigation.VesselPosition;
import com.github.davidmoten.rtree.RTree;
import com.github.davidmoten.rtree.geometry.Geometries;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.Point;
import com.google.common.base.Optional;
import fj.Equal;
import fj.F;
import fj.Ord;
import fj.Ordering;
import fj.P3;
import fj.data.List;
import fj.data.Set;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class State {
    private static Logger log = LoggerFactory.getLogger(State.class);
    private static final int R_TREE_MAX_CHILDREN = 10;
    private final Map<Identifier, Set<VesselPosition>> map;
    private final RTree<VesselPosition, Point> tree;
    private final Optional<VesselPosition> last;
    private final long counter;
    private Set<VesselPosition> byTimeAndId;
    private static Ord<VesselPosition> ordering = State.toOrdering(Comparators.timeIdMessageIdComparator);
    private static Set<VesselPosition> EMPTY = Set.empty(ordering);
    private static final Equal<VesselPosition> EQUAL_ID = Equal.equal((F)new F<VesselPosition, F<VesselPosition, Boolean>>(){

        public F<VesselPosition, Boolean> f(final VesselPosition a) {
            return new F<VesselPosition, Boolean>(){

                public Boolean f(VesselPosition b) {
                    return a.id().equals(b.id());
                }
            };
        }
    });

    private State(Map<Identifier, Set<VesselPosition>> map, Set<VesselPosition> byTimeAndId, RTree<VesselPosition, Point> tree, Optional<VesselPosition> last, long counter) {
        this.map = Collections.unmodifiableMap(map);
        this.byTimeAndId = byTimeAndId;
        this.tree = tree;
        this.last = last;
        this.counter = counter;
    }

    State() {
        this(new HashMap<Identifier, Set<VesselPosition>>(), EMPTY, (RTree<VesselPosition, Point>)RTree.star().maxChildren(10).create(), (Optional<VesselPosition>)Optional.absent(), 0L);
    }

    Optional<VesselPosition> nextPosition() {
        if (this.last.isPresent()) {
            return this.next((VesselPosition)this.last.get());
        }
        return Optional.absent();
    }

    private Optional<VesselPosition> next(VesselPosition p) {
        Iterator it = ((Set)this.map.get(p.id()).split((Object)p)._3()).iterator();
        return it.hasNext() ? Optional.of(it.next()) : Optional.absent();
    }

    RTree<VesselPosition, Point> tree() {
        return this.tree;
    }

    Optional<VesselPosition> last() {
        return this.last;
    }

    private static Set<VesselPosition> add(Set<VesselPosition> set, VesselPosition t) {
        return set.insert((Object)t);
    }

    State nextState(long maxTimeInterval, VesselPosition p) {
        Set newByTime = State.add(this.byTimeAndId, p);
        RTree newTree = this.tree.add((Object)p, (Geometry)State.geometry(p));
        HashMap<Identifier, Set<VesselPosition>> newMap = new HashMap<Identifier, Set<VesselPosition>>(this.map);
        State.addToMap(newMap, p);
        if (this.counter % 10000L == 0L) {
            long t = System.currentTimeMillis();
            P3 split = newByTime.split((Object)VesselPosition.builder().time(p.time() - maxTimeInterval).id(new Mmsi(0L)).build());
            Set removeThese = (Set)split._1();
            newByTime = (Set)split._3();
            List lists = removeThese.toList().group(EQUAL_ID);
            int count = 0;
            for (List list : lists) {
                Identifier id = ((VesselPosition)list.index(0)).id();
                Set removals = Set.iterableSet(ordering, (Iterable)list);
                Set set = (Set)newMap.get(id);
                if ((set = set.minus(removals)).size() == 0) {
                    newMap.remove(id);
                } else {
                    newMap.put(id, (Set<VesselPosition>)set);
                }
                count += list.length();
            }
            for (VesselPosition vp : removeThese) {
                newTree = newTree.delete((Object)vp, (Geometry)State.geometry(vp));
            }
            if (newTree.size() != newByTime.size()) {
                throw new RuntimeException("unexpected");
            }
            t = System.currentTimeMillis() - t;
            log.info("removed " + count + " in " + t + "ms");
        }
        return new State(newMap, newByTime, (RTree<VesselPosition, Point>)newTree, (Optional<VesselPosition>)Optional.of((Object)p), this.counter + 1L);
    }

    private static void addToMap(Map<Identifier, Set<VesselPosition>> map, VesselPosition p) {
        Optional existing = Optional.fromNullable(map.get(p.id()));
        if (existing.isPresent()) {
            map.put(p.id(), State.add((Set<VesselPosition>)((Set)existing.get()), p));
        } else {
            map.put(p.id(), (Set<VesselPosition>)EMPTY.insert((Object)p));
        }
    }

    private static Point geometry(VesselPosition p) {
        return Geometries.point((double)p.lon(), (double)p.lat());
    }

    public int mapSize() {
        return this.map.size();
    }

    private static <A> Ord<A> toOrdering(final Comparator<A> comparator) {
        return Ord.ord((F)new F<A, F<A, Ordering>>(){

            public F<A, Ordering> f(final A a1) {
                return new F<A, Ordering>(){

                    public Ordering f(A a2) {
                        int x = comparator.compare(a1, a2);
                        return x < 0 ? Ordering.LT : (x == 0 ? Ordering.EQ : Ordering.GT);
                    }
                };
            }
        });
    }
}

