/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.navigation;

import au.gov.amsa.ais.AisMessage;
import au.gov.amsa.ais.Timestamped;
import au.gov.amsa.ais.message.AisShipStatic;
import au.gov.amsa.ais.message.AisShipStaticA;
import au.gov.amsa.ais.message.AisShipStaticUtil;
import au.gov.amsa.ais.rx.Streams;
import com.github.davidmoten.rx.Checked;
import com.github.davidmoten.rx.Transformers;
import com.github.davidmoten.rx.slf4j.Logging;
import com.google.common.base.Optional;
import java.io.File;
import java.io.PrintStream;
import java.util.List;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public final class ShipStaticDataCreator {
    private static Func1<Streams.TimestampedAndLine<AisMessage>, Observable<Streams.TimestampedAndLine<AisShipStatic>>> aisShipStaticOnly = m -> {
        Optional message = m.getMessage();
        if (message.isPresent() && ((Timestamped)message.get()).message() instanceof AisShipStatic) {
            Streams.TimestampedAndLine m2 = m;
            return Observable.just((Object)m2);
        }
        return Observable.empty();
    };

    public static Observable<AisShipStatic> writeStaticDataToFile(List<File> files, File outputFile) {
        return ShipStaticDataCreator.writeStaticDataToFile(files, outputFile, Schedulers.computation());
    }

    public static Observable<AisShipStatic> writeStaticDataToFile(List<File> files, File outputFile, Scheduler scheduler) {
        Func0 resourceFactory = Checked.f0(() -> new PrintStream(outputFile));
        Func1 observableFactory = out -> Observable.from((Iterable)files).buffer(Math.max(1, files.size() / Runtime.getRuntime().availableProcessors()) - 1).flatMap(list -> Observable.from((Iterable)list).lift((Observable.Operator)Logging.logger().showValue().showMemory().log()).concatMap(file -> Streams.extract((Observable)Streams.nmeaFromGzip((File)file)).flatMap(aisShipStaticOnly).map(m -> (AisShipStatic)((Timestamped)m.getMessage().get()).message()).filter(m -> m instanceof AisShipStatic).cast(AisShipStatic.class).distinct(m -> m.getMmsi())).distinct(m -> m.getMmsi()).subscribeOn(scheduler)).distinct(m -> m.getMmsi()).compose(Transformers.mapWithIndex()).doOnNext(indexed -> {
            if (indexed.index() == 0L) {
                out.println("# MMSI, IMO, AisClass, AisShipType, MaxPresentStaticDraughtMetres, DimAMetres, DimBMetres, DimCMetres, DimDMetres, LengthMetres, WidthMetres, Name");
                out.println("# columns are tab delimited");
                out.println("# -1 = not present");
            }
        }).map(indexed -> (AisShipStatic)indexed.value()).doOnNext(m -> {
            out.format("%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\n", m.getMmsi(), ShipStaticDataCreator.getImo(m).or((Object)-1), m instanceof AisShipStaticA ? "A" : "B", m.getShipType(), ShipStaticDataCreator.getMaximumPresentStaticDraughtMetres(m).or((Object)Float.valueOf(-1.0f)), m.getDimensionA().or((Object)-1), m.getDimensionB().or((Object)-1), m.getDimensionC().or((Object)-1), m.getDimensionD().or((Object)-1), AisShipStaticUtil.lengthMetres((AisShipStatic)m).or((Object)-1), AisShipStaticUtil.widthMetres((AisShipStatic)m).or((Object)-1), ShipStaticDataCreator.prepareName(m.getName()));
            out.flush();
        });
        Action1 disposeAction = out -> out.close();
        return Observable.using((Func0)resourceFactory, (Func1)observableFactory, (Action1)disposeAction);
    }

    private static String prepareName(String name) {
        if (name == null) {
            return "";
        }
        return name.replace("\t", " ").trim();
    }

    private static Optional<Integer> getImo(AisShipStatic m) {
        if (m instanceof AisShipStaticA) {
            return ((AisShipStaticA)m).getImo();
        }
        return Optional.absent();
    }

    private static Optional<Float> getMaximumPresentStaticDraughtMetres(AisShipStatic m) {
        if (m instanceof AisShipStaticA) {
            return Optional.of((Object)Float.valueOf((float)((AisShipStaticA)m).getMaximumPresentStaticDraughtMetres()));
        }
        return Optional.absent();
    }
}

