/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.navigation;

import au.gov.amsa.ais.message.AisShipStaticUtil;
import au.gov.amsa.risky.format.AisClass;
import au.gov.amsa.streams.Strings;
import com.github.davidmoten.rx.Checked;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import rx.Observable;
import rx.functions.Action1;

public final class ShipStaticData {
    public static Map<Long, Info> getMapFromResource(String resource) {
        return ShipStaticData.getMapFromReader(new InputStreamReader(ShipStaticData.class.getResourceAsStream(resource), Charsets.UTF_8));
    }

    public static Map<Long, Info> getMapFromReader(Reader reader) {
        return (Map)ShipStaticData.from(reader).toMap(info -> info.mmsi).toBlocking().single();
    }

    public static Observable<Info> fromAndClose(Reader reader) {
        return Observable.using(() -> reader, r -> ShipStaticData.from(r), (Action1)Checked.a1(r -> r.close()));
    }

    public static Observable<Info> from(String resource) {
        return Observable.using(() -> new InputStreamReader(ShipStaticData.class.getResourceAsStream(resource)), r -> ShipStaticData.from(r), (Action1)Checked.a1(r -> r.close()));
    }

    public static Observable<Info> from(Reader reader) {
        return Strings.lines((Reader)reader).filter(line -> !line.startsWith("#")).map(line -> line.trim()).filter(line -> line.length() > 0).map(line -> line.split("\t")).map(items -> {
            String imoTemp;
            int i = 0;
            long mmsi = Long.parseLong(items[i++]);
            Optional imo = (imoTemp = items[i++]).trim().length() == 0 || Integer.parseInt(imoTemp.trim()) == -1 ? Optional.absent() : Optional.of((Object)imoTemp);
            AisClass cls = items[i++].equals("A") ? AisClass.A : AisClass.B;
            int type = Integer.parseInt(items[i++]);
            Optional shipType = type == -1 ? Optional.absent() : Optional.of((Object)type);
            float draft = Float.parseFloat(items[i++]);
            Optional maxDraftMetres = draft == -1.0f ? Optional.absent() : Optional.of((Object)Float.valueOf(draft));
            int a = Integer.parseInt(items[i++]);
            int b = Integer.parseInt(items[i++]);
            int c = Integer.parseInt(items[i++]);
            int d = Integer.parseInt(items[i++]);
            Optional dimensionAMetres = a == -1 ? Optional.absent() : Optional.of((Object)a);
            Optional dimensionBMetres = b == -1 ? Optional.absent() : Optional.of((Object)b);
            Optional dimensionCMetres = c == -1 ? Optional.absent() : Optional.of((Object)c);
            Optional dimensionDMetres = d == -1 ? Optional.absent() : Optional.of((Object)d);
            Optional name = (i += 2) >= ((String[])items).length || items[i].trim().length() == 0 ? Optional.absent() : Optional.of((Object)items[i].trim());
            return new Info(mmsi, (Optional<String>)imo, cls, (Optional<Integer>)shipType, (Optional<Float>)maxDraftMetres, (Optional<Integer>)dimensionAMetres, (Optional<Integer>)dimensionBMetres, (Optional<Integer>)dimensionCMetres, (Optional<Integer>)dimensionDMetres, (Optional<String>)name);
        });
    }

    public static class Info {
        public final long mmsi;
        public final Optional<String> imo;
        public final AisClass cls;
        public final Optional<Integer> shipType;
        public final Optional<Float> maxDraftMetres;
        public final Optional<Integer> dimensionAMetres;
        public final Optional<Integer> dimensionBMetres;
        public final Optional<Integer> dimensionCMetres;
        public final Optional<Integer> dimensionDMetres;
        public final Optional<String> name;

        public Info(long mmsi, Optional<String> imo, AisClass cls, Optional<Integer> shipType, Optional<Float> maxDraftMetres, Optional<Integer> dimensionAMetres, Optional<Integer> dimensionBMetres, Optional<Integer> dimensionCMetres, Optional<Integer> dimensionDMetres, Optional<String> name) {
            this.mmsi = mmsi;
            this.imo = imo;
            this.cls = cls;
            this.shipType = shipType;
            this.maxDraftMetres = maxDraftMetres;
            this.dimensionAMetres = dimensionAMetres;
            this.dimensionBMetres = dimensionBMetres;
            this.dimensionCMetres = dimensionCMetres;
            this.dimensionDMetres = dimensionDMetres;
            this.name = name;
        }

        public Optional<Integer> lengthMetres() {
            return AisShipStaticUtil.lengthMetres(this.dimensionAMetres, this.dimensionBMetres, this.dimensionCMetres, this.dimensionDMetres);
        }

        public Optional<Integer> widthMetres() {
            return AisShipStaticUtil.widthMetres(this.dimensionAMetres, this.dimensionBMetres, this.dimensionCMetres, this.dimensionDMetres);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Info [mmsi=");
            builder.append(this.mmsi);
            builder.append(", imo=");
            builder.append(this.imo);
            builder.append(", cls=");
            builder.append(this.cls);
            builder.append(", shipType=");
            builder.append(this.shipType);
            builder.append(", maxDraftMetres=");
            builder.append(this.maxDraftMetres);
            builder.append(", dimensionAMetres=");
            builder.append(this.dimensionAMetres.or((Object)-1));
            builder.append(", dimensionBMetres=");
            builder.append(this.dimensionBMetres.or((Object)-1));
            builder.append(", dimensionCMetres=");
            builder.append(this.dimensionCMetres.or((Object)-1));
            builder.append(", dimensionDMetres=");
            builder.append(this.dimensionDMetres.or((Object)-1));
            builder.append(", name=");
            builder.append((String)this.name.or((Object)""));
            builder.append("]");
            return builder.toString();
        }
    }
}

