/*
 * Decompiled with CFR 0.152.
 */
package au.gov.amsa.navigation;

import com.google.common.base.Preconditions;

public class Region {
    private final double topLeftLat;
    private final double topLeftLon;
    private final double bottomRightLat;
    private final double bottomRightLon;

    public Region(double topLeftLat, double topLeftLon, double bottomLeftLat, double bottomRightLon) {
        Preconditions.checkArgument((bottomLeftLat <= topLeftLat ? 1 : 0) != 0);
        Preconditions.checkArgument((topLeftLon <= bottomRightLon ? 1 : 0) != 0);
        this.topLeftLat = topLeftLat;
        this.topLeftLon = topLeftLon;
        this.bottomRightLat = bottomLeftLat;
        this.bottomRightLon = bottomRightLon;
    }

    public double topLeftLat() {
        return this.topLeftLat;
    }

    public double topLeftLon() {
        return this.topLeftLon;
    }

    public double bottomRightLat() {
        return this.bottomRightLat;
    }

    public double bottomRightLon() {
        return this.bottomRightLon;
    }

    public boolean inRegion(double lat, double lon) {
        return lat >= this.bottomRightLat && lat <= this.topLeftLat && lon >= this.topLeftLon && lon <= this.bottomRightLon;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.bottomRightLat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.bottomRightLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.topLeftLat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.topLeftLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Region other = (Region)obj;
        if (Double.doubleToLongBits(this.bottomRightLat) != Double.doubleToLongBits(other.bottomRightLat)) {
            return false;
        }
        if (Double.doubleToLongBits(this.bottomRightLon) != Double.doubleToLongBits(other.bottomRightLon)) {
            return false;
        }
        if (Double.doubleToLongBits(this.topLeftLat) != Double.doubleToLongBits(other.topLeftLat)) {
            return false;
        }
        return Double.doubleToLongBits(this.topLeftLon) == Double.doubleToLongBits(other.topLeftLon);
    }
}

